/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.resid_builder;

import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDBuilder;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.resid_builder.ReSID;
import de.quippy.sidplay.resid_builder.sid_filter_t;
import java.util.ArrayList;

public class ReSIDBuilder
extends SIDBuilder {
    protected ArrayList<SIDEmu> sidobjs = new ArrayList();
    private static final String ERR_FILTER_DEFINITION = "RESID ERROR: Filter definition is not valid (see docs).";
    private String m_error = "N/A";

    public ReSIDBuilder(String name) {
        super(name);
    }

    public int devices(boolean created) {
        this.m_status = true;
        if (created) {
            return this.sidobjs.size();
        }
        return 0;
    }

    public int create(int sids) {
        ReSID sid = null;
        this.m_status = true;
        int count = this.devices(false);
        if (!this.m_status) {
            this.m_status = false;
            return count;
        }
        if (count != 0 && count < sids) {
            sids = count;
        }
        count = 0;
        while (count < sids) {
            sid = new ReSID(this);
            if (!sid.bool()) {
                this.m_error = sid.error();
                this.m_status = false;
                sid = null;
                return count;
            }
            this.sidobjs.add(sid);
            ++count;
        }
        return count;
    }

    public SIDEmu lock(C64Env env, ISID2Types.sid2_model_t model) {
        int size = this.sidobjs.size();
        this.m_status = true;
        int i = 0;
        while (i < size) {
            ReSID sid = (ReSID)this.sidobjs.get(i);
            if (sid.lock(env)) {
                sid.model(model);
                return sid;
            }
            ++i;
        }
        this.m_status = false;
        this.m_error = String.valueOf(this.name()) + " ERROR: No available SIDs to lock";
        return null;
    }

    public void unlock(SIDEmu device) {
        int size = this.sidobjs.size();
        int i = 0;
        while (i < size) {
            ReSID sid = (ReSID)this.sidobjs.get(i);
            if (sid == device) {
                sid.lock(null);
                break;
            }
            ++i;
        }
    }

    public void remove() {
        int size = this.sidobjs.size();
        int i = 0;
        while (i < size) {
            this.sidobjs.remove(this.sidobjs.get(i));
            ++i;
        }
        this.sidobjs.clear();
    }

    public final String error() {
        return this.m_error;
    }

    public final String credits() {
        this.m_status = true;
        if (this.sidobjs.size() != 0) {
            ReSID sid = (ReSID)this.sidobjs.get(0);
            return sid.credits();
        }
        ReSID sid = new ReSID(this);
        return sid.credits();
    }

    public void filter(boolean enable) {
        int size = this.sidobjs.size();
        this.m_status = true;
        int i = 0;
        while (i < size) {
            ReSID sid = (ReSID)this.sidobjs.get(i);
            sid.filter(enable);
            ++i;
        }
    }

    public void filter(sid_filter_t filter) {
        int size = this.sidobjs.size();
        this.m_status = true;
        int i = 0;
        while (i < size) {
            ReSID sid = (ReSID)this.sidobjs.get(i);
            if (!sid.filter(filter)) {
                this.m_error = ERR_FILTER_DEFINITION;
                this.m_status = false;
            }
            ++i;
        }
    }

    public void sampling(long freq) {
        int size = this.sidobjs.size();
        this.m_status = true;
        int i = 0;
        while (i < size) {
            ReSID sid = (ReSID)this.sidobjs.get(i);
            sid.sampling(freq);
            ++i;
        }
    }
}

