/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.resid_builder;

import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDBuilder;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.resid_builder.resid.ISIDDefs;
import de.quippy.sidplay.resid_builder.resid.SID;
import de.quippy.sidplay.resid_builder.sid_filter_t;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReSID
extends SIDEmu {
    private static final Logger RESID = Logger.getLogger(ReSID.class.getName());
    private static final String VERSION = "0.0.2";
    private IEventContext m_context = null;
    private Event.event_phase_t m_phase = Event.event_phase_t.EVENT_CLOCK_PHI1;
    private SID m_sid = new SID();
    private long m_accessClk;
    private long m_gain = 100L;
    private static String m_credit;
    private final String m_error;
    private boolean m_status = true;
    private boolean m_locked = false;
    private byte m_optimisation = 0;

    public ReSID(SIDBuilder builder) {
        super(builder);
        m_credit = "ReSID V0.0.2 Engine:";
        m_credit = String.valueOf(m_credit) + "\t(C) 1999-2002 Simon White <sidplay2@yahoo.com>";
        m_credit = String.valueOf(m_credit) + "MOS6581 (SID) Emulation (ReSID V0.15):";
        m_credit = String.valueOf(m_credit) + "\t(C) 1999-2002 Dag Lem <resid@nimrod.no>";
        if (this.m_sid == null) {
            this.m_error = "RESID ERROR: Unable to create sid object";
            this.m_status = false;
            return;
        }
        this.m_error = "N/A";
        this.reset((short)0);
    }

    public final String credits() {
        return m_credit;
    }

    public void reset() {
        super.reset();
    }

    public void reset(short volume) {
        this.m_accessClk = 0L;
        this.m_sid.reset();
        this.m_sid.write(24, volume);
    }

    /*
     * Unable to fully structure code
     */
    public short read(short addr) {
        block3: {
            cycles = this.m_context.getTime(this.m_accessClk, this.m_phase);
            this.m_accessClk += cycles;
            if (this.m_optimisation == 0) ** GOTO lbl8
            if (cycles == 0L) break block3;
            this.m_sid.clock((int)cycles);
            break block3;
lbl-1000:
            // 1 sources

            {
                this.m_sid.clock();
lbl8:
                // 2 sources

                ** while (cycles-- != 0L)
            }
        }
        return (short)this.m_sid.read(addr);
    }

    /*
     * Unable to fully structure code
     */
    public void write(short addr, short data) {
        block5: {
            if (ReSID.RESID.isLoggable(Level.FINE)) {
                ReSID.RESID.fine(String.format("write 0x%02x=0x%02x", new Object[]{new Short(addr), new Short(data)}));
                ReSID.RESID.fine("\n");
            }
            cycles = this.m_context.getTime(this.m_accessClk, this.m_phase);
            this.m_accessClk += cycles;
            if (this.m_optimisation == 0) ** GOTO lbl11
            if (cycles == 0L) break block5;
            this.m_sid.clock((int)cycles);
            break block5;
lbl-1000:
            // 1 sources

            {
                this.m_sid.clock();
lbl11:
                // 2 sources

                ** while (cycles-- != 0L)
            }
        }
        this.m_sid.write(addr, data);
    }

    public final String error() {
        return this.m_error;
    }

    /*
     * Unable to fully structure code
     */
    public long output(short bits) {
        block3: {
            cycles = this.m_context.getTime(this.m_accessClk, this.m_phase);
            this.m_accessClk += cycles;
            if (this.m_optimisation == 0) ** GOTO lbl8
            if (cycles == 0L) break block3;
            this.m_sid.clock((int)cycles);
            break block3;
lbl-1000:
            // 1 sources

            {
                this.m_sid.clock();
lbl8:
                // 2 sources

                ** while (cycles-- != 0L)
            }
        }
        return (long)this.m_sid.output(bits) * this.m_gain / 100L;
    }

    public void filter(boolean enable) {
        this.m_sid.enable_filter(enable);
    }

    public void voice(short num, short volume, boolean mute) {
        this.m_sid.mute(num, mute);
    }

    public void gain(short percent) {
        this.m_gain = percent;
        this.m_gain += 100L;
        if (this.m_gain > 200L) {
            this.m_gain = 200L;
        }
    }

    public void optimisation(byte level) {
        this.m_optimisation = level;
    }

    public boolean bool() {
        return this.m_status;
    }

    public void sampling(long freq) {
        this.m_sid.set_sampling_parameters(1000000.0, ISIDDefs.sampling_method.SAMPLE_FAST, freq, -1.0, 0.79);
    }

    public boolean filter(sid_filter_t filter) {
        int[][] fc;
        int[][] f0 = fc = new int[2050][2];
        int points = 0;
        if (filter == null) {
            SID.FCPoints fcp = new SID.FCPoints(this.m_sid);
            this.m_sid.fc_default(fcp);
            fc = fcp.points;
            points = fcp.count;
        } else {
            int[] fstart;
            points = filter.points;
            if (points < 2 || points > 2048) {
                return false;
            }
            int[] nArray = new int[2];
            nArray[0] = -1;
            int[] fprev = fstart = nArray;
            int fin = 0;
            int fout = 0;
            while (points-- > 0) {
                if (fprev[0] >= filter.cutoff[fin][0]) {
                    return false;
                }
                fc[++fout][0] = filter.cutoff[fin][0];
                fc[fout][1] = filter.cutoff[fin][1];
                fprev = filter.cutoff[fin++];
            }
            fc[fout + 1][0] = fc[fout][0];
            fc[fout + 1][1] = fc[fout][1];
            fc[0][0] = fc[1][0];
            fc[0][1] = fc[1][1];
            points = filter.points + 2;
        }
        this.m_sid.filter.interpolate(f0, 0, --points, this.m_sid.fc_plotter(), 1.0);
        if (filter != null && filter.Lthreshold != 0) {
            this.m_sid.set_distortion_properties(filter.Lthreshold, filter.Lsteepness, filter.Llp, filter.Lbp, filter.Lhp, filter.Hthreshold, filter.Hsteepness, filter.Hlp, filter.Hbp, filter.Hhp);
        }
        return true;
    }

    public void model(ISID2Types.sid2_model_t model) {
        if (model == ISID2Types.sid2_model_t.SID2_MOS8580) {
            this.m_sid.set_chip_model(ISIDDefs.chip_model.MOS8580);
        } else {
            this.m_sid.set_chip_model(ISIDDefs.chip_model.MOS6581);
        }
    }

    public boolean lock(C64Env env) {
        if (env == null) {
            if (!this.m_locked) {
                return false;
            }
            this.m_locked = false;
            this.m_context = null;
        } else {
            if (this.m_locked) {
                return false;
            }
            this.m_locked = true;
            this.m_context = env.context();
        }
        return true;
    }
}

