/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.xsid;

import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.libsidplay.components.xsid.XSID;

public class C64XSID
extends XSID {
    private C64Env m_env;
    private SIDEmu m_sid;
    private long m_gain;

    protected short readMemByte(int addr) {
        short data = this.m_env.readMemRamByte(addr);
        this.m_env.sid2crc(data);
        return data;
    }

    protected void writeMemByte(short data) {
        this.m_sid.write((short)24, data);
    }

    public C64XSID(C64Env env, SIDEmu sid) {
        super(env.context());
        this.m_env = env;
        this.m_sid = sid;
        this.m_gain = 100L;
    }

    public final String error() {
        return "";
    }

    public void reset() {
        super.reset();
    }

    public void reset(short volume) {
        super.reset(volume);
        this.m_sid.reset(volume);
    }

    public short read(short addr) {
        return this.m_sid.read(addr);
    }

    public void write(short addr, short data) {
        if (addr == 24) {
            super.storeSidData0x18(data);
        } else {
            this.m_sid.write(addr, data);
        }
    }

    public void write16(int addr, short data) {
        super.write(addr, data);
    }

    public long output(short bits) {
        return this.m_sid.output(bits) + super.output(bits) * this.m_gain / 100L;
    }

    public void voice(short num, short vol, boolean mute) {
        if (num == 3) {
            super.mute(mute);
        } else {
            this.m_sid.voice(num, vol, mute);
        }
    }

    public void gain(short percent) {
        this.m_gain = percent;
        this.m_gain += 100L;
        if (this.m_gain > 200L) {
            this.m_gain = 200L;
        }
    }

    public void emulation(SIDEmu sid) {
        this.m_sid = sid;
    }

    public SIDEmu emulation() {
        return this.m_sid;
    }
}

