/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.sidtune;

import de.quippy.sidplay.libsidplay.common.SIDEndian;
import de.quippy.sidplay.libsidplay.components.sidtune.Buffer_sidtt;
import de.quippy.sidplay.libsidplay.components.sidtune.InfoFile;
import de.quippy.sidplay.libsidplay.components.sidtune.Mus;
import de.quippy.sidplay.libsidplay.components.sidtune.P00;
import de.quippy.sidplay.libsidplay.components.sidtune.PP20;
import de.quippy.sidplay.libsidplay.components.sidtune.PSid;
import de.quippy.sidplay.libsidplay.components.sidtune.Prg;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import de.quippy.sidplay.libsidplay.components.sidtune.SmartPtr_sidtt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class SidTune {
    private static final Logger TUNE = Logger.getLogger(SidTune.class.getName());
    public static final int SIDTUNE_MAX_SONGS = 256;
    public static final int SIDTUNE_MAX_CREDIT_STRINGS = 10;
    public static final int SIDTUNE_MAX_CREDIT_STRLEN = 81;
    public static final int SIDTUNE_MAX_MEMORY = 65536;
    public static final int SIDTUNE_MAX_FILELEN = 65662;
    public static final int SIDTUNE_SPEED_VBI = 0;
    public static final int SIDTUNE_SPEED_CIA_1A = 60;
    public static final int SIDTUNE_CLOCK_UNKNOWN = 0;
    public static final int SIDTUNE_CLOCK_PAL = 1;
    public static final int SIDTUNE_CLOCK_NTSC = 2;
    public static final int SIDTUNE_CLOCK_ANY = 3;
    public static final int SIDTUNE_SIDMODEL_UNKNOWN = 0;
    public static final int SIDTUNE_SIDMODEL_6581 = 1;
    public static final int SIDTUNE_SIDMODEL_8580 = 2;
    public static final int SIDTUNE_SIDMODEL_ANY = 3;
    public static final int SIDTUNE_COMPATIBILITY_C64 = 0;
    public static final int SIDTUNE_COMPATIBILITY_PSID = 1;
    public static final int SIDTUNE_COMPATIBILITY_R64 = 2;
    public static final int SIDTUNE_COMPATIBILITY_BASIC = 3;
    protected SidTuneInfo info = new SidTuneInfo();
    protected boolean status;
    protected short[] songSpeed = new short[256];
    protected short[] clockSpeed = new short[256];
    protected short[] songLength = new short[256];
    protected String[] infoString = new String[10];
    protected int fileOffset;
    protected int musDataLen;
    protected Buffer_sidtt cache = new Buffer_sidtt();
    private static final String[] defaultFileNameExt = new String[]{".sid", ".dat", ".inf", "", ".DAT", ".SID", ".INF", ".c64", ".prg", ".p00", ".C64", ".PRG", ".P00", ".info", ".INFO", ".data", ".DATA", ".str", ".STR", ".mus", ".MUS"};
    protected static String[] fileNameExtensions = defaultFileNameExt;
    private PSid psid = new PSid(this);
    Mus mus = new Mus(this);
    InfoFile inf = new InfoFile(this);
    Prg prg = new Prg(this);
    P00 p00 = new P00(this);
    protected static final String txt_songNumberExceed = "SIDTUNE WARNING: Selected song number was too high";
    protected static final String txt_empty = "SIDTUNE ERROR: No data to load";
    protected static final String txt_unrecognizedFormat = "SIDTUNE ERROR: Could not determine file format";
    protected static final String txt_noDataFile = "SIDTUNE ERROR: Did not find the corresponding data file";
    protected static final String txt_notEnoughMemory = "SIDTUNE ERROR: Not enough free memory";
    protected static final String txt_cantLoadFile = "SIDTUNE ERROR: Could not load input file";
    protected static final String txt_cantOpenFile = "SIDTUNE ERROR: Could not open file for binary input";
    protected static final String txt_fileTooLong = "SIDTUNE ERROR: Input data too long";
    protected static final String txt_dataTooLong = "SIDTUNE ERROR: Size of music data exceeds C64 memory";
    protected static final String txt_cantCreateFile = "SIDTUNE ERROR: Could not create output file";
    protected static final String txt_fileIoError = "SIDTUNE ERROR: File I/O error";
    protected static final String txt_VBI = "VBI";
    protected static final String txt_CIA = "CIA 1 Timer A";
    protected static final String txt_noErrors = "No errors";
    protected static final String txt_na = "N/A";
    protected static final String txt_badAddr = "SIDTUNE ERROR: Bad address data";
    protected static final String txt_badReloc = "SIDTUNE ERROR: Bad reloc data";
    protected static final String txt_corrupt = "SIDTUNE ERROR: File is incomplete or corrupt";
    private static final short[] _sidtune_CHRtab;

    static {
        short[] sArray = new short[256];
        sArray[1] = 1;
        sArray[2] = 1;
        sArray[3] = 1;
        sArray[4] = 1;
        sArray[5] = 1;
        sArray[6] = 1;
        sArray[7] = 1;
        sArray[8] = 1;
        sArray[9] = 1;
        sArray[10] = 1;
        sArray[11] = 1;
        sArray[12] = 1;
        sArray[13] = 13;
        sArray[14] = 1;
        sArray[15] = 1;
        sArray[16] = 1;
        sArray[17] = 1;
        sArray[18] = 1;
        sArray[19] = 1;
        sArray[20] = 1;
        sArray[21] = 1;
        sArray[22] = 1;
        sArray[23] = 1;
        sArray[24] = 1;
        sArray[25] = 1;
        sArray[26] = 1;
        sArray[27] = 1;
        sArray[28] = 1;
        sArray[29] = 1;
        sArray[30] = 1;
        sArray[31] = 1;
        sArray[32] = 32;
        sArray[33] = 33;
        sArray[34] = 1;
        sArray[35] = 35;
        sArray[36] = 36;
        sArray[37] = 37;
        sArray[38] = 38;
        sArray[39] = 39;
        sArray[40] = 40;
        sArray[41] = 41;
        sArray[42] = 42;
        sArray[43] = 43;
        sArray[44] = 44;
        sArray[45] = 45;
        sArray[46] = 46;
        sArray[47] = 47;
        sArray[48] = 48;
        sArray[49] = 49;
        sArray[50] = 50;
        sArray[51] = 51;
        sArray[52] = 52;
        sArray[53] = 53;
        sArray[54] = 54;
        sArray[55] = 55;
        sArray[56] = 56;
        sArray[57] = 57;
        sArray[58] = 58;
        sArray[59] = 59;
        sArray[60] = 60;
        sArray[61] = 61;
        sArray[62] = 62;
        sArray[63] = 63;
        sArray[64] = 64;
        sArray[65] = 65;
        sArray[66] = 66;
        sArray[67] = 67;
        sArray[68] = 68;
        sArray[69] = 69;
        sArray[70] = 70;
        sArray[71] = 71;
        sArray[72] = 72;
        sArray[73] = 73;
        sArray[74] = 74;
        sArray[75] = 75;
        sArray[76] = 76;
        sArray[77] = 77;
        sArray[78] = 78;
        sArray[79] = 79;
        sArray[80] = 80;
        sArray[81] = 81;
        sArray[82] = 82;
        sArray[83] = 83;
        sArray[84] = 84;
        sArray[85] = 85;
        sArray[86] = 86;
        sArray[87] = 87;
        sArray[88] = 88;
        sArray[89] = 89;
        sArray[90] = 90;
        sArray[91] = 91;
        sArray[92] = 36;
        sArray[93] = 93;
        sArray[94] = 32;
        sArray[95] = 32;
        sArray[96] = 45;
        sArray[97] = 35;
        sArray[98] = 124;
        sArray[99] = 45;
        sArray[100] = 45;
        sArray[101] = 45;
        sArray[102] = 45;
        sArray[103] = 124;
        sArray[104] = 124;
        sArray[105] = 92;
        sArray[106] = 92;
        sArray[107] = 47;
        sArray[108] = 92;
        sArray[109] = 92;
        sArray[110] = 47;
        sArray[111] = 47;
        sArray[112] = 92;
        sArray[113] = 35;
        sArray[114] = 95;
        sArray[115] = 35;
        sArray[116] = 124;
        sArray[117] = 47;
        sArray[118] = 88;
        sArray[119] = 79;
        sArray[120] = 35;
        sArray[121] = 124;
        sArray[122] = 35;
        sArray[123] = 43;
        sArray[124] = 124;
        sArray[125] = 124;
        sArray[126] = 38;
        sArray[127] = 92;
        sArray[128] = 1;
        sArray[129] = 1;
        sArray[130] = 1;
        sArray[131] = 1;
        sArray[132] = 1;
        sArray[133] = 1;
        sArray[134] = 1;
        sArray[135] = 1;
        sArray[136] = 1;
        sArray[137] = 1;
        sArray[138] = 1;
        sArray[139] = 1;
        sArray[140] = 1;
        sArray[141] = 1;
        sArray[142] = 1;
        sArray[143] = 1;
        sArray[144] = 1;
        sArray[145] = 1;
        sArray[146] = 1;
        sArray[147] = 1;
        sArray[148] = 1;
        sArray[149] = 1;
        sArray[150] = 1;
        sArray[151] = 1;
        sArray[152] = 1;
        sArray[153] = 1;
        sArray[154] = 1;
        sArray[155] = 1;
        sArray[156] = 1;
        sArray[157] = 1;
        sArray[158] = 1;
        sArray[159] = 1;
        sArray[160] = 32;
        sArray[161] = 124;
        sArray[162] = 35;
        sArray[163] = 45;
        sArray[164] = 45;
        sArray[165] = 124;
        sArray[166] = 35;
        sArray[167] = 124;
        sArray[168] = 35;
        sArray[169] = 47;
        sArray[170] = 124;
        sArray[171] = 124;
        sArray[172] = 47;
        sArray[173] = 92;
        sArray[174] = 92;
        sArray[175] = 45;
        sArray[176] = 47;
        sArray[177] = 45;
        sArray[178] = 45;
        sArray[179] = 124;
        sArray[180] = 124;
        sArray[181] = 124;
        sArray[182] = 124;
        sArray[183] = 45;
        sArray[184] = 45;
        sArray[185] = 45;
        sArray[186] = 47;
        sArray[187] = 92;
        sArray[188] = 92;
        sArray[189] = 47;
        sArray[190] = 47;
        sArray[191] = 35;
        sArray[192] = 45;
        sArray[193] = 35;
        sArray[194] = 124;
        sArray[195] = 45;
        sArray[196] = 45;
        sArray[197] = 45;
        sArray[198] = 45;
        sArray[199] = 124;
        sArray[200] = 124;
        sArray[201] = 92;
        sArray[202] = 92;
        sArray[203] = 47;
        sArray[204] = 92;
        sArray[205] = 92;
        sArray[206] = 47;
        sArray[207] = 47;
        sArray[208] = 92;
        sArray[209] = 35;
        sArray[210] = 95;
        sArray[211] = 35;
        sArray[212] = 124;
        sArray[213] = 47;
        sArray[214] = 88;
        sArray[215] = 79;
        sArray[216] = 35;
        sArray[217] = 124;
        sArray[218] = 35;
        sArray[219] = 43;
        sArray[220] = 124;
        sArray[221] = 124;
        sArray[222] = 38;
        sArray[223] = 92;
        sArray[224] = 32;
        sArray[225] = 124;
        sArray[226] = 35;
        sArray[227] = 45;
        sArray[228] = 45;
        sArray[229] = 124;
        sArray[230] = 35;
        sArray[231] = 124;
        sArray[232] = 35;
        sArray[233] = 47;
        sArray[234] = 124;
        sArray[235] = 124;
        sArray[236] = 47;
        sArray[237] = 92;
        sArray[238] = 92;
        sArray[239] = 45;
        sArray[240] = 47;
        sArray[241] = 45;
        sArray[242] = 45;
        sArray[243] = 124;
        sArray[244] = 124;
        sArray[245] = 124;
        sArray[246] = 124;
        sArray[247] = 45;
        sArray[248] = 45;
        sArray[249] = 45;
        sArray[250] = 47;
        sArray[251] = 92;
        sArray[252] = 92;
        sArray[253] = 47;
        sArray[254] = 47;
        sArray[255] = 35;
        _sidtune_CHRtab = sArray;
    }

    public SidTune(String fileName, String[] fileNameExt) {
        this.init();
        this.setFileNameExtensions(fileNameExt);
        if (fileName != null && fileName.equals("-")) {
            this.getFromStdIn();
        } else if (fileName != null) {
            this.getFromFiles(fileName);
        }
    }

    public SidTune(short[] oneFileFormatSidtune, int sidtuneLength) {
        this.init();
        this.getFromBuffer(oneFileFormatSidtune, sidtuneLength);
    }

    public void setFileNameExtensions(String[] fileNameExt) {
        fileNameExtensions = fileNameExt != null ? fileNameExt : defaultFileNameExt;
    }

    public boolean load(String fileName) {
        this.cleanup();
        this.init();
        if (fileName != null && fileName.equals("-")) {
            this.getFromStdIn();
        } else if (fileName != null) {
            this.getFromFiles(fileName);
        }
        return this.status;
    }

    public boolean read(short[] sourceBuffer, int bufferLen) {
        this.cleanup();
        this.init();
        this.getFromBuffer(sourceBuffer, bufferLen);
        return this.status;
    }

    public final SidTuneInfo opGet(int songNum) {
        this.selectSong(songNum);
        return this.info;
    }

    public int selectSong(int selectedSong) {
        if (!this.status) {
            return 0;
        }
        this.info.statusString = txt_noErrors;
        int song = selectedSong;
        if (selectedSong == 0) {
            song = this.info.startSong;
        }
        if (selectedSong > this.info.songs || selectedSong > 256) {
            song = this.info.startSong;
            this.info.statusString = txt_songNumberExceed;
        }
        this.info.currentSong = song;
        this.info.songLength = this.songLength[song - 1];
        this.info.songSpeed = this.info.compatibility == 2 ? (short)60 : this.songSpeed[song - 1];
        this.info.clockSpeed = this.clockSpeed[song - 1];
        this.info.speedString = this.info.songSpeed == 0 ? txt_VBI : txt_CIA;
        return this.info.currentSong;
    }

    public final SidTuneInfo getInfo() {
        return this.info;
    }

    public boolean bool() {
        return this.status;
    }

    public boolean getStatus() {
        return this.status;
    }

    public boolean isStereo() {
        return this.info.sidChipBase1 != 0 && this.info.sidChipBase2 != 0;
    }

    public boolean placeSidTuneInC64mem(short[] c64buf) {
        if (this.status && c64buf != null) {
            int endPos = this.info.loadAddr + this.info.c64dataLen;
            if (endPos <= 65536) {
                System.arraycopy(this.cache.get(), this.fileOffset, c64buf, this.info.loadAddr, this.info.c64dataLen);
                this.info.statusString = txt_noErrors;
                int i = 0;
                while (i < this.info.c64dataLen) {
                    int j = 0;
                    while (j < 16 && i + j < this.info.c64dataLen) {
                        TUNE.fine(String.format("0x%02x ", new Short(c64buf[this.info.loadAddr + i + j])));
                        ++j;
                    }
                    TUNE.fine("\n");
                    i += 16;
                }
            } else {
                System.arraycopy(this.cache.get(), this.fileOffset, c64buf, this.info.loadAddr, this.info.c64dataLen - (endPos - 65536));
                this.info.statusString = txt_dataTooLong;
            }
            if (this.info.musPlayer) {
                this.MUS_installPlayer(c64buf);
            }
        }
        return this.status && c64buf != null;
    }

    public boolean saveC64dataFile(String destFileName, boolean overWriteFlag) {
        boolean success = false;
        if (this.status) {
            try {
                FileOutputStream fMyOut = new FileOutputStream(destFileName, !overWriteFlag);
                if (!this.info.musPlayer) {
                    short[] saveAddr = new short[]{(short)(this.info.loadAddr & 0xFF), (short)(this.info.loadAddr >> 8)};
                    fMyOut.write(saveAddr[0]);
                    fMyOut.write(saveAddr[1]);
                }
                if (!this.saveToOpenFile(fMyOut, this.cache.get(), this.fileOffset, this.info.dataFileLen - this.fileOffset)) {
                    this.info.statusString = txt_fileIoError;
                } else {
                    this.info.statusString = txt_noErrors;
                    success = true;
                }
                fMyOut.close();
            }
            catch (IOException e) {
                this.info.statusString = txt_cantCreateFile;
            }
        }
        return success;
    }

    public boolean saveSIDfile(String destFileName, boolean overWriteFlag) {
        boolean success = false;
        if (this.status) {
            try {
                FileOutputStream fMyOut = new FileOutputStream(destFileName, !overWriteFlag);
                if (!this.SID_fileSupportSave(fMyOut)) {
                    this.info.statusString = txt_fileIoError;
                } else {
                    this.info.statusString = txt_noErrors;
                    success = true;
                }
                fMyOut.close();
            }
            catch (IOException e) {
                this.info.statusString = txt_cantCreateFile;
            }
        }
        return success;
    }

    public boolean savePSIDfile(String destFileName, boolean overWriteFlag) {
        boolean success = false;
        if (this.status) {
            try {
                FileOutputStream fMyOut = new FileOutputStream(destFileName, !overWriteFlag);
                if (!this.PSID_fileSupportSave(fMyOut, this.cache.get())) {
                    this.info.statusString = txt_fileIoError;
                } else {
                    this.info.statusString = txt_noErrors;
                    success = true;
                }
                fMyOut.close();
            }
            catch (IOException e) {
                this.info.statusString = txt_cantCreateFile;
            }
        }
        return success;
    }

    public void fixLoadAddress(boolean force, int init, int play) {
        if (this.info.fixLoad || force) {
            this.info.fixLoad = false;
            this.info.loadAddr += 2;
            this.fileOffset += 2;
            if (force) {
                this.info.initAddr = init;
                this.info.playAddr = play;
            }
        }
    }

    public boolean loadFile(String fileName, Buffer_sidtt bufferRef) {
        FileInputStream myIn;
        int fileLen;
        Buffer_sidtt fileBuf;
        block8: {
            fileBuf = new Buffer_sidtt();
            fileLen = 0;
            File file = new File(fileName);
            if (!file.exists() || !file.canRead()) {
                this.info.statusString = txt_cantOpenFile;
                return false;
            }
            myIn = new FileInputStream(file);
            fileLen = (int)file.length();
            if (fileBuf.assign(new short[fileLen], fileLen)) break block8;
            this.info.statusString = txt_notEnoughMemory;
            return false;
        }
        try {
            int restFileLen = fileLen;
            if (restFileLen > 0) {
                int i = 0;
                while (i < fileLen) {
                    fileBuf.get()[i] = (short)myIn.read();
                    ++i;
                }
            }
            this.info.statusString = txt_noErrors;
            myIn.close();
        }
        catch (IOException e) {
            this.info.statusString = txt_cantLoadFile;
            return false;
        }
        if (fileLen == 0) {
            this.info.statusString = txt_empty;
            return false;
        }
        if (this.decompressPP20(fileBuf) < 0) {
            return false;
        }
        bufferRef.assign(fileBuf.xferPtr(), fileBuf.xferLen());
        return true;
    }

    public boolean saveToOpenFile(OutputStream toFile, short[] buffer, int bufferOffset, int bufLen) {
        int lenToWrite = bufLen;
        try {
            if (lenToWrite > 0) {
                int i = bufLen - lenToWrite;
                while (i < lenToWrite) {
                    toFile.write(buffer[bufferOffset + i]);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.info.statusString = txt_fileIoError;
            return false;
        }
        this.info.statusString = txt_noErrors;
        return true;
    }

    protected void convertOldStyleSpeedToTables(long speed, short clock) {
        int toDo = this.info.songs <= 256 ? this.info.songs : 256;
        int s = 0;
        while (s < toDo) {
            this.clockSpeed[s] = clock;
            this.songSpeed[s] = (speed >> (s & 0x1F) & 1L) == 0L ? 0 : 60;
            ++s;
        }
    }

    protected int convertPetsciiToAscii(SmartPtr_sidtt spPet, StringBuffer dest) {
        int count = 0;
        if (dest != null) {
            short c;
            do {
                if ((c = _sidtune_CHRtab[spPet.operatorMal()]) >= 32 && count <= 31) {
                    dest.setLength(count + 1);
                    dest.setCharAt(count++, (char)c);
                }
                if (spPet.operatorMal() == 157 && count >= 0) {
                    --count;
                }
                spPet.operatorPlusPlus();
            } while (c != 13 && c != 0 && !spPet.fail());
        } else {
            short c;
            do {
                c = _sidtune_CHRtab[spPet.operatorMal()];
                spPet.operatorPlusPlus();
            } while (c != 13 && c != 0 && !spPet.fail());
        }
        return count;
    }

    protected boolean checkCompatibility() {
        switch (this.info.compatibility) {
            case 2: {
                switch (this.info.initAddr >> 12) {
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.info.statusString = txt_badAddr;
                        return false;
                    }
                }
                if (this.info.initAddr < this.info.loadAddr || this.info.initAddr > this.info.loadAddr + this.info.c64dataLen - 1) {
                    this.info.statusString = txt_badAddr;
                    return false;
                }
            }
            case 3: {
                if (this.info.loadAddr >= 2024) break;
                this.info.statusString = txt_badAddr;
                return false;
            }
        }
        return true;
    }

    protected boolean checkRelocInfo() {
        short startlp;
        if (this.info.relocStartPage == 255) {
            this.info.relocPages = 0;
            return true;
        }
        if (this.info.relocPages == 0) {
            this.info.relocStartPage = 0;
            return true;
        }
        short startp = this.info.relocStartPage;
        short endp = (short)(startp + this.info.relocPages - 1 & 0xFF);
        if (endp < startp) {
            this.info.statusString = txt_badReloc;
            return false;
        }
        short endlp = startlp = (short)(this.info.loadAddr >> 8);
        endlp = (short)(endlp + (short)(this.info.c64dataLen - 1 >> 8));
        if (startp <= startlp && endp >= startlp || startp <= endlp && endp >= endlp) {
            this.info.statusString = txt_badReloc;
            return false;
        }
        if (startp < 4 || 160 <= startp && startp <= 191 || startp >= 208 || 160 <= endp && endp <= 191 || endp >= 208) {
            this.info.statusString = txt_badReloc;
            return false;
        }
        return true;
    }

    protected boolean resolveAddrs(short[] c64data, int fileOffset2) {
        if (this.info.playAddr == 65535) {
            this.info.playAddr = 0;
        }
        if (this.info.loadAddr == 0) {
            if (this.info.c64dataLen < 2) {
                this.info.statusString = txt_corrupt;
                return false;
            }
            this.info.loadAddr = SIDEndian.endian_16(c64data[this.fileOffset + 1], c64data[this.fileOffset + 0]);
            this.fileOffset += 2;
            this.info.c64dataLen -= 2;
        }
        if (this.info.compatibility == 3) {
            if (this.info.initAddr != 0) {
                this.info.statusString = txt_badAddr;
                return false;
            }
        } else if (this.info.initAddr == 0) {
            this.info.initAddr = this.info.loadAddr;
        }
        return true;
    }

    protected LoadStatus PSID_fileSupport(Buffer_sidtt dataBuf) {
        return this.psid.PSID_fileSupport(dataBuf);
    }

    protected boolean PSID_fileSupportSave(OutputStream toFile, short[] dataBuffer) {
        return this.psid.PSID_fileSupportSave(toFile, dataBuffer);
    }

    protected LoadStatus SID_fileSupport(Buffer_sidtt dataBuf, Buffer_sidtt sidBuf) {
        return LoadStatus.LOAD_NOT_MINE;
    }

    protected boolean SID_fileSupportSave(OutputStream toFile) {
        return true;
    }

    protected LoadStatus MUS_fileSupport(Buffer_sidtt musBuf, Buffer_sidtt strBuf) {
        return this.mus.MUS_fileSupport(musBuf, strBuf);
    }

    protected LoadStatus MUS_load(Buffer_sidtt musBuf, boolean init) {
        return this.mus.MUS_load(musBuf, init);
    }

    protected LoadStatus MUS_load(Buffer_sidtt musBuf, Buffer_sidtt strBuf, boolean init) {
        return this.mus.MUS_load(musBuf, strBuf, init);
    }

    protected boolean MUS_detect(short[] buffer, int bufLen, Mus.Voice3Index voice3Index) {
        return this.mus.MUS_detect(buffer, bufLen, voice3Index);
    }

    protected boolean MUS_mergeParts(Buffer_sidtt musBuf, Buffer_sidtt strBuf) {
        return this.mus.MUS_mergeParts(musBuf, strBuf);
    }

    protected void MUS_setPlayerAddress() {
        this.mus.MUS_setPlayerAddress();
    }

    protected void MUS_installPlayer(short[] c64buf) {
        this.mus.MUS_installPlayer(c64buf);
    }

    protected LoadStatus INFO_fileSupport(Buffer_sidtt dataBuf, Buffer_sidtt infoBuf) {
        return this.inf.INFO_fileSupport(dataBuf, infoBuf);
    }

    protected LoadStatus PRG_fileSupport(String fileName, Buffer_sidtt dataBuf) {
        return this.prg.PRG_fileSupport(fileName, dataBuf);
    }

    protected LoadStatus X00_fileSupport(String fileName, Buffer_sidtt dataBuf) {
        return this.p00.X00_fileSupport(fileName, dataBuf);
    }

    private void init() {
        this.status = false;
        this.info.statusString = txt_na;
        this.info.dataFileName = null;
        this.info.infoFileName = null;
        this.info.path = null;
        this.info.c64dataLen = 0;
        this.info.dataFileLen = 0;
        this.info.formatString = txt_na;
        this.info.speedString = txt_na;
        this.info.playAddr = 0;
        this.info.initAddr = 0;
        this.info.loadAddr = 0;
        this.info.currentSong = 0;
        this.info.startSong = 0;
        this.info.songs = 0;
        this.info.sidChipBase1 = 54272;
        this.info.sidChipBase2 = 0;
        this.info.musPlayer = false;
        this.info.fixLoad = false;
        this.info.songSpeed = 0;
        this.info.clockSpeed = 0;
        this.info.sidModel = 0;
        this.info.compatibility = 0;
        this.info.songLength = 0;
        this.info.relocStartPage = 0;
        this.info.relocPages = 0;
        int si = 0;
        while (si < 256) {
            this.songSpeed[si] = this.info.songSpeed;
            this.clockSpeed[si] = this.info.clockSpeed;
            this.songLength[si] = 0;
            ++si;
        }
        this.fileOffset = 0;
        this.musDataLen = 0;
        int sNum = 0;
        while (sNum < 10) {
            this.infoString[sNum] = null;
            ++sNum;
        }
        this.info.numberOfInfoStrings = 0;
        this.info.numberOfCommentStrings = 1;
        this.info.commentString = new String[this.info.numberOfCommentStrings];
        this.info.commentString[0] = this.info.commentString != null ? "--- SAVED WITH SIDPLAY ---" : null;
    }

    private void cleanup() {
        this.info.commentString = null;
        this.deleteFileNameCopies();
        this.status = false;
    }

    private void getFromStdIn() {
        this.status = false;
        this.info.statusString = txt_notEnoughMemory;
        short[] fileBuf = new short[65662];
        int i = 0;
        try {
            int datb;
            while ((datb = System.in.read()) != -1 && i < 65662) {
                fileBuf[i++] = (short)datb;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.info.dataFileLen = i;
        this.getFromBuffer(fileBuf, this.info.dataFileLen);
        fileBuf = null;
    }

    private void getFromFiles(String fileName) {
        this.status = false;
        Buffer_sidtt fileBuf1 = new Buffer_sidtt();
        Buffer_sidtt fileBuf2 = new Buffer_sidtt();
        StringBuffer fileName2 = new StringBuffer();
        if (this.loadFile(fileName, fileBuf1)) {
            LoadStatus ret = this.PSID_fileSupport(fileBuf1);
            if (ret != LoadStatus.LOAD_NOT_MINE) {
                if (ret == LoadStatus.LOAD_OK) {
                    this.status = this.acceptSidTune(fileName, null, fileBuf1);
                }
                return;
            }
            ret = this.orStatus(this.SID_fileSupport(fileBuf2, fileBuf1), this.INFO_fileSupport(fileBuf2, fileBuf1));
            if (ret == LoadStatus.LOAD_NOT_MINE) {
                int n = 0;
                while (n < fileNameExtensions.length) {
                    if (!this.createNewFileName(fileName2, fileName, fileNameExtensions[n])) {
                        return;
                    }
                    if (!fileName.equalsIgnoreCase(fileName2.toString()) && this.loadFile(fileName2.toString(), fileBuf2) && (this.SID_fileSupport(fileBuf1, fileBuf2) == LoadStatus.LOAD_OK || this.INFO_fileSupport(fileBuf1, fileBuf2) == LoadStatus.LOAD_OK)) {
                        this.status = this.acceptSidTune(fileName, fileName2.toString(), fileBuf1);
                        return;
                    }
                    ++n;
                }
                ret = this.MUS_fileSupport(fileBuf1, fileBuf2);
                if (ret != LoadStatus.LOAD_NOT_MINE) {
                    if (ret == LoadStatus.LOAD_ERROR) {
                        return;
                    }
                    n = 0;
                    while (n < fileNameExtensions.length) {
                        if (!this.createNewFileName(fileName2, fileName, fileNameExtensions[n])) {
                            return;
                        }
                        if (!fileName.equalsIgnoreCase(fileName2.toString()) && this.loadFile(fileName2.toString(), fileBuf2)) {
                            if (fileNameExtensions[n].equalsIgnoreCase(".mus")) {
                                if (this.MUS_fileSupport(fileBuf2, fileBuf1) == LoadStatus.LOAD_OK) {
                                    if (this.MUS_mergeParts(fileBuf2, fileBuf1)) {
                                        this.status = this.acceptSidTune(fileName2.toString(), fileName, fileBuf2);
                                    }
                                    return;
                                }
                            } else if (this.MUS_fileSupport(fileBuf1, fileBuf2) == LoadStatus.LOAD_OK) {
                                if (this.MUS_mergeParts(fileBuf1, fileBuf2)) {
                                    this.status = this.acceptSidTune(fileName, fileName2.toString(), fileBuf1);
                                }
                                return;
                            }
                        }
                        ++n;
                    }
                    fileBuf2.erase();
                    this.MUS_fileSupport(fileBuf1, fileBuf2);
                    this.status = this.acceptSidTune(fileName, null, fileBuf1);
                    return;
                }
                ret = this.X00_fileSupport(fileName, fileBuf1);
                if (ret != LoadStatus.LOAD_NOT_MINE) {
                    if (ret == LoadStatus.LOAD_OK) {
                        this.status = this.acceptSidTune(fileName, null, fileBuf1);
                    }
                    return;
                }
                ret = this.PRG_fileSupport(fileName, fileBuf1);
                if (ret != LoadStatus.LOAD_NOT_MINE) {
                    if (ret == LoadStatus.LOAD_OK) {
                        this.status = this.acceptSidTune(fileName, null, fileBuf1);
                    }
                    return;
                }
                this.info.statusString = txt_unrecognizedFormat;
                return;
            }
            if (ret == LoadStatus.LOAD_OK) {
                int n = 0;
                while (n < fileNameExtensions.length) {
                    if (!this.createNewFileName(fileName2, fileName, fileNameExtensions[n])) {
                        return;
                    }
                    if (!fileName.equalsIgnoreCase(fileName2.toString()) && this.loadFile(fileName2.toString(), fileBuf2) && (this.SID_fileSupport(fileBuf2, fileBuf1) == LoadStatus.LOAD_OK || this.INFO_fileSupport(fileBuf2, fileBuf1) == LoadStatus.LOAD_OK)) {
                        this.status = this.acceptSidTune(fileName2.toString(), fileName, fileBuf2);
                        return;
                    }
                    ++n;
                }
                this.info.statusString = txt_noDataFile;
                return;
            }
        } else {
            return;
        }
    }

    private LoadStatus orStatus(LoadStatus support, LoadStatus support2) {
        int val1;
        int n = support == LoadStatus.LOAD_NOT_MINE ? 0 : (val1 = support == LoadStatus.LOAD_OK ? 1 : 2);
        int val2 = support2 == LoadStatus.LOAD_NOT_MINE ? 0 : (support2 == LoadStatus.LOAD_OK ? 1 : 2);
        int erg = val1 | val2;
        return erg == 0 ? LoadStatus.LOAD_NOT_MINE : (erg == 1 ? LoadStatus.LOAD_OK : LoadStatus.LOAD_ERROR);
    }

    private void deleteFileNameCopies() {
        if (this.info.dataFileName != null) {
            this.info.dataFileName = null;
        }
        if (this.info.infoFileName != null) {
            this.info.infoFileName = null;
        }
        if (this.info.path != null) {
            this.info.path = null;
        }
        this.info.dataFileName = null;
        this.info.infoFileName = null;
        this.info.path = null;
    }

    private void getFromBuffer(short[] buffer, int bufferLen) {
        this.status = false;
        if (buffer == null || bufferLen == 0) {
            this.info.statusString = txt_empty;
            return;
        }
        if (bufferLen > 65662) {
            this.info.statusString = txt_fileTooLong;
            return;
        }
        short[] tmpBuf = new short[bufferLen];
        System.arraycopy(buffer, 0, tmpBuf, 0, bufferLen);
        Buffer_sidtt buf1 = new Buffer_sidtt(tmpBuf, bufferLen);
        Buffer_sidtt buf2 = new Buffer_sidtt();
        if (this.decompressPP20(buf1) < 0) {
            return;
        }
        boolean foundFormat = false;
        LoadStatus ret = this.PSID_fileSupport(buf1);
        if (ret != LoadStatus.LOAD_NOT_MINE) {
            if (ret == LoadStatus.LOAD_ERROR) {
                return;
            }
            foundFormat = true;
        } else {
            ret = this.MUS_fileSupport(buf1, buf2);
            if (ret != LoadStatus.LOAD_NOT_MINE) {
                if (ret == LoadStatus.LOAD_ERROR) {
                    return;
                }
                foundFormat = this.MUS_mergeParts(buf1, buf2);
            } else {
                this.info.statusString = txt_unrecognizedFormat;
            }
        }
        if (foundFormat) {
            this.status = this.acceptSidTune("-", "-", buf1);
        }
    }

    private boolean acceptSidTune(String dataFileName, String infoFileName, Buffer_sidtt buf) {
        if (this.info.numberOfInfoStrings == 3) {
            int i = 0;
            while (i < 3) {
                if (this.infoString[i].length() == 0) {
                    this.infoString[i] = "<?>";
                    this.info.infoString[i] = this.infoString[i];
                }
                ++i;
            }
        }
        this.deleteFileNameCopies();
        if (dataFileName != null) {
            this.info.path = new String(dataFileName);
            File file = new File(this.info.path);
            this.info.dataFileName = file.getName();
            String string = this.info.path = file.getParentFile() != null ? file.getParentFile().getPath() : "";
            if (this.info.path == null || this.info.dataFileName == null) {
                this.info.statusString = txt_notEnoughMemory;
                return false;
            }
        } else {
            this.info.path = new String("");
            this.info.dataFileName = new String("");
        }
        if (infoFileName != null) {
            String tmp = new String(infoFileName);
            this.info.infoFileName = new String(new File(tmp).getName());
            tmp = null;
        } else {
            this.info.infoFileName = new String("");
        }
        if (this.info.songs > 256) {
            this.info.songs = 256;
        } else if (this.info.songs == 0) {
            ++this.info.songs;
        }
        if (this.info.startSong > this.info.songs) {
            this.info.startSong = 1;
        } else if (this.info.startSong == 0) {
            ++this.info.startSong;
        }
        if (this.info.musPlayer) {
            this.MUS_setPlayerAddress();
        }
        this.info.dataFileLen = buf.len();
        this.info.c64dataLen = buf.len() - this.fileOffset;
        if (!this.resolveAddrs(buf.get(), this.fileOffset)) {
            return false;
        }
        if (!this.checkRelocInfo()) {
            return false;
        }
        if (!this.checkCompatibility()) {
            return false;
        }
        if (this.info.dataFileLen >= 2) {
            boolean bl = this.info.fixLoad = SIDEndian.endian_little16(buf.get(), this.fileOffset) == this.info.loadAddr + 2;
        }
        if (this.info.c64dataLen > 65536) {
            this.info.statusString = txt_dataTooLong;
            return false;
        }
        if (this.info.c64dataLen == 0) {
            this.info.statusString = txt_empty;
            return false;
        }
        this.cache.assign(buf.xferPtr(), buf.xferLen());
        this.info.statusString = txt_noErrors;
        return true;
    }

    private boolean createNewFileName(StringBuffer destString, String sourceName, String sourceExt) {
        int extPos;
        if (destString.length() > 0) {
            destString.delete(0, destString.length() - 1);
        }
        if ((extPos = sourceName.lastIndexOf(".")) != -1) {
            destString.append(sourceName.substring(0, extPos)).append(sourceExt);
        } else {
            destString.append(sourceName);
            destString.append(sourceExt);
        }
        return true;
    }

    private int decompressPP20(Buffer_sidtt buf) {
        PP20 myPP = new PP20();
        if (myPP.isCompressed(buf.get(), buf.len())) {
            Decompressed decomp = new Decompressed();
            int fileLen = myPP.decompress(buf.get(), buf.len(), decomp);
            if (fileLen == 0) {
                this.info.statusString = myPP.getStatusString();
                return -1;
            }
            this.info.statusString = myPP.getStatusString();
            buf.assign(decomp.destBufRef, fileLen);
            return 1;
        }
        return 0;
    }

    class Decompressed {
        short[] destBufRef;

        Decompressed() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoadStatus {
        LOAD_NOT_MINE,
        LOAD_OK,
        LOAD_ERROR;

    }
}

