/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.sidtune;

import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;

public class PP20 {
    private static final String _pp20_txt_packeddatacorrupt = "PowerPacker: Packed data is corrupt";
    private static final String _pp20_txt_unrecognized = "PowerPacker: Unrecognized compression method";
    private static final String _pp20_txt_uncompressed = "Not compressed with PowerPacker (PP20)";
    private static final String _pp20_txt_fast = "PowerPacker: fast compression";
    private static final String _pp20_txt_mediocre = "PowerPacker: mediocre compression";
    private static final String _pp20_txt_good = "PowerPacker: good compression";
    private static final String _pp20_txt_verygood = "PowerPacker: very good compression";
    private static final String _pp20_txt_best = "PowerPacker: best compression";
    private static final String PP_ID = "PP20";
    private short[] efficiency = new short[4];
    private short[] source;
    short[] dest;
    private int readPtr;
    private int writePtr;
    private int current;
    private int bits;
    private boolean globalError;
    private String statusString = "Not compressed with PowerPacker (PP20)";

    public boolean isCompressed(short[] source, int size) {
        if (size < 8) {
            return false;
        }
        short[] idPtr = source;
        if (!new String(new byte[]{(byte)idPtr[0], (byte)idPtr[1], (byte)idPtr[2], (byte)idPtr[3]}).equals(PP_ID)) {
            this.statusString = _pp20_txt_uncompressed;
            return false;
        }
        return this.checkEfficiency(source, 4);
    }

    public int decompress(short[] source, int size, SidTune.Decompressed decomp) {
        this.source = source;
        this.globalError = false;
        this.readPtr = 0;
        if (!this.isCompressed(source, size)) {
            return 0;
        }
        this.readPtr += size - 4;
        int lastDword = this.readBEdword(source, this.readPtr);
        int outputLen = lastDword >> 8;
        this.dest = new short[outputLen];
        this.writePtr = outputLen;
        this.bits = 32 - (lastDword & 0xFF);
        this.bytesTOdword();
        if (this.bits != 32) {
            this.current >>= 32 - this.bits;
        }
        do {
            if (this.readBits(1) == 0) {
                this.bytes();
            }
            if (this.writePtr > 0) {
                this.sequence();
            }
            if (!this.globalError) continue;
            outputLen = 0;
            break;
        } while (this.writePtr > 0);
        if (outputLen > 0) {
            decomp.destBufRef = new short[this.dest.length];
            System.arraycopy(this.dest, 0, decomp.destBufRef, 0, this.dest.length);
        }
        return outputLen;
    }

    public final String getStatusString() {
        return this.statusString;
    }

    private boolean checkEfficiency(short[] source, int pos) {
        int PP_BITS_FAST = 0x9090909;
        int PP_BITS_MEDIOCRE = 0x90A0A0A;
        int PP_BITS_GOOD = 151653131;
        int PP_BITS_VERYGOOD = 151653388;
        int PP_BITS_BEST = 151653389;
        System.arraycopy(source, pos, this.efficiency, 0, 4);
        int eff = this.readBEdword(this.efficiency, 0);
        if (eff != 0x9090909 && eff != 0x90A0A0A && eff != 151653131 && eff != 151653388 && eff != 151653389) {
            this.statusString = _pp20_txt_unrecognized;
            return false;
        }
        switch (eff) {
            case 0x9090909: {
                this.statusString = _pp20_txt_fast;
                break;
            }
            case 0x90A0A0A: {
                this.statusString = _pp20_txt_mediocre;
                break;
            }
            case 151653131: {
                this.statusString = _pp20_txt_good;
                break;
            }
            case 151653388: {
                this.statusString = _pp20_txt_verygood;
                break;
            }
            case 151653389: {
                this.statusString = _pp20_txt_best;
            }
        }
        return true;
    }

    private void bytesTOdword() {
        this.readPtr -= 4;
        if (this.readPtr < 0) {
            this.statusString = _pp20_txt_packeddatacorrupt;
            this.globalError = true;
        } else {
            this.current = this.readBEdword(this.source, this.readPtr);
        }
    }

    private int readBits(int count) {
        int data = 0;
        while (count > 0) {
            data += data;
            data |= this.current & 1;
            this.current >>= 1;
            if (--this.bits == 0) {
                this.bytesTOdword();
                this.bits = 32;
            }
            --count;
        }
        return data;
    }

    private void bytes() {
        int add;
        int count = add = this.readBits(2);
        while (add == 3) {
            add = this.readBits(2);
            count += add;
        }
        ++count;
        while (count > 0) {
            if (this.writePtr > 0) {
                this.dest[--this.writePtr] = (short)this.readBits(8);
            } else {
                this.statusString = _pp20_txt_packeddatacorrupt;
                this.globalError = true;
            }
            --count;
        }
    }

    private void sequence() {
        int offset;
        int length = this.readBits(2);
        int offsetBitLen = this.efficiency[length];
        if ((length += 2) != 5) {
            offset = this.readBits(offsetBitLen);
        } else {
            if (this.readBits(1) == 0) {
                offsetBitLen = 7;
            }
            offset = this.readBits(offsetBitLen);
            int add = this.readBits(3);
            length += add;
            while (add == 7) {
                add = this.readBits(3);
                length += add;
            }
        }
        while (length > 0) {
            if (this.writePtr > 0) {
                --this.writePtr;
                this.dest[this.writePtr] = this.dest[this.writePtr + 1 + offset];
            } else {
                this.statusString = _pp20_txt_packeddatacorrupt;
                this.globalError = true;
            }
            --length;
        }
    }

    int readBEdword(short[] ptr, int pos) {
        return (ptr[pos + 0] << 24) + (ptr[pos + 1] << 16) + (ptr[pos + 2] << 8) + ptr[pos + 3] << 0;
    }
}

