/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.mos6526;

import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IComponent;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.SIDEndian;

public class SID6526
implements IComponent {
    private static final String credit = "*SID6526 (SIDPlay1 Fake CIA) Emulation:\tCopyright (C) 2001 Simon White <sidplay2@yahoo.com>";
    private C64Env m_env;
    private IEventContext m_eventContext;
    private long m_accessClk;
    private Event.event_phase_t m_phase;
    private short[] regs = new short[16];
    private short cra;
    private int ta_latch;
    private int ta;
    private long rnd;
    private int m_count;
    private boolean locked;
    private TaEvent m_taEvent;

    public SID6526(C64Env env) {
        this.m_env = env;
        this.m_eventContext = this.m_env.context();
        this.m_phase = Event.event_phase_t.EVENT_CLOCK_PHI1;
        this.rnd = 0L;
        this.m_taEvent = new TaEvent(this);
        this.clock(65535);
        this.reset(false);
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean seed) {
        this.locked = false;
        this.ta = this.ta_latch = this.m_count;
        this.cra = 0;
        this.rnd = seed ? 0L : (this.rnd += System.nanoTime() & 0xFFL);
        this.m_accessClk = 0L;
        this.m_eventContext.cancel(this.m_taEvent);
    }

    public short read(short addr) {
        if (addr > 15) {
            return 0;
        }
        switch (addr) {
            case 4: 
            case 5: 
            case 17: 
            case 18: {
                this.rnd = this.rnd * 13L + 1L;
                return (short)(this.rnd >> 3);
            }
        }
        return this.regs[addr];
    }

    public void write(short addr, short data) {
        if (addr > 15) {
            return;
        }
        this.regs[addr] = data;
        if (this.locked) {
            return;
        }
        long cycles = this.m_eventContext.getTime(this.m_accessClk, this.m_phase);
        this.m_accessClk += cycles;
        this.ta = (int)((long)this.ta - cycles);
        if (this.ta == 0) {
            this.event();
        }
        switch (addr) {
            case 4: {
                this.ta_latch = SIDEndian.endian_16lo8(this.ta_latch, data);
                break;
            }
            case 5: {
                this.ta_latch = SIDEndian.endian_16hi8(this.ta_latch, data);
                if ((this.cra & 1) != 0) break;
                this.ta = this.ta_latch;
                break;
            }
            case 14: {
                this.cra = (short)(data | 1);
                if ((data & 0x10) != 0) {
                    this.cra = (short)(this.cra & 0xEF);
                    this.ta = this.ta_latch;
                }
                this.m_eventContext.schedule(this.m_taEvent, (long)this.ta + 1L, this.m_phase);
                break;
            }
        }
    }

    public final String credits() {
        return credit;
    }

    public final String error() {
        return "";
    }

    public void event() {
        this.m_accessClk = this.m_eventContext.getTime(this.m_phase);
        this.ta = this.ta_latch;
        this.m_eventContext.schedule(this.m_taEvent, (long)this.ta + 1L, this.m_phase);
        this.m_env.interruptIRQ(true);
    }

    public void clock(int count) {
        this.m_count = count;
    }

    public void lock() {
        this.locked = true;
    }

    private class TaEvent
    extends Event {
        private SID6526 m_cia;

        public void event() {
            this.m_cia.event();
        }

        public TaEvent(SID6526 cia) {
            super("CIA Timer A");
            this.m_cia = cia;
        }
    }
}

