/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.common;

import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IEventContext;

public class EventScheduler
extends Event
implements IEventContext {
    public static final int EVENT_TIMEWARP_COUNT = 1048575;
    private long m_absClk;
    private long m_events = 0L;
    private EventTimeWarp m_timeWarp = new EventTimeWarp(this);

    public void event() {
        Event e = this.m_next;
        this.m_absClk += this.m_clk;
        while (e.m_pending) {
            e.m_clk -= this.m_clk;
            e = e.m_next;
        }
        this.m_clk = 0L;
        this.schedule(this.m_timeWarp, 1048575L, Event.event_phase_t.EVENT_CLOCK_PHI1);
    }

    private void dispatch(Event e) {
        this.cancelPending(e);
        e.event();
    }

    private void cancelPending(Event event) {
        event.m_pending = false;
        event.m_prev.m_next = event.m_next;
        event.m_next.m_prev = event.m_prev;
        --this.m_events;
    }

    public EventScheduler(String name) {
        super(name);
        this.m_next = this;
        this.m_prev = this;
        this.reset();
    }

    public void cancel(Event event) {
        if (event.m_pending) {
            this.cancelPending(event);
        }
    }

    public void reset() {
        Event e = this.m_next;
        this.m_pending = false;
        while (e.m_pending) {
            e.m_pending = false;
            e = e.m_next;
        }
        this.m_next = this;
        this.m_prev = this;
        this.m_absClk = 0L;
        this.m_clk = 0L;
        this.m_events = 0L;
        this.event();
    }

    public void schedule(Event event, long cycles, Event.event_phase_t phase) {
        if (!event.m_pending) {
            long clk = this.m_clk + (cycles << 1);
            clk += this.m_absClk + clk & 1L ^ (long)(phase == Event.event_phase_t.EVENT_CLOCK_PHI1 ? 0 : 1);
            Event e = this.m_next;
            long count = this.m_events;
            while (count-- != 0L && e.m_clk <= clk) {
                e = e.m_next;
            }
            event.m_next = e;
            event.m_prev = e.m_prev;
            e.m_prev.m_next = event;
            e.m_prev = event;
            event.m_pending = true;
            event.m_clk = clk;
            ++this.m_events;
        } else {
            this.cancelPending(event);
            this.schedule(event, cycles, phase);
        }
    }

    public void clock() {
        this.m_clk = this.m_next.m_clk;
        this.dispatch(this.m_next);
    }

    public final long getTime(Event.event_phase_t phase) {
        return this.m_absClk + this.m_clk + (long)((phase == Event.event_phase_t.EVENT_CLOCK_PHI1 ? 0 : 1) ^ 1) >> 1;
    }

    public final long getTime(long clock, Event.event_phase_t phase) {
        return this.getTime(phase) - clock << 1 >> 1;
    }

    public final Event.event_phase_t phase() {
        return (this.m_absClk + this.m_clk & 1L) == 0L ? Event.event_phase_t.EVENT_CLOCK_PHI1 : Event.event_phase_t.EVENT_CLOCK_PHI2;
    }

    public class EventTimeWarp
    extends Event {
        private EventScheduler m_scheduler;

        public void event() {
            this.m_scheduler.event();
        }

        public EventTimeWarp(EventScheduler context) {
            super("Time Warp");
            this.m_scheduler = context;
        }
    }
}

