/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.wav;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class WavMixer
extends BasicMixer {
    private int bufferSize;
    private int[] dspOutput;
    private byte[] output;
    private int sampleSizeInBits;
    private int sampleSizeInBytes;
    private int channels;
    private int sampleRate;
    private boolean isBigEndian;
    private boolean isSigned;
    private int lengthInMilliseconds;
    private URL waveFileUrl;
    private AudioInputStream audioInputStream;
    private long currentSamplesWritten;
    private volatile int isSeeking;

    public WavMixer(URL waveFileUrl) {
        this.waveFileUrl = waveFileUrl;
        this.initialize();
    }

    private void initialize() {
        try {
            this.closeAudioDevice();
            this.initializeWave();
        }
        catch (Exception ex) {
            Log.error("[WavMixer]", ex);
        }
    }

    private void initializeWave() {
        try {
            AudioFormat[] possibleFormats;
            if (this.audioInputStream != null) {
                try {
                    this.audioInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.audioInputStream = AudioSystem.getAudioInputStream(this.waveFileUrl);
            AudioFormat audioFormat = this.audioInputStream.getFormat();
            DataLine.Info sourceLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
            if (!AudioSystem.isLineSupported(sourceLineInfo) && (possibleFormats = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_SIGNED, audioFormat)) != null && possibleFormats.length != 0) {
                this.audioInputStream = AudioSystem.getAudioInputStream(possibleFormats[0], this.audioInputStream);
                audioFormat = this.audioInputStream.getFormat();
                Log.info("Converting input data to " + audioFormat.toString());
            }
            this.lengthInMilliseconds = 0;
            try {
                this.lengthInMilliseconds = (int)((long)this.audioInputStream.available() / ((long)audioFormat.getSampleSizeInBits() >> 3) / (long)audioFormat.getChannels() * 1000L / (long)audioFormat.getSampleRate());
            }
            catch (IOException ex) {
                Log.error("[WavMixer] No data available!", ex);
            }
            this.setAudioFormat(audioFormat);
            this.channels = audioFormat.getChannels();
            this.sampleSizeInBits = audioFormat.getSampleSizeInBits();
            this.sampleSizeInBytes = this.sampleSizeInBits >> 3;
            this.sampleRate = (int)audioFormat.getSampleRate();
            this.isBigEndian = audioFormat.isBigEndian();
            this.isSigned = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
            this.bufferSize = 250 * this.channels * this.sampleRate / 1000;
            this.dspOutput = new int[this.bufferSize];
            this.bufferSize *= this.sampleSizeInBytes;
            this.output = new byte[this.bufferSize];
            this.isSeeking = 0;
        }
        catch (Exception ex) {
            Log.error("[WavMixer]", ex);
        }
    }

    public boolean isSeekSupported() {
        return true;
    }

    public int getMillisecondPosition() {
        if (this.sampleRate != 0) {
            return (int)(this.currentSamplesWritten * 1000L / (long)this.sampleRate);
        }
        return 0;
    }

    public void setMillisecondPosition(int milliseconds) {
        if (this.isSeeking > 0) {
            return;
        }
        try {
            try {
                this.isSeeking = 1;
                while (this.isSeeking != 2) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.getMillisecondPosition() > milliseconds) {
                    if (this.audioInputStream != null) {
                        try {
                            this.audioInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.audioInputStream = AudioSystem.getAudioInputStream(this.waveFileUrl);
                    this.currentSamplesWritten = 0L;
                }
                byte[] tmpBuffer = new byte[this.bufferSize];
                while (this.getMillisecondPosition() < milliseconds) {
                    int byteCount = this.audioInputStream.read(tmpBuffer, 0, this.bufferSize);
                    if (byteCount <= 0) {
                        break;
                    }
                    this.currentSamplesWritten += (long)(byteCount / this.sampleSizeInBytes / this.channels);
                }
            }
            catch (Exception ex) {
                Log.error("[WavMixer]: error while seeking", ex);
                this.isSeeking = 0;
            }
        }
        finally {
            this.isSeeking = 0;
        }
    }

    public int getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    public int getChannelCount() {
        return this.channels;
    }

    public int getCurrentKBperSecond() {
        return this.sampleSizeInBits * this.channels * this.sampleRate / 1000;
    }

    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    public void startPlayback() {
        this.initialize();
        this.currentSamplesWritten = 0L;
        this.setIsPlaying();
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                int byteCount = 0;
                do {
                    if ((byteCount = this.audioInputStream.read(this.output, 0, this.bufferSize)) <= 0) continue;
                    Helpers.convertAnyToSigned24Bit(this.dspOutput, 0, this.output, 0, byteCount, this.channels, this.sampleSizeInBits, this.isBigEndian, this.isSigned);
                    this.writeSampleDataToProcessor(this.dspOutput, 0, byteCount / this.sampleSizeInBytes);
                    this.writeSampleDataToLine(this.output, 0, byteCount);
                    this.currentSamplesWritten += (long)(byteCount / this.sampleSizeInBytes / this.channels);
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (this.isPausing()) {
                        this.setIsPaused();
                        while (this.isPaused()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.isSeeking <= 0) continue;
                    this.isSeeking = 2;
                    while (this.isSeeking > 0) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (byteCount != -1);
                if (byteCount == -1) {
                    this.setHasFinished();
                }
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.closeAudioDevice();
            this.setIsStopped();
            if (this.audioInputStream != null) {
                try {
                    this.audioInputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.audioInputStream = null;
        }
    }
}

