/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.wav;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.wav.WavInfoPanel;
import de.quippy.javamod.multimedia.wav.WavMixer;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.JPanel;

public class WavContainer
extends MultimediaContainer {
    private static final String[] wavefile_Extensions;
    private WavMixer currentMixer;
    private JPanel wavConfigPanel;
    private JPanel wavInfoPanel;

    static {
        AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes();
        wavefile_Extensions = new String[types.length];
        int i = 0;
        while (i < types.length) {
            WavContainer.wavefile_Extensions[i] = types[i].getExtension();
            ++i;
        }
        MultimediaContainerManager.registerContainer(new WavContainer());
    }

    public MultimediaContainer getInstance(URL waveFileUrl) {
        MultimediaContainer result = super.getInstance(waveFileUrl);
        AudioInputStream audioInputStream = null;
        try {
            try {
                audioInputStream = AudioSystem.getAudioInputStream(waveFileUrl);
                ((WavInfoPanel)this.getInfoPanel()).fillInfoPanelWith(audioInputStream, this.getSongName());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (audioInputStream != null) {
                try {
                    audioInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public boolean canExport() {
        return false;
    }

    public JPanel getInfoPanel() {
        if (this.wavInfoPanel == null) {
            this.wavInfoPanel = new WavInfoPanel();
        }
        return this.wavInfoPanel;
    }

    public JPanel getConfigPanel() {
        if (this.wavConfigPanel == null) {
            this.wavConfigPanel = new JPanel();
        }
        return this.wavConfigPanel;
    }

    public String[] getFileExtensionList() {
        return wavefile_Extensions;
    }

    public String getName() {
        return "Wave-File";
    }

    public void configurationChanged(Properties newProps) {
    }

    public void configurationSave(Properties props) {
    }

    public Mixer createNewMixer() {
        this.currentMixer = new WavMixer(this.getFileURL());
        return this.currentMixer;
    }
}

