/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.sid;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.multimedia.sid.SIDContainer;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import de.quippy.sidplay.libsidplay.SIDPlay2;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.resid_builder.ReSIDBuilder;
import de.quippy.sidplay.resid_builder.sid_filter_t;
import javax.sound.sampled.AudioFormat;

public class SIDMixer
extends BasicMixer {
    private SIDPlay2 sidPlayer;
    private SidTune sidTune;
    private ISID2Types.sid2_config_t sidConfig;
    private sid_filter_t sidFilter;
    private int[] dspOutput;
    private byte[] output;
    private int sampleRate = 44100;
    private boolean isStereo = true;
    private static final int MULTIPLIER_SHIFT = 4;
    private static final int MULTIPLIER_VALUE = 16;
    private int multiplier;
    private int songNumber;
    private SIDContainer parentSIDContainer;

    public SIDMixer(SidTune sidTune, SIDContainer parent) {
        this.sidTune = sidTune;
        this.songNumber = sidTune != null ? sidTune.getInfo().currentSong + 1 : 1;
        this.parentSIDContainer = parent;
    }

    private void initialize() {
        try {
            this.closeAudioDevice();
            this.sidPlayer = new SIDPlay2();
            this.sidConfig = this.sidPlayer.config();
            this.sidConfig.clockDefault = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
            this.sidConfig.clockForced = false;
            this.sidConfig.clockSpeed = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
            this.sidConfig.environment = ISID2Types.sid2_env_t.sid2_envR;
            this.sidConfig.emulateStereo = false;
            this.sidConfig.forceDualSids = false;
            this.sidConfig.frequency = this.sampleRate;
            this.sidConfig.optimisation = 1;
            this.sidConfig.leftVolume = 255L;
            this.sidConfig.rightVolume = 255L;
            this.sidConfig.sampleFormat = ISID2Types.sid2_sample_t.SID2_LITTLE_SIGNED;
            this.sidConfig.playback = this.isStereo ? ISID2Types.sid2_playback_t.sid2_stereo : ISID2Types.sid2_playback_t.sid2_mono;
            this.sidConfig.sidDefault = ISID2Types.sid2_model_t.SID2_MOS6581;
            this.sidConfig.sidModel = ISID2Types.sid2_model_t.SID2_MODEL_CORRECT;
            this.sidConfig.sidSamples = true;
            this.sidConfig.precision = 16;
            this.sidPlayer.config(this.sidConfig);
            ReSIDBuilder rs = new ReSIDBuilder("ReSID");
            if (rs.bool()) {
                this.sidConfig.sidEmulation = rs;
                rs.create(this.sidPlayer.info().maxsids);
                rs.filter(true);
                rs.sampling(this.sampleRate);
                rs.filter(this.sidFilter);
            }
            this.sidTune.selectSong(this.songNumber);
            this.sidPlayer.load(this.sidTune);
            this.multiplier = 16;
        }
        catch (Exception ex) {
            Log.error("[SIDMixer]", ex);
        }
    }

    public boolean isSeekSupported() {
        return true;
    }

    public int getLengthInMilliseconds() {
        return this.sidTune != null ? this.sidTune.getInfo().songs * 1000 : 0;
    }

    public int getMillisecondPosition() {
        return this.songNumber * 1000;
    }

    public int getChannelCount() {
        if (this.sidPlayer != null) {
            return this.sidPlayer.info().channels;
        }
        return 0;
    }

    public int getCurrentKBperSecond() {
        return 16 * this.sampleRate / 1000;
    }

    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    public void setMillisecondPosition(int milliseconds) {
        if (this.sidTune != null) {
            this.pausePlayback();
            this.songNumber = milliseconds / 1000 + 1;
            this.sidTune.selectSong(this.songNumber);
            this.sidPlayer.load(this.sidTune);
            this.parentSIDContainer.nameChanged();
            this.pausePlayback();
        }
    }

    private byte[] getOutputBuffer(int length) {
        if (this.output == null || this.output.length < length) {
            this.output = new byte[length];
        }
        return this.output;
    }

    private int[] getDspBuffer(int length) {
        if (this.dspOutput == null || this.dspOutput.length < length) {
            this.dspOutput = new int[length];
        }
        return this.dspOutput;
    }

    public void startPlayback() {
        this.initialize();
        this.parentSIDContainer.nameChanged();
        this.setIsPlaying();
        try {
            this.setAudioFormat(new AudioFormat(this.sampleRate, 16, 2, true, false));
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                boolean finished = false;
                int bufferSize = this.sampleRate >> 2;
                if (bufferSize % 2 != 0) {
                    ++bufferSize;
                }
                if (this.isStereo) {
                    bufferSize <<= 1;
                }
                short[] shortBuffer = new short[bufferSize];
                do {
                    this.sidPlayer.play(shortBuffer, bufferSize);
                    int byteBufferSize = this.isStereo ? bufferSize : bufferSize << 1;
                    byte[] b = this.getOutputBuffer(byteBufferSize);
                    int idx = byteBufferSize;
                    int pos = bufferSize;
                    while (pos > 0) {
                        byte ll = 0;
                        byte rl = 0;
                        byte lh = 0;
                        byte rh = 0;
                        if (this.isStereo) {
                            int sl = shortBuffer[--pos] << 8 | shortBuffer[--pos];
                            int sr = shortBuffer[--pos] << 8 | shortBuffer[--pos];
                            sl = sl * this.multiplier >> 4;
                            sr = sr * this.multiplier >> 4;
                            ll = (byte)(sl & 0xFF);
                            lh = (byte)(sl >> 8);
                            rl = (byte)(sr & 0xFF);
                            rh = (byte)(sr >> 8);
                        } else {
                            int s = shortBuffer[--pos] << 8 | shortBuffer[--pos];
                            s = s * this.multiplier >> 4;
                            ll = rl = (byte)(s & 0xFF);
                            lh = rh = (byte)(s >> 8);
                        }
                        b[--idx] = lh;
                        b[--idx] = ll;
                        b[--idx] = rh;
                        b[--idx] = rl;
                    }
                    int[] dsp = this.getDspBuffer(byteBufferSize >> 1);
                    Helpers.convertAnyToSigned24Bit(dsp, 0, b, 0, byteBufferSize, 2, 16, false, true);
                    this.writeSampleDataToProcessor(dsp, 0, byteBufferSize >> 1);
                    this.writeSampleDataToLine(b, 0, byteBufferSize);
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (!this.isPausing()) continue;
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (!finished);
                if (finished) {
                    this.setHasFinished();
                }
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.sidPlayer.stop();
            this.closeAudioDevice();
            this.setIsStopped();
        }
    }
}

