/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.sid;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.sid.SIDMixer;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class SIDContainer
extends MultimediaContainer {
    private static final String[] SIDFILEEXTENSION = new String[]{"sid"};
    private SidTune sidTune;
    private JPanel sidConfigPanel;
    private JPanel sidInfoPanel;

    static {
        MultimediaContainerManager.registerContainer(new SIDContainer());
    }

    public MultimediaContainer getInstance(URL sidFileUrl) {
        MultimediaContainer result = super.getInstance(sidFileUrl);
        this.sidTune = this.loadSidTune(sidFileUrl);
        return result;
    }

    public String getSongName() {
        if (this.sidTune != null) {
            SidTuneInfo info = this.sidTune.getInfo();
            String[] infoString = info.infoString;
            return String.valueOf(infoString[0]) + " [" + infoString[1] + "] " + Integer.toString(info.currentSong) + '/' + Integer.toString(info.songs) + " (" + infoString[2] + ')';
        }
        return super.getSongName();
    }

    public void nameChanged() {
        this.fireMultimediaContainerEvent(new MultimediaContainerEvent(this, MultimediaContainerEvent.SONG_NAME_CHANGED_OLD_INVALID, this.getSongName()));
    }

    public boolean canExport() {
        return true;
    }

    private SidTune loadSidTune(URL sidFileURL) {
        InputStream in = null;
        try {
            in = sidFileURL.openStream();
            int length = in.available();
            short[] sidTuneData = new short[length];
            int i = 0;
            while (i < length) {
                sidTuneData[i] = (short)in.read();
                ++i;
            }
            return new SidTune(sidTuneData, sidTuneData.length);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Mixer createNewMixer() {
        return new SIDMixer(this.sidTune, this);
    }

    public void configurationChanged(Properties newProps) {
    }

    public void configurationSave(Properties props) {
    }

    public JPanel getInfoPanel() {
        if (this.sidInfoPanel == null) {
            this.sidInfoPanel = new JPanel();
        }
        return this.sidInfoPanel;
    }

    public JPanel getConfigPanel() {
        if (this.sidConfigPanel == null) {
            this.sidConfigPanel = new JPanel();
        }
        return this.sidConfigPanel;
    }

    public String[] getFileExtensionList() {
        return SIDFILEEXTENSION;
    }

    public String getName() {
        return "SID-File";
    }
}

