/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ogg.metadata;

import de.quippy.javamod.multimedia.ogg.metadata.JOrbisComment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;

public class OggMetaData {
    private URL urlName = null;
    private HashMap<String, String> oggInfo = null;
    private int lengthInMilliseconds;

    public OggMetaData(URL oggFileURL) {
        this.readMetaData(oggFileURL);
    }

    private void readMetaData(URL oggFileURL) {
        InputStream in = null;
        try {
            try {
                this.urlName = oggFileURL;
                in = oggFileURL.openStream();
                JOrbisComment jorbiscomment = new JOrbisComment();
                jorbiscomment.read(in);
                in.close();
                this.lengthInMilliseconds = jorbiscomment.getLengthInMilliseconds();
                this.oggInfo = new HashMap();
                int i = 99;
                while (i >= 0) {
                    String comment = jorbiscomment.getComment().getComment(i);
                    if (comment != null && comment.length() > 0) {
                        int equalIndex = comment.indexOf(61);
                        String key = comment.substring(0, equalIndex);
                        String value = new String(comment.substring(equalIndex + 1).getBytes(), "UTF-8");
                        if (equalIndex != -1) {
                            this.oggInfo.put(key, value);
                        }
                    }
                    --i;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            in = null;
        }
    }

    public String getUrlName() {
        return this.urlName.toExternalForm();
    }

    public int getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    public String getAlbum() {
        return this.oggInfo.get("ALBUM");
    }

    public String getTitle() {
        return this.oggInfo.get("TITLE");
    }

    public String getGenre() {
        return this.oggInfo.get("GENRE");
    }

    public String getComposer() {
        return this.oggInfo.get("COMPOSER");
    }

    public String getTrackNumber() {
        return this.oggInfo.get("TRACKNUMBER");
    }

    public String getComment() {
        return this.oggInfo.get("COMMENT");
    }

    public String getPublisher() {
        return this.oggInfo.get("PUBLISHER");
    }

    public String getBPM() {
        return this.oggInfo.get("bpm");
    }

    public String getArtist() {
        return this.oggInfo.get("ARTIST");
    }

    public String getDiscNumber() {
        return this.oggInfo.get("DISCNUMBER");
    }

    public String getAlbumArtist() {
        return this.oggInfo.get("ALBUMARTIST");
    }

    public String getDate() {
        return this.oggInfo.get("DATE");
    }

    public String getShortDescription() {
        String artist = this.getArtist();
        String title = this.getTitle();
        StringBuilder str = new StringBuilder();
        if (artist != null && artist.length() != 0) {
            str.append(artist).append(" - ");
        }
        if ((title == null || title.length() == 0) && this.urlName != null) {
            title = this.urlName.getPath();
            int dotIndex = (title = title.substring(title.lastIndexOf(47) + 1)).lastIndexOf(46);
            if (dotIndex != -1) {
                title = title.substring(0, dotIndex);
            }
        }
        return str.append(title).toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OggMetaData\nURL\t\t");
        builder.append(this.getUrlName());
        Set<String> keys = this.oggInfo.keySet();
        for (String key : keys) {
            String value = this.oggInfo.get(key);
            builder.append('\n').append(key).append("\t\t").append(value);
        }
        builder.append("\nLength:\t\t\t").append(this.getLengthInMilliseconds());
        return builder.toString();
    }
}

