/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ogg;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import de.quippy.ogg.jogg.Packet;
import de.quippy.ogg.jogg.Page;
import de.quippy.ogg.jogg.StreamState;
import de.quippy.ogg.jogg.SyncState;
import de.quippy.ogg.jorbis.Block;
import de.quippy.ogg.jorbis.Comment;
import de.quippy.ogg.jorbis.DspState;
import de.quippy.ogg.jorbis.Info;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;

public class OGGMixer
extends BasicMixer {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_READHEADER = 1;
    private static final int STATE_PREPARE = 2;
    private static final int STATE_READFIRSTFRAME = 3;
    private static final int STATE_PROCESSPACKET = 4;
    private static final int STATE_NEEDMOREDATA = 5;
    private static final int STATE_CONVERTPCM = 6;
    private static final int STATE_EOS = 7;
    private static final int CHUNKSIZE = 4096;
    private boolean oggEOS;
    private int decoderState;
    private SyncState oggSyncState;
    private StreamState oggStreamState;
    private Page oggPage;
    private Packet oggPacket;
    private Info vorbisInfo;
    private Comment vorbisComment;
    private DspState vorbisDSPState;
    private Block vorbisBlock;
    private final float[][][] pcmFloatBuffer = new float[1][][];
    private int[] pcmGeneratorIndex;
    private int bufferSize;
    private int[] dspOutput;
    private byte[] output;
    private int samplesProcessed;
    private long currentSamplesWritten;
    private int lengthInMilliseconds;
    private InputStream inputStream;
    private URL oggFileUrl;
    private volatile int isSeeking;

    public OGGMixer(URL oggFileUrl, int lengthInMilliseconds) {
        this.oggFileUrl = oggFileUrl;
        this.lengthInMilliseconds = lengthInMilliseconds;
        this.isSeeking = 0;
    }

    private void initialize() {
        try {
            this.closeAudioDevice();
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.inputStream = this.oggFileUrl.openStream();
            this.oggEOS = false;
            this.decoderState = 0;
            this.bufferSize = 0;
            this.dspOutput = null;
            this.output = null;
        }
        catch (Exception ex) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Log.error("[OGGMixer]", ex);
        }
    }

    public int getChannelCount() {
        if (this.vorbisInfo != null) {
            return this.vorbisInfo.channels;
        }
        return 0;
    }

    public int getCurrentKBperSecond() {
        if (this.vorbisInfo != null) {
            int bitRate = this.vorbisInfo.bitrate();
            if (bitRate == -1) {
                return 16 * this.vorbisInfo.rate * this.vorbisInfo.channels / 1000;
            }
            return bitRate / 1000;
        }
        return 0;
    }

    public int getCurrentSampleFrequency() {
        if (this.vorbisInfo != null) {
            return this.vorbisInfo.rate / 1000;
        }
        return 0;
    }

    public int getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    public int getMillisecondPosition() {
        if (this.vorbisInfo != null && this.vorbisInfo.rate != 0) {
            return (int)(this.currentSamplesWritten * 1000L / (long)this.vorbisInfo.rate);
        }
        return 0;
    }

    public boolean isSeekSupported() {
        return true;
    }

    public void setMillisecondPosition(int milliseconds) {
        if (this.isSeeking > 0) {
            return;
        }
        try {
            try {
                this.isSeeking = 1;
                while (this.isSeeking != 2) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (milliseconds < this.getMillisecondPosition()) {
                    this.cleanUp();
                    this.initialize();
                }
                while (this.getMillisecondPosition() < milliseconds) {
                    this.decodeFrame();
                }
            }
            catch (Exception ex) {
                Log.error("[OGGMixer]", ex);
                this.isSeeking = 0;
            }
        }
        finally {
            this.isSeeking = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int decodeFrame() throws Exception {
        block10: while (true) {
            switch (this.decoderState) {
                case 7: {
                    return -1;
                }
                case 0: {
                    this.decoderState = this.doStateInitial();
                    continue block10;
                }
                case 1: {
                    this.decoderState = this.doStateReadHeader();
                    continue block10;
                }
                case 2: {
                    this.decoderState = this.doStatePrepare();
                    continue block10;
                }
                case 3: {
                    this.decoderState = 5;
                    continue block10;
                }
                case 5: {
                    this.decoderState = this.doStateNeedMoreData();
                    continue block10;
                }
                case 4: {
                    this.decoderState = this.doStateProcessPacket();
                    continue block10;
                }
                case 6: {
                    this.decoderState = this.doStateConvertPCM();
                    if (this.decoderState == 6) return this.samplesProcessed * 2 * this.vorbisInfo.channels;
                    continue block10;
                }
            }
            break;
        }
        throw new IOException("invalid decoder state " + this.decoderState);
    }

    private void fetchMoreData() throws IOException {
        if (!this.oggEOS) {
            int oggIndex = this.oggSyncState.buffer(4096);
            int bytesRead = this.inputStream.read(this.oggSyncState.data, oggIndex, 4096);
            if (bytesRead <= 0) {
                this.oggEOS = true;
            } else {
                this.oggSyncState.wrote(bytesRead);
            }
        }
    }

    private int doStateConvertPCM() throws Exception {
        int nextState = 4;
        int samplesGenerated = this.vorbisDSPState.synthesis_pcmout(this.pcmFloatBuffer, this.pcmGeneratorIndex);
        if (samplesGenerated > 0) {
            this.samplesProcessed = samplesGenerated > this.bufferSize ? this.bufferSize : samplesGenerated;
            int i = 0;
            while (i < this.vorbisInfo.channels) {
                int sampleIndex = i << 1;
                int j = 0;
                while (j < this.samplesProcessed) {
                    int value = (int)(this.pcmFloatBuffer[0][i][this.pcmGeneratorIndex[i] + j] * 32767.0f);
                    if (value > Short.MAX_VALUE) {
                        value = Short.MAX_VALUE;
                    } else if (value < Short.MIN_VALUE) {
                        value = Short.MIN_VALUE;
                    }
                    if (value < 0) {
                        value |= 0x8000;
                    }
                    this.output[sampleIndex] = (byte)(value & 0xFF);
                    this.output[sampleIndex + 1] = (byte)(value >> 8 & 0xFF);
                    sampleIndex += this.vorbisInfo.channels << 1;
                    ++j;
                }
                ++i;
            }
            this.currentSamplesWritten += (long)this.samplesProcessed;
            this.vorbisDSPState.synthesis_read(this.samplesProcessed);
            nextState = 6;
        }
        return nextState;
    }

    /*
     * Unable to fully structure code
     */
    private int doStateNeedMoreData() throws Exception {
        if (!this.oggEOS) ** GOTO lbl12
        return 7;
lbl-1000:
        // 2 sources

        {
            if ((result = this.oggSyncState.pageout(this.oggPage)) == 0) {
                this.fetchMoreData();
            }
            if (!this.oggEOS && result == 0) continue;
            if (result != -1) {
                this.oggStreamState.pagein(this.oggPage);
                if (this.oggPage.granulepos() != 0L) break;
                this.oggEOS = true;
                return 7;
            }
lbl12:
            // 3 sources

            if (this.oggEOS) break;
            ** while (true)
        }
        return 4;
    }

    private int doStateProcessPacket() throws Exception {
        int nextState = 4;
        int result = this.oggStreamState.packetout(this.oggPacket);
        if (result == 0) {
            if (!this.oggEOS) {
                this.oggEOS = this.oggPage.eos() != 0;
            }
            nextState = 5;
        } else if (result != -1) {
            if (this.vorbisBlock.synthesis(this.oggPacket) == 0) {
                this.vorbisDSPState.synthesis_blockin(this.vorbisBlock);
            }
            nextState = 6;
        }
        return nextState;
    }

    private int doStateInitial() throws Exception {
        this.oggSyncState = new SyncState();
        this.oggStreamState = new StreamState();
        this.oggPage = new Page();
        this.oggPacket = new Packet();
        this.vorbisInfo = new Info();
        this.vorbisComment = new Comment();
        this.vorbisDSPState = new DspState();
        this.vorbisBlock = new Block(this.vorbisDSPState);
        this.oggSyncState.init();
        this.oggEOS = false;
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private int doStateReadHeader() throws Exception {
        block13: {
            this.fetchMoreData();
            if (this.oggSyncState.pageout(this.oggPage) != 1) {
                throw new IOException("Input does not appear to be an Ogg bitstream");
            }
            this.oggStreamState.init(this.oggPage.serialno());
            this.oggStreamState.reset();
            if (this.oggStreamState.pagein(this.oggPage) < 0) {
                throw new IOException("Error reading first page of Ogg bitstream data");
            }
            if (this.oggStreamState.packetout(this.oggPacket) != 1) {
                throw new IOException("Error reading initial header packet");
            }
            this.vorbisInfo.init();
            this.vorbisComment.init();
            if (this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket) < 0) {
                throw new IOException("This Ogg bitstream does not contain Vorbis audio data");
            }
            i = 0;
            break block13;
            while ((result = this.oggSyncState.pageout(this.oggPage)) != 0) {
                if (result == 1) {
                    this.oggStreamState.pagein(this.oggPage);
                    while (i < 2) {
                        result = this.oggStreamState.packetout(this.oggPacket);
                        if (result != 0) {
                            if (result == -1) {
                                throw new IOException("Corrupt secondary header");
                            }
                            this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket);
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    throw new IOException("Unhandled pageout() return code " + result);
                }
lbl34:
                // 2 sources

                ** while (i >= 2)
lbl35:
                // 1 sources

            }
lbl36:
            // 2 sources

            this.fetchMoreData();
            if (this.oggEOS) {
                throw new IOException("End of file before finding all Vorbis headers");
            }
        }
        if (i < 2) ** GOTO lbl34
        return 2;
    }

    private final int doStatePrepare() throws Exception {
        this.vorbisDSPState.synthesis_init(this.vorbisInfo);
        this.vorbisBlock.init(this.vorbisDSPState);
        this.pcmGeneratorIndex = new int[this.vorbisInfo.channels];
        this.currentSamplesWritten = 0L;
        this.bufferSize = 250 * this.vorbisInfo.channels * this.vorbisInfo.rate / 1000;
        this.dspOutput = new int[this.bufferSize];
        this.bufferSize <<= 1;
        this.output = new byte[this.bufferSize];
        AudioFormat audioFormat = new AudioFormat(this.vorbisInfo.rate, 16, this.vorbisInfo.channels, true, false);
        this.setAudioFormat(audioFormat);
        this.openAudioDevice();
        return 3;
    }

    private void cleanUp() {
        if (this.oggStreamState != null) {
            this.oggStreamState.clear();
            this.oggStreamState = null;
        }
        if (this.vorbisBlock != null) {
            this.vorbisBlock.clear();
            this.vorbisBlock = null;
        }
        if (this.vorbisDSPState != null) {
            this.vorbisDSPState.clear();
            this.vorbisDSPState = null;
        }
        if (this.vorbisInfo != null) {
            this.vorbisInfo.clear();
            this.vorbisInfo = null;
        }
        if (this.oggSyncState != null) {
            this.oggSyncState.clear();
            this.oggSyncState = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.inputStream = null;
    }

    public void startPlayback() {
        this.initialize();
        this.setIsPlaying();
        try {
            try {
                int byteCount = 0;
                do {
                    if ((byteCount = this.decodeFrame()) <= 0 || !this.isInitialized()) continue;
                    Helpers.convertAnyToSigned24Bit(this.dspOutput, 0, this.output, 0, byteCount, this.vorbisInfo.channels, 16, false, true);
                    this.writeSampleDataToProcessor(this.dspOutput, 0, byteCount >> 1);
                    this.writeSampleDataToLine(this.output, 0, byteCount);
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (this.isPausing()) {
                        this.setIsPaused();
                        while (this.isPaused()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.isSeeking <= 0) continue;
                    this.isSeeking = 2;
                    while (this.isSeeking > 0) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (byteCount != -1);
                if (byteCount == -1) {
                    this.setHasFinished();
                }
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.closeAudioDevice();
            this.setIsStopped();
            this.cleanUp();
        }
    }
}

