/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ogg;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.ogg.OGGInfoPanel;
import de.quippy.javamod.multimedia.ogg.OGGMixer;
import de.quippy.javamod.multimedia.ogg.metadata.OggMetaData;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class OGGContainer
extends MultimediaContainer {
    private static final String[] OGGFILEEXTENSION = new String[]{"ogg"};
    private JPanel oggConfigPanel;
    private JPanel oggInfoPanel;
    private OggMetaData oggMetaData = null;

    static {
        MultimediaContainerManager.registerContainer(new OGGContainer());
    }

    public boolean canExport() {
        return true;
    }

    public MultimediaContainer getInstance(URL url) {
        MultimediaContainer result = super.getInstance(url);
        this.oggMetaData = new OggMetaData(url);
        ((OGGInfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.oggMetaData);
        return result;
    }

    public String getSongName() {
        return super.getSongName();
    }

    public Mixer createNewMixer() {
        return new OGGMixer(this.getFileURL(), this.oggMetaData.getLengthInMilliseconds());
    }

    public String getName() {
        return "ogg/vorbis-File";
    }

    public JPanel getConfigPanel() {
        if (this.oggConfigPanel == null) {
            this.oggConfigPanel = new JPanel();
        }
        return this.oggConfigPanel;
    }

    public JPanel getInfoPanel() {
        if (this.oggInfoPanel == null) {
            this.oggInfoPanel = new OGGInfoPanel();
        }
        return this.oggInfoPanel;
    }

    public void configurationChanged(Properties newProps) {
    }

    public void configurationSave(Properties props) {
    }

    public String[] getFileExtensionList() {
        return OGGFILEEXTENSION;
    }
}

