/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.multimedia.mp3.id3.exceptions.NoMPEGFramesException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MPEGAudioFrameHeader {
    private static final int HEADER_SIZE = 4;
    private static final int[][] bitrateTable = new int[][]{{-1, -1, -1, -1, -1}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-1, -1, -1, -1, -1}};
    private static final int[][] sampleTable = new int[][]{{44100, 22050, 11025}, {48000, 24000, 12000}, {32000, 16000, 8000}, {-1, -1, -1}};
    private static final String[] versionLabels;
    private static final String[] layerLabels;
    private static final String[] channelLabels;
    private static final String[] emphasisLabels;
    private static final int MPEG_V_25 = 0;
    private static final int MPEG_V_2 = 2;
    private static final int MPEG_V_1 = 3;
    private static final int MPEG_L_3 = 1;
    private static final int MPEG_L_2 = 2;
    private static final int MPEG_L_1 = 3;
    private int version = -1;
    private int layer = -1;
    private int bitRate = -1;
    private int sampleRate = -1;
    private int channelMode = -1;
    private boolean copyrighted = false;
    private boolean crced = false;
    private boolean original = false;
    private int emphasis = -1;

    static {
        String[] stringArray = new String[4];
        stringArray[0] = "MPEG Version 2.5";
        stringArray[2] = "MPEG Version 2.0";
        stringArray[3] = "MPEG Version 1.0";
        versionLabels = stringArray;
        String[] stringArray2 = new String[4];
        stringArray2[1] = "Layer III";
        stringArray2[2] = "Layer II";
        stringArray2[3] = "Layer I";
        layerLabels = stringArray2;
        channelLabels = new String[]{"Stereo", "Joint Stereo (STEREO)", "Dual Channel (STEREO)", "Single Channel (MONO)"};
        String[] stringArray3 = new String[4];
        stringArray3[0] = "none";
        stringArray3[1] = "50/15 ms";
        stringArray3[3] = "CCIT J.17";
        emphasisLabels = stringArray3;
    }

    public MPEGAudioFrameHeader(RandomAccessFile raf) throws NoMPEGFramesException, IOException {
        this(raf, 0);
    }

    public MPEGAudioFrameHeader(RandomAccessFile raf, int offset) throws NoMPEGFramesException, IOException {
        long location = this.findFrame(raf, offset);
        if (location == -1L) {
            throw new NoMPEGFramesException();
        }
        this.readHeader(raf, location);
    }

    private long findFrame(RandomAccessFile raf, int offset) throws IOException {
        long loc = -1L;
        raf.seek(offset);
        while (loc == -1L) {
            byte test = raf.readByte();
            if ((test & 0xFF) != 255 || ((test = raf.readByte()) & 0xE0) != 224) continue;
            return raf.getFilePointer() - 2L;
        }
        return -1L;
    }

    private void readHeader(RandomAccessFile raf, long location) throws IOException {
        byte[] head = new byte[4];
        raf.seek(location);
        if (raf.read(head) != 4) {
            throw new IOException("Error reading MPEG frame header.");
        }
        this.version = (head[1] & 0x18) >> 3;
        this.layer = (head[1] & 6) >> 1;
        this.crced = (head[1] & 1) == 0;
        this.bitRate = this.findBitRate((head[2] & 0xF0) >> 4, this.version, this.layer);
        this.sampleRate = this.findSampleRate((head[2] & 0xC) >> 2, this.version);
        this.channelMode = (head[3] & 0xC0) >> 6;
        this.copyrighted = (head[3] & 8) != 0;
        this.original = (head[3] & 4) != 0;
        this.emphasis = head[3] & 3;
    }

    private int findBitRate(int bitrateIndex, int version, int layer) {
        int ind = -1;
        if (version == 3) {
            if (layer == 3) {
                ind = 0;
            } else if (layer == 2) {
                ind = 1;
            } else if (layer == 1) {
                ind = 2;
            }
        } else if (version == 2 || version == 0) {
            if (layer == 3) {
                ind = 3;
            } else if (layer == 2 || layer == 1) {
                ind = 4;
            }
        }
        if (ind != -1 && bitrateIndex >= 0 && bitrateIndex <= 15) {
            return bitrateTable[bitrateIndex][ind];
        }
        return -1;
    }

    private int findSampleRate(int sampleIndex, int version) {
        int ind = -1;
        switch (version) {
            case 3: {
                ind = 0;
                break;
            }
            case 2: {
                ind = 1;
                break;
            }
            case 0: {
                ind = 2;
            }
        }
        if (ind != -1 && sampleIndex >= 0 && sampleIndex <= 3) {
            return sampleTable[sampleIndex][ind];
        }
        return -1;
    }

    public String toString() {
        return String.valueOf(this.getVersion()) + " " + this.getLayer() + "\nBitRate:\t\t\t" + this.getBitRate() + "kbps\nSampleRate:\t\t\t" + this.getSampleRate() + "Hz\nChannelMode:\t\t\t" + this.getChannelMode() + "\nCopyrighted:\t\t\t" + this.isCopyrighted() + "\nOriginal:\t\t\t" + this.isOriginal() + "\nCRC:\t\t\t\t" + this.isProtected() + "\nEmphasis:\t\t\t" + this.getEmphasis();
    }

    public String getVersion() {
        String str = null;
        if (this.version >= 0 && this.version < versionLabels.length) {
            str = versionLabels[this.version];
        }
        return str;
    }

    public String getLayer() {
        String str = null;
        if (this.layer >= 0 && this.layer < layerLabels.length) {
            str = layerLabels[this.layer];
        }
        return str;
    }

    public String getChannelMode() {
        String str = null;
        if (this.channelMode >= 0 && this.channelMode < channelLabels.length) {
            str = channelLabels[this.channelMode];
        }
        return str;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isCopyrighted() {
        return this.copyrighted;
    }

    public boolean isProtected() {
        return this.crced;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public String getEmphasis() {
        String str = null;
        if (this.emphasis >= 0 && this.emphasis < emphasisLabels.length) {
            str = emphasisLabels[this.emphasis];
        }
        return str;
    }

    public boolean isMP3() {
        return this.layer == 1;
    }
}

