/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.multimedia.mp3.id3.ID3v1Tag;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Tag;
import de.quippy.javamod.multimedia.mp3.id3.MPEGAudioFrameHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;

public class MP3FileID3Controller {
    public static final int ID3V1 = 1;
    public static final int ID3V2 = 2;
    private File mp3File;
    private ID3v1Tag id3v1;
    private ID3v2Tag id3v2;
    private MPEGAudioFrameHeader head;

    public MP3FileID3Controller(File mp3File) {
        this.getTagsFromFile(mp3File);
    }

    public MP3FileID3Controller(URL mp3URL) {
        try {
            if (mp3URL.getProtocol().equalsIgnoreCase("file")) {
                this.getTagsFromFile(new File(mp3URL.toURI()));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void getTagsFromFile(File mp3File) {
        RandomAccessFile raf = null;
        try {
            try {
                this.mp3File = mp3File;
                raf = new RandomAccessFile(mp3File, "r");
                this.id3v1 = new ID3v1Tag(raf);
                this.id3v2 = new ID3v2Tag(raf);
                this.head = new MPEGAudioFrameHeader(raf, this.id3v2.getSize());
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void removeTags(int type) throws FileNotFoundException, IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.mp3File, "rw");
            if (this.allow(type & 1)) {
                this.id3v1.removeTag(raf);
            }
            if (this.allow(type & 2)) {
                this.id3v2.removeTag(raf);
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    public void writeTags() throws FileNotFoundException, IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.mp3File, "rw");
            if (this.id3v2.tagExists()) {
                this.id3v2.writeTag(raf);
            }
            if (this.id3v1.tagExists()) {
                this.id3v1.writeTag(raf);
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    public void setTitle(String title, int type) {
        if (this.allow(type & 1)) {
            this.id3v1.setTitle(title);
        }
        if (this.allow(type & 2)) {
            this.id3v2.setTextFrame("TIT2", title);
        }
    }

    public void setAlbum(String album, int type) {
        if (this.allow(type & 1)) {
            this.id3v1.setAlbum(album);
        }
        if (this.allow(type & 2)) {
            this.id3v2.setTextFrame("TALB", album);
        }
    }

    public void setArtist(String artist, int type) {
        if (this.allow(type & 1)) {
            this.id3v1.setArtist(artist);
        }
        if (this.allow(type & 2)) {
            this.id3v2.setTextFrame("TPE1", artist);
        }
    }

    public void setComment(String comment, int type) {
        if (this.allow(type & 1)) {
            this.id3v1.setComment(comment);
        }
        if (this.allow(type & 2)) {
            this.id3v2.setCommentFrame("", comment);
        }
    }

    public void setGenre(String genre, int type) {
        if (this.allow(type & 1)) {
            this.id3v1.setGenreString(genre);
        }
        if (this.allow(type & 2)) {
            this.id3v2.setTextFrame("TCON", genre);
        }
    }

    public void setYear(String year, int type) {
        if (this.allow(type & 1)) {
            this.id3v1.setYear(year);
        }
        if (this.allow(type & 2)) {
            this.id3v2.setTextFrame("TYER", year);
        }
    }

    public void setTrack(int track, int type) {
        if (this.allow(type & 1)) {
            this.id3v1.setTrack(track);
        }
        if (this.allow(type & 2)) {
            this.id3v2.setTextFrame("TRCK", String.valueOf(track));
        }
    }

    public void setComposer(String composer) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame("TCOM", composer);
        }
    }

    public void setOriginalArtist(String artist) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame("TOPE", artist);
        }
    }

    public void setCopyrightInfo(String copyright) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame("TCOP", copyright);
        }
    }

    public void setUserDefinedURL(String desc, String url) {
        if (this.allow(2)) {
            this.id3v2.setUserDefinedURLFrame(desc, url);
        }
    }

    public void setUserDefinedText(String desc, String text) {
        if (this.allow(2)) {
            this.id3v2.setUserDefinedTextFrame(desc, text);
        }
    }

    public void setEncodedBy(String encBy) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame("TENC", encBy);
        }
    }

    public void setTextFrame(String id, String data) {
        if (this.allow(2)) {
            this.id3v2.setTextFrame(id, data);
        }
    }

    public void setFrameData(String id, byte[] data) {
        if (this.allow(2)) {
            this.id3v2.updateFrameData(id, data);
        }
    }

    public long getPlayingTime() {
        long datasize = this.mp3File.length() * 8L - (long)this.id3v2.getSize();
        long bps = this.head.getBitRate() * 1000;
        return datasize / bps;
    }

    public String getPlayingTimeString() {
        long time = this.getPlayingTime();
        long mins = time / 60L;
        long secs = time % 60L;
        StringBuilder str = new StringBuilder();
        if (mins < 10L) {
            str.append('0');
        }
        str.append(mins).append(':');
        if (secs < 10L) {
            str.append('0');
        }
        str.append(secs);
        return str.toString();
    }

    public boolean id3v2Exists() {
        return this.id3v2 != null && this.id3v2.tagExists();
    }

    public boolean id3v1Exists() {
        return this.id3v1 != null && this.id3v1.tagExists();
    }

    public boolean isMP3() {
        return this.head.isMP3();
    }

    public int getBitRate() {
        return this.head.getBitRate();
    }

    public int getSampleRate() {
        return this.head.getSampleRate();
    }

    public String getMPEGEmphasis() {
        return this.head.getEmphasis();
    }

    public String getMPEGLayer() {
        return this.head.getLayer();
    }

    public String getMPEGVersion() {
        return this.head.getVersion();
    }

    public String getMPEGChannelMode() {
        return this.head.getChannelMode();
    }

    public boolean isMPEGCopyrighted() {
        return this.head.isCopyrighted();
    }

    public boolean isMPEGOriginal() {
        return this.head.isOriginal();
    }

    public boolean isMPEGProtected() {
        return this.head.isProtected();
    }

    public String getArtist(int type) {
        if (this.allow(type & 1)) {
            return this.id3v1.getArtist();
        }
        if (this.allow(type & 2)) {
            return this.id3v2.getFrameDataString("TPE1");
        }
        return null;
    }

    public String getAlbum(int type) {
        if (this.allow(type & 1)) {
            return this.id3v1.getAlbum();
        }
        if (this.allow(type & 2)) {
            return this.id3v2.getFrameDataString("TALB");
        }
        return null;
    }

    public String getComment(int type) {
        if (this.allow(type & 1)) {
            return this.id3v1.getComment();
        }
        if (this.allow(type & 2)) {
            return this.id3v2.getFrameDataString("COMM");
        }
        return null;
    }

    public String getGenre(int type) {
        if (this.allow(type & 1)) {
            return this.id3v1.getGenreString();
        }
        if (this.allow(type & 2)) {
            return this.id3v2.getFrameDataString("TCON");
        }
        return null;
    }

    public String getTitle(int type) {
        if (this.allow(type & 1)) {
            return this.id3v1.getTitle();
        }
        if (this.allow(type & 2)) {
            return this.id3v2.getFrameDataString("TIT2");
        }
        return null;
    }

    public String getTrack(int type) {
        if (this.allow(type & 1)) {
            return Integer.toString(this.id3v1.getTrack());
        }
        if (this.allow(type & 2)) {
            return this.id3v2.getFrameDataString("TRCK");
        }
        return null;
    }

    public String getYear(int type) {
        if (this.allow(type & 1)) {
            return this.id3v1.getYear();
        }
        if (this.allow(type & 2)) {
            return this.id3v2.getFrameDataString("TYER");
        }
        return null;
    }

    public String getComposer() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TCOM");
        }
        return null;
    }

    public String getDisc() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TPOS");
        }
        return null;
    }

    public String getOriginalArtist() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TOPE");
        }
        return null;
    }

    public String getAlbumArtist() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TPE2");
        }
        return null;
    }

    public String getPublisher() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TPUB");
        }
        return null;
    }

    public String getCopyrightInfo() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TCOP");
        }
        return null;
    }

    public String getUserDefinedURL() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("WXXX");
        }
        return null;
    }

    public String getEncodedBy() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TENC");
        }
        return null;
    }

    public String getBPM() {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString("TBPM");
        }
        return null;
    }

    public String getFrameDataString(String id) {
        if (this.allow(2)) {
            return this.id3v2.getFrameDataString(id);
        }
        return null;
    }

    public byte[] getFrameDataBytes(String id) {
        if (this.allow(2)) {
            return this.id3v2.getFrameData(id);
        }
        return null;
    }

    public String getFileName() {
        if (this.mp3File == null) {
            return "";
        }
        try {
            return this.mp3File.getCanonicalPath();
        }
        catch (IOException ex) {
            return this.mp3File.getAbsolutePath();
        }
    }

    public String getShortDescription() {
        int dotIndex;
        String artist = null;
        String title = null;
        if (this.id3v2Exists()) {
            artist = this.getArtist(2);
            title = this.getTitle(2);
        }
        if (this.id3v1Exists()) {
            if (artist == null || artist.length() == 0) {
                artist = this.getArtist(1);
            }
            if (title == null || title.length() == 0) {
                title = this.getTitle(1);
            }
        }
        StringBuilder str = new StringBuilder();
        if (artist != null && artist.length() != 0) {
            str.append(artist).append(" - ");
        }
        if ((title == null || title.length() == 0) && this.mp3File != null && (dotIndex = (title = this.mp3File.getName()).lastIndexOf(46)) != -1) {
            title = title.substring(0, dotIndex);
        }
        return str.append(title).toString();
    }

    private boolean allow(int type) {
        return (type & 1) != 0 && this.id3v1Exists() || (type & 2) != 0 && this.id3v2Exists();
    }

    public String toString() {
        return "MP3File\nPath:\t\t\t\t" + this.mp3File.getAbsolutePath() + "\nFileSize:\t\t\t" + this.mp3File.length() + " bytes\nPlayingTime:\t\t\t" + this.getPlayingTimeString() + "\n" + this.head + "\n" + this.id3v1 + "\n" + this.id3v2;
    }
}

