/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.multimedia.mp3.id3.ID3v2ExtendedHeader;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Footer;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Frame;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Frames;
import de.quippy.javamod.multimedia.mp3.id3.ID3v2Header;
import de.quippy.javamod.multimedia.mp3.id3.exceptions.ID3v2FormatException;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class ID3v2Tag {
    private static final String ENC_TYPE = "ISO-8859-1";
    private ID3v2Header head = null;
    private ID3v2ExtendedHeader ext_head = null;
    private ID3v2Frames<String, ID3v2Frame> frames = new ID3v2Frames();
    private ID3v2Footer foot = null;
    private int padding;
    private int origSize;
    private int origPadding;
    private boolean exists;

    public ID3v2Tag(RandomAccessFile raf) throws FileNotFoundException, IOException, ID3v2FormatException {
        this.head = new ID3v2Header(raf);
        this.padding = 0;
        this.exists = this.head.headerExists();
        if (this.exists) {
            if (this.head.getExtendedHeader()) {
                this.ext_head = new ID3v2ExtendedHeader(raf);
            }
            if (this.head.getFooter()) {
                this.foot = new ID3v2Footer(raf, this.head.getTagSize() + this.head.getHeaderSize());
            }
            if (this.head.getMajorVersion() >= 3) {
                this.parseFrames(raf);
            }
            this.origSize = this.getSize();
            this.origPadding = this.getPadding();
        }
    }

    private void parseFrames(RandomAccessFile raf) throws FileNotFoundException, IOException, ID3v2FormatException {
        int offset = this.head.getHeaderSize();
        int framesLength = this.head.getTagSize();
        if (this.head.getExtendedHeader()) {
            framesLength -= this.ext_head.getSize();
            offset += this.ext_head.getSize();
        }
        raf.seek(offset);
        int bytesRead = 0;
        boolean done = false;
        while (bytesRead < framesLength && !done) {
            byte[] buf = new byte[4];
            bytesRead += raf.read(buf);
            if (buf[0] != 0) {
                String id = new String(buf);
                bytesRead += raf.read(buf);
                int curLength = Helpers.convertDWordToInt(buf, 0);
                byte[] flags = new byte[2];
                bytesRead += raf.read(flags);
                byte[] data = new byte[curLength];
                bytesRead += raf.read(data);
                ID3v2Frame frame = new ID3v2Frame(id, flags, data);
                this.frames.put(id, frame);
                continue;
            }
            done = true;
            this.padding = framesLength - bytesRead - buf.length;
        }
    }

    public void writeTag(RandomAccessFile raf) throws FileNotFoundException, IOException {
        int curSize = this.getSize();
        this.origPadding = this.padding;
        this.padding = this.getUpdatedPadding();
        if (this.padding > this.origPadding || this.padding == this.origPadding && curSize == this.origSize) {
            byte[] out = this.getBytes();
            raf.seek(0L);
            raf.write(out);
        } else {
            int bufSize = (int)(raf.length() + (long)curSize);
            byte[] out = new byte[bufSize];
            System.arraycopy(this.getBytes(), 0, out, 0, curSize);
            int bufSize2 = (int)(raf.length() - (long)this.origSize);
            byte[] in = new byte[bufSize2];
            raf.seek(this.origSize);
            if (raf.read(in) != in.length) {
                throw new IOException("Error reading mp3 file before writing");
            }
            System.arraycopy(in, 0, out, curSize, in.length);
            raf.setLength(bufSize2);
            raf.seek(0L);
            raf.write(out);
        }
        this.origSize = curSize;
        this.exists = true;
    }

    public void removeTag(RandomAccessFile raf) throws FileNotFoundException, IOException {
        if (this.exists) {
            int bufSize = (int)(raf.length() - (long)this.origSize);
            byte[] buf = new byte[bufSize];
            raf.seek(this.origSize);
            if (raf.read(buf) != buf.length) {
                throw new IOException("Error encountered while removing id3v2 tag.");
            }
            raf.setLength(bufSize);
            raf.seek(0L);
            raf.write(buf);
            this.exists = false;
        }
    }

    public byte[] getBytes() {
        byte[] b = new byte[this.getSize() + this.padding];
        int bytesCopied = 0;
        int length = 0;
        length = this.head.getHeaderSize();
        System.arraycopy(this.head.getBytes(), 0, b, bytesCopied, length);
        bytesCopied += length;
        if (this.head.getExtendedHeader()) {
            length = this.ext_head.getSize();
            System.arraycopy(this.ext_head.getBytes(), 0, b, bytesCopied, length);
            bytesCopied += length;
        }
        length = this.frames.getLength();
        System.arraycopy(this.frames.getBytes(), 0, b, bytesCopied, length);
        System.arraycopy(new byte[this.padding], 0, b, bytesCopied += length, this.padding);
        bytesCopied += this.padding;
        if (this.head.getFooter()) {
            length = this.foot.getFooterSize();
            System.arraycopy(this.foot.getBytes(), 0, b, bytesCopied, length);
            bytesCopied += length;
        }
        return b;
    }

    private int getUpdatedPadding() {
        int curSize = this.getSize();
        int pad = 0;
        if (this.origPadding == this.padding && curSize > this.origSize && this.padding >= curSize - this.origSize) {
            pad = this.padding - (curSize - this.origSize);
        } else if (curSize < this.origSize) {
            pad = this.origSize - curSize + this.padding;
        }
        return pad;
    }

    public void setTextFrame(String id, String data) {
        if (id.charAt(0) == 'T' && !id.equals("TXXX")) {
            try {
                byte[] b = new byte[data.length() + 1];
                b[0] = 0;
                System.arraycopy(data.getBytes(ENC_TYPE), 0, b, 1, data.length());
                this.updateFrameData(id, b);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void setURLFrame(String id, String data) {
        if (id.charAt(0) == 'W' && !id.equals("WXXX")) {
            this.updateFrameData(id, data.getBytes());
        }
    }

    public void setUserDefinedTextFrame(String description, String value) {
        try {
            byte[] b = new byte[description.length() + value.length() + 2];
            int bytesCopied = 0;
            b[bytesCopied++] = 0;
            System.arraycopy(description.getBytes(ENC_TYPE), 0, b, bytesCopied, description.length());
            bytesCopied += description.length();
            b[bytesCopied++] = 0;
            System.arraycopy(value.getBytes(ENC_TYPE), 0, b, bytesCopied, value.length());
            bytesCopied += value.length();
            this.updateFrameData("TXXX", b);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void setUserDefinedURLFrame(String description, String value) {
        try {
            byte[] b = new byte[description.length() + value.length() + 2];
            int bytesCopied = 0;
            b[bytesCopied++] = 0;
            System.arraycopy(description.getBytes(ENC_TYPE), 0, b, bytesCopied, description.length());
            bytesCopied += description.length();
            b[bytesCopied++] = 0;
            System.arraycopy(value.getBytes(), 0, b, bytesCopied, value.length());
            bytesCopied += value.length();
            this.updateFrameData("WXXX", b);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void setCommentFrame(String description, String comment) {
        try {
            byte[] b = new byte[description.length() + comment.length() + 5];
            int bytesCopied = 0;
            b[bytesCopied++] = 0;
            b[bytesCopied++] = 101;
            b[bytesCopied++] = 110;
            b[bytesCopied++] = 103;
            System.arraycopy(description.getBytes(ENC_TYPE), 0, b, bytesCopied, description.length());
            bytesCopied += description.length();
            b[bytesCopied++] = 0;
            System.arraycopy(comment.getBytes(ENC_TYPE), 0, b, bytesCopied, comment.length());
            bytesCopied += comment.length();
            this.updateFrameData("COMM", b);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void removeFrame(String id) {
        this.frames.remove(id);
        this.updateSize();
    }

    public void updateFrameData(String id, byte[] data) {
        if (this.frames.containsKey(id)) {
            ((ID3v2Frame)this.frames.get(id)).setFrameData(data);
        } else {
            ID3v2Frame frame = new ID3v2Frame(id, data);
            this.frames.put(id, frame);
        }
        this.updateSize();
    }

    public String getFrameDataString(String id) {
        try {
            if (this.frames.containsKey(id)) {
                return ((ID3v2Frame)this.frames.get(id)).getDataString();
            }
        }
        catch (ID3v2FormatException ex) {
            Log.error("ID3v2Tag:", ex);
        }
        return null;
    }

    public byte[] getFrameData(String id) {
        if (this.frames.containsKey(id)) {
            return ((ID3v2Frame)this.frames.get(id)).getFrameData();
        }
        return null;
    }

    private void updateSize() {
        int length = this.frames.getLength();
        if (this.head.getExtendedHeader()) {
            length += this.ext_head.getSize();
        }
        this.head.setTagSize(length);
        if (this.head.getFooter()) {
            this.foot.setTagSize(length);
        }
    }

    public boolean tagExists() {
        return this.exists;
    }

    public int getSize() {
        int retval = this.head.getTagSize() + this.head.getHeaderSize();
        if (this.head.getFooter()) {
            retval += this.foot.getFooterSize();
        }
        return retval;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int pad) {
        if (!this.head.getFooter() && pad >= 0) {
            this.padding = pad;
        }
    }

    public String toString() {
        String str = this.head.toString();
        str = String.valueOf(str) + "\nPadding:\t\t\t" + this.getPadding() + " bytes";
        if (this.head.getExtendedHeader()) {
            str = String.valueOf(str) + "\n" + this.ext_head.toString();
        }
        str = String.valueOf(str) + "\n" + this.frames.toString();
        if (this.head.getFooter()) {
            str = String.valueOf(str) + this.foot.toString();
        }
        return str;
    }
}

