/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.multimedia.mp3.id3.exceptions.ID3v2FormatException;
import de.quippy.javamod.system.Helpers;

public class ID3v2Frame {
    private static final int FRAME_HEAD_SIZE = 10;
    private static final int FRAME_FLAGS_SIZE = 2;
    private static final int MAX_EXTRA_DATA = 5;
    private static final String[] ENC_TYPES = new String[]{"ISO-8859-1", "UTF16", "UTF-16BE", "UTF-8"};
    private String id = null;
    private boolean tagAlterDiscard = false;
    private boolean fileAlterDiscard = false;
    private boolean readOnly = false;
    private boolean grouped = false;
    private boolean compressed = false;
    private boolean encrypted = false;
    private boolean unsynchronised = false;
    private boolean lengthIndicator = false;
    private byte group = 0;
    private byte encrType = 0;
    private int dataLength = -1;
    private byte[] frameData;

    public ID3v2Frame(String id, byte[] data) {
        this.id = id;
        this.fileAlterDiscard = this.checkDefaultFileAlterDiscard();
        this.parseData(data);
    }

    public ID3v2Frame(String id, byte[] flags, byte[] data) throws ID3v2FormatException {
        this(id, data);
        this.parseFlags(flags);
    }

    public ID3v2Frame(String id, byte[] data, boolean tagAlterDiscard, boolean fileAlterDiscard, boolean readOnly, boolean grouped, boolean compressed, boolean encrypted, boolean unsynchronised, boolean lengthIndicator) {
        this.id = id;
        this.tagAlterDiscard = tagAlterDiscard;
        this.fileAlterDiscard = fileAlterDiscard;
        this.readOnly = readOnly;
        this.grouped = grouped;
        this.compressed = compressed;
        this.encrypted = encrypted;
        this.unsynchronised = unsynchronised;
        this.lengthIndicator = lengthIndicator;
        this.group = 0;
        this.encrType = 0;
        this.dataLength = -1;
        this.parseData(data);
    }

    private boolean checkDefaultFileAlterDiscard() {
        return this.id.equals("ASPI") || this.id.equals("AENC") || this.id.equals("ETCO") || this.id.equals("EQU2") || this.id.equals("MLLT") || this.id.equals("POSS") || this.id.equals("SEEK") || this.id.equals("SYLT") || this.id.equals("SYTC") || this.id.equals("RVA2") || this.id.equals("TENC") || this.id.equals("TLEN");
    }

    private void parseFlags(byte[] flags) throws ID3v2FormatException {
        if (flags.length != 2) {
            throw new ID3v2FormatException("Error parsing flags of frame: " + this.id + ".  Expected 2 bytes.");
        }
        this.tagAlterDiscard = (flags[0] & 0x40) != 0;
        this.fileAlterDiscard = (flags[0] & 0x20) != 0;
        this.readOnly = (flags[0] & 0x10) != 0;
        this.grouped = (flags[1] & 0x40) != 0;
        this.compressed = (flags[1] & 8) != 0;
        this.encrypted = (flags[1] & 4) != 0;
        this.unsynchronised = (flags[1] & 2) != 0;
        boolean bl = this.lengthIndicator = (flags[1] & 1) != 0;
        if (this.compressed && !this.lengthIndicator) {
            throw new ID3v2FormatException("Error parsing flags of frame: " + this.id + ".  Compressed bit set without data length bit set.");
        }
    }

    private byte[] getFlagBytes() {
        byte[] flags = new byte[2];
        if (this.tagAlterDiscard) {
            flags[0] = (byte)(flags[0] | 0x40);
        }
        if (this.fileAlterDiscard) {
            flags[0] = (byte)(flags[0] | 0x20);
        }
        if (this.readOnly) {
            flags[0] = (byte)(flags[0] | 0x10);
        }
        if (this.grouped) {
            flags[1] = (byte)(flags[1] | 0x40);
        }
        if (this.compressed) {
            flags[1] = (byte)(flags[1] | 8);
        }
        if (this.encrypted) {
            flags[1] = (byte)(flags[1] | 4);
        }
        if (this.unsynchronised) {
            flags[1] = (byte)(flags[1] | 2);
        }
        if (this.lengthIndicator) {
            flags[1] = (byte)(flags[1] | 1);
        }
        return flags;
    }

    private void parseData(byte[] data) {
        int bytesRead = 0;
        if (this.grouped) {
            this.group = data[bytesRead];
            ++bytesRead;
        }
        if (this.encrypted) {
            this.encrType = data[bytesRead];
            ++bytesRead;
        }
        if (this.lengthIndicator) {
            this.dataLength = Helpers.convertDWordToInt(data, bytesRead);
            bytesRead += 4;
        }
        this.frameData = new byte[data.length - bytesRead];
        System.arraycopy(data, bytesRead, this.frameData, 0, this.frameData.length);
    }

    public byte[] getFrameData() {
        return this.frameData;
    }

    public void setFrameData(byte[] newData) {
        if (!this.readOnly) {
            this.frameData = newData;
        }
    }

    public int getFrameLength() {
        int length = this.frameData.length + 10;
        if (this.grouped) {
            ++length;
        }
        if (this.encrypted) {
            ++length;
        }
        if (this.lengthIndicator) {
            length += 4;
        }
        return length;
    }

    public byte[] getFrameBytes() {
        int length = this.getFrameLength();
        int bytesWritten = 0;
        byte[] flags = this.getFlagBytes();
        byte[] extra = this.getExtraDataBytes();
        byte[] b = new byte[length];
        System.arraycopy(this.id.getBytes(), 0, b, 0, this.id.length());
        System.arraycopy(Helpers.convertIntToDWord(length), 0, b, bytesWritten += this.id.length(), 4);
        System.arraycopy(flags, 0, b, bytesWritten += 4, flags.length);
        System.arraycopy(extra, 0, b, bytesWritten += flags.length, extra.length);
        System.arraycopy(this.frameData, 0, b, bytesWritten += extra.length, this.frameData.length);
        bytesWritten += this.frameData.length;
        return b;
    }

    private byte[] getExtraDataBytes() {
        byte[] buf = new byte[5];
        int bytesCopied = 0;
        if (this.grouped) {
            buf[bytesCopied] = this.group;
            ++bytesCopied;
        }
        if (this.encrypted) {
            buf[bytesCopied] = this.encrType;
            ++bytesCopied;
        }
        if (this.lengthIndicator) {
            System.arraycopy(Helpers.convertIntToDWord(this.dataLength), 0, buf, bytesCopied, 4);
            bytesCopied += 4;
        }
        byte[] ret = new byte[bytesCopied];
        System.arraycopy(buf, 0, ret, 0, bytesCopied);
        return ret;
    }

    public boolean getTagAlterDiscard() {
        return this.tagAlterDiscard;
    }

    public boolean getFileAlterDiscard() {
        return this.fileAlterDiscard;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean getGrouped() {
        return this.grouped;
    }

    public boolean getCompressed() {
        return this.compressed;
    }

    public boolean getEncrypted() {
        return this.encrypted;
    }

    public boolean getUnsynchronised() {
        return this.unsynchronised;
    }

    public boolean getLengthIndicator() {
        return this.lengthIndicator;
    }

    public byte getGroup() {
        return this.group;
    }

    public byte getEncryptionType() {
        return this.encrType;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getDataString() throws ID3v2FormatException {
        String str = null;
        if (this.frameData.length > 1) {
            try {
                if (this.id.charAt(0) == 'T' || this.id.equals("OWNE")) {
                    str = Helpers.retrieveAsSimpleString(this.frameData, 1, this.frameData.length - 1, ENC_TYPES[this.frameData[0]]);
                } else if (this.id.charAt(0) == 'W') {
                    str = new String(this.frameData);
                } else if (this.id.equals("WXXX")) {
                    str = Helpers.retrieveAsString(this.frameData, 1, this.frameData.length - 1, ENC_TYPES[this.frameData[0]]);
                    if (str.length() < this.frameData.length - 1) {
                        str = String.valueOf(str) + '\n';
                        str = String.valueOf(str) + Helpers.retrieveAsSimpleString(this.frameData, str.length() + 2, this.frameData.length - 2 - str.length(), ENC_TYPES[this.frameData[0]]);
                    }
                } else if (this.id.equals("USLT") || this.id.equals("COMM") || this.id.equals("USER")) {
                    str = Helpers.retrieveAsSimpleString(this.frameData, 4, this.frameData.length - 4, ENC_TYPES[this.frameData[0]]);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ID3v2FormatException("Frame: " + this.id + " has not specified a valid encoding type.");
            }
        }
        return str;
    }

    public String toString() {
        try {
            return String.valueOf(this.id) + "\nTagAlterDiscard:\t\t" + this.tagAlterDiscard + "\nFileAlterDiscard:\t\t" + this.fileAlterDiscard + "\nReadOnly:\t\t\t" + this.readOnly + "\nGrouped:\t\t\t" + this.grouped + "\nCompressed:\t\t\t" + this.compressed + "\nEncrypted:\t\t\t" + this.encrypted + "\nUnsynchronised:\t\t\t" + this.unsynchronised + "\nLengthIndicator:\t\t" + this.lengthIndicator + "\nData:\t\t\t\t" + this.getDataString().toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

