/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.multimedia.mp3.id3.exceptions.ID3v2FormatException;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3v2ExtendedHeader {
    private static final int EXT_HEAD_LOCATION = 10;
    private static final int MIN_SIZE = 6;
    private static final int CRC_SIZE = 5;
    private static final int[] MAX_TAG_FRAMES_TABLE = new int[]{128, 64, 32, 32};
    private static final int[] MAX_TAG_SIZE_TABLE = new int[]{8000000, 1024000, 320000, 32000};
    private static final int[] MAX_TEXT_SIZE_TABLE = new int[]{-1, 1024, 128, 30};
    private int size = 0;
    private int numFlagBytes = 0;
    private boolean update = false;
    private boolean crced = false;
    private byte[] crc = new byte[5];
    private int maxTagSize = -1;
    private boolean textEncode = false;
    private int maxTextSize = -1;
    private boolean imageEncode = false;
    private int imageRestrict = -1;

    public ID3v2ExtendedHeader(RandomAccessFile raf) throws IOException, ID3v2FormatException {
        this.readExtendedHeader(raf);
    }

    private void readExtendedHeader(RandomAccessFile raf) throws IOException, ID3v2FormatException {
        raf.seek(10L);
        byte[] buf = new byte[4];
        if (raf.read(buf) != buf.length) {
            throw new IOException("Error reading extended header:size");
        }
        this.size = Helpers.convertDWordToInt(buf, 0);
        if (this.size < 6) {
            throw new ID3v2FormatException("The extended header size data is less than the minimum required size (" + this.size + '<' + 6 + ").");
        }
        this.numFlagBytes = raf.read();
        buf = new byte[this.numFlagBytes + 1];
        if (raf.read(buf) != buf.length) {
            throw new IOException("Error reading extended header:flags");
        }
        this.parseFlags(buf);
    }

    private void parseFlags(byte[] flags) throws ID3v2FormatException {
        int bytesRead = 1;
        boolean bl = this.update = (flags[0] & 0x80) != 0;
        if (this.update) {
            ++bytesRead;
        }
        boolean bl2 = this.crced = (flags[0] & 0x40) != 0;
        if (this.crced) {
            ++bytesRead;
            int i = 0;
            while (i < this.crc.length) {
                this.crc[i] = flags[bytesRead++];
                ++i;
            }
        }
        if ((flags[0] & 0x80) != 0) {
            byte b = flags[++bytesRead];
            this.maxTagSize = (b & 0xC0) >> 6;
            this.textEncode = (b & 0x20) != 0;
            this.maxTextSize = (b & 0x18) >> 3;
            this.imageEncode = (b & 4) != 0;
            this.imageRestrict = b & 3;
            ++bytesRead;
        }
        if (bytesRead != this.numFlagBytes) {
            throw new ID3v2FormatException("The number of found flag bytes in the extended header is not equal to the number specified in the extended header.");
        }
    }

    private byte[] getFlagBytes() {
        byte[] b = new byte[this.numFlagBytes];
        int bytesCopied = 1;
        b[0] = 0;
        if (this.update) {
            b[0] = (byte)(b[0] | 0x80);
            b[bytesCopied++] = 0;
        }
        if (this.crced) {
            b[0] = (byte)(b[0] | 0x40);
            b[bytesCopied++] = (byte)this.crc.length;
            System.arraycopy(this.crc, 0, b, bytesCopied, this.crc.length);
            bytesCopied += this.crc.length;
        }
        if (this.maxTagSize != -1 || this.textEncode || this.maxTextSize != -1 || this.imageEncode || this.imageRestrict != -1) {
            b[0] = (byte)(b[0] | 0x20);
            b[bytesCopied++] = 1;
            int restrict = 0;
            if (this.maxTagSize != -1) {
                restrict = (byte)(restrict | (byte)((this.maxTagSize & 3) << 6));
            }
            if (this.textEncode) {
                restrict = (byte)(restrict | 0x20);
            }
            if (this.maxTextSize != -1) {
                restrict = (byte)(restrict | (byte)((this.maxTextSize & 3) << 3));
            }
            if (this.imageEncode) {
                restrict = (byte)(restrict | 4);
            }
            if (this.imageRestrict != -1) {
                restrict = (byte)(restrict | (byte)(this.imageRestrict & 3));
            }
            b[bytesCopied++] = restrict;
        }
        return b;
    }

    public byte[] getBytes() {
        byte[] b = new byte[this.size];
        int bytesCopied = 0;
        System.arraycopy(Helpers.convertIntToDWord(this.size), 0, b, bytesCopied, 4);
        bytesCopied += 4;
        b[bytesCopied++] = (byte)this.numFlagBytes;
        System.arraycopy(this.getFlagBytes(), 0, b, bytesCopied, this.numFlagBytes);
        bytesCopied += this.numFlagBytes;
        return b;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumFlagBytes() {
        return this.numFlagBytes;
    }

    public int getMaxFrames() {
        int retval = -1;
        if (this.maxTagSize >= 0 && this.maxTagSize < MAX_TAG_FRAMES_TABLE.length) {
            retval = MAX_TAG_FRAMES_TABLE[this.maxTagSize];
        }
        return retval;
    }

    public int getMaxTagSize() {
        int retval = -1;
        if (this.maxTagSize >= 0 && this.maxTagSize < MAX_TAG_SIZE_TABLE.length) {
            retval = MAX_TAG_SIZE_TABLE[this.maxTagSize];
        }
        return retval;
    }

    public boolean getTextEncode() {
        return this.textEncode;
    }

    public int getMaxTextSize() {
        int retval = -1;
        if (this.maxTextSize >= 0 && this.maxTextSize < MAX_TEXT_SIZE_TABLE.length) {
            retval = MAX_TEXT_SIZE_TABLE[this.maxTextSize];
        }
        return retval;
    }

    public boolean getImageEncode() {
        return this.imageEncode;
    }

    public int getImageRestriction() {
        return this.imageRestrict;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public boolean getCRCed() {
        return this.crced;
    }

    public byte[] getCRC() {
        return this.crc;
    }

    public String toString() {
        return "ExtendedSize:\t\t\t" + this.getSize() + " bytes" + "\nNumFlagBytes:\t\t\t" + this.getNumFlagBytes() + "\nUpdated:\t\t\t" + this.getUpdate() + "\nCRC:\t\t\t\t" + this.getCRCed() + "\nMaxFrames:\t\t\t" + this.getMaxFrames() + "\nMaxTagSize:\t\t\t" + this.getMaxTagSize() + "\nTextEncoded:\t\t\t" + this.getTextEncode() + "\nMaxTextSize:\t\t\t" + this.getMaxTextSize() + "\nImageEncoded:\t\t\t" + this.getImageEncode() + "\nImageRestriction:\t\t" + this.getImageRestriction();
    }
}

