/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.multimedia.mp3.id3.NullsoftID3GenreTable;
import de.quippy.javamod.multimedia.mp3.id3.exceptions.ID3FieldDataException;
import de.quippy.javamod.system.Helpers;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3v1Tag {
    private static final int TAG_SIZE = 128;
    private static final int TITLE_SIZE = 30;
    private static final int ARTIST_SIZE = 30;
    private static final int ALBUM_SIZE = 30;
    private static final int YEAR_SIZE = 4;
    private static final int COMMENT_SIZE = 29;
    private static final int TRACK_LOCATION = 126;
    private static final int GENRE_LOCATION = 127;
    private static final int MAX_GENRE = 255;
    private static final int MAX_TRACK = 255;
    private static final String ENC_TYPE = "ISO-8859-1";
    private static final String TAG_START = "TAG";
    private boolean headerExists = false;
    private String title = null;
    private String artist = null;
    private String album = null;
    private String year = null;
    private String comment = null;
    private int genre;
    private int track;

    public ID3v1Tag(RandomAccessFile raf) throws FileNotFoundException, IOException {
        this.headerExists = this.checkHeader(raf);
        if (this.headerExists) {
            this.readTag(raf);
        }
    }

    private boolean checkHeader(RandomAccessFile raf) throws FileNotFoundException, IOException {
        boolean retval = false;
        if (raf.length() > 128L) {
            raf.seek(raf.length() - 128L);
            byte[] buf = new byte[3];
            if (raf.read(buf) != 3) {
                throw new IOException("Error encountered reading ID3 header");
            }
            String result = new String(buf, 0, 3, ENC_TYPE);
            retval = result.equals(TAG_START);
        }
        return retval;
    }

    private void readTag(RandomAccessFile raf) throws FileNotFoundException, IOException {
        raf.seek(raf.length() - 128L);
        byte[] buf = new byte[128];
        raf.read(buf, 0, 128);
        String tag = new String(buf, 0, 128, ENC_TYPE);
        int start = TAG_START.length();
        this.title = tag.substring(start, start += 30);
        this.artist = tag.substring(start, start += 30);
        this.album = tag.substring(start, start += 30);
        this.year = tag.substring(start, start += 4);
        this.comment = tag.substring(start, start += 29);
        this.track = tag.charAt(126);
        this.genre = tag.charAt(127);
    }

    public void writeTag(RandomAccessFile raf) throws FileNotFoundException, IOException {
        if (this.headerExists) {
            raf.seek(raf.length() - 128L);
        } else {
            raf.seek(raf.length());
        }
        raf.write(Helpers.getBytesFromString(TAG_START, TAG_START.length(), ENC_TYPE));
        raf.write(Helpers.getBytesFromString(this.title, 30, ENC_TYPE));
        raf.write(Helpers.getBytesFromString(this.artist, 30, ENC_TYPE));
        raf.write(Helpers.getBytesFromString(this.album, 30, ENC_TYPE));
        raf.write(Helpers.getBytesFromString(this.year, 4, ENC_TYPE));
        raf.write(Helpers.getBytesFromString(this.comment, 29, ENC_TYPE));
        raf.write((byte)this.track);
        raf.write((byte)this.genre);
        this.headerExists = true;
    }

    public void removeTag(RandomAccessFile raf) throws FileNotFoundException, IOException {
        if (this.headerExists) {
            raf.setLength(raf.length() - 128L);
            this.headerExists = false;
        }
    }

    public String getGenreString() {
        return NullsoftID3GenreTable.getGenre(this.genre);
    }

    public boolean setGenreString(String str) {
        int result = NullsoftID3GenreTable.getGenre(str);
        boolean retval = false;
        if (result != -1) {
            this.genre = result;
            retval = true;
        }
        return retval;
    }

    public boolean tagExists() {
        return this.headerExists;
    }

    public String getTitle() {
        return this.title.trim();
    }

    public void setTitle(String newTitle) {
        this.title = newTitle.length() > 30 ? newTitle.substring(0, 30) : newTitle;
    }

    public String getArtist() {
        return this.artist.trim();
    }

    public void setArtist(String newArtist) {
        this.artist = newArtist.length() > 30 ? newArtist.substring(0, 30) : newArtist;
    }

    public String getAlbum() {
        return this.album.trim();
    }

    public void setAlbum(String newAlbum) {
        this.album = newAlbum.length() > 30 ? newAlbum.substring(0, 30) : newAlbum;
    }

    public String getYear() {
        return this.year.trim();
    }

    public void setYear(String newYear) {
        this.year = newYear.length() > 4 ? newYear.substring(0, 4) : newYear;
    }

    public String getComment() {
        return this.comment.trim();
    }

    public void setComment(String newComment) {
        this.comment = this.comment.length() > 29 ? newComment.substring(0, 29) : newComment;
    }

    public int getTrack() {
        return this.track;
    }

    public void setTrack(int newTrack) {
        if (newTrack <= 255 && newTrack >= 0) {
            this.track = newTrack;
        }
    }

    public int getGenre() {
        return this.genre;
    }

    public void setGenre(int newGenre) throws ID3FieldDataException {
        if (newGenre > 255 || newGenre < 0) {
            throw new ID3FieldDataException("Invalid genre value.  Must be between 0 and 255.");
        }
        this.genre = newGenre;
    }

    public int getSize() {
        int retval = 0;
        if (this.headerExists) {
            retval = 128;
        }
        return retval;
    }

    public String toString() {
        return "ID3v1.0\nTagSize:\t\t\t" + this.getSize() + " bytes\nTitle:\t\t\t\t" + this.getTitle() + "\nArtist:\t\t\t\t" + this.getArtist() + "\nAlbum:\t\t\t\t" + this.getAlbum() + "\nYear:\t\t\t\t" + this.getYear() + "\nComment:\t\t\t" + this.getComment() + "\nTrack:\t\t\t\t" + this.getTrack() + "\nGenre:\t\t\t\t" + this.getGenreString();
    }
}

