/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.multimedia.mp3.streaming.IcyInputStream;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseListener;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import de.quippy.mp3.decoder.Bitstream;
import de.quippy.mp3.decoder.BitstreamException;
import de.quippy.mp3.decoder.Decoder;
import de.quippy.mp3.decoder.Header;
import de.quippy.mp3.decoder.SampleBuffer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFormat;

public class MP3Mixer
extends BasicMixer {
    private int[] dspOutput;
    private byte[] output;
    private InputStream inputStream;
    private Bitstream bitStream;
    private Decoder decoder;
    private URL mp3FileUrl;
    private TagParseListener tagParseListener;
    private int played_ms;
    private volatile int isSeeking;

    public MP3Mixer(URL mp3FileUrl) {
        this.mp3FileUrl = mp3FileUrl;
    }

    public void setTagParserListener(TagParseListener tagParseListener) {
        this.tagParseListener = tagParseListener;
    }

    private void initialize() {
        try {
            this.closeAudioDevice();
            if (this.bitStream != null) {
                try {
                    this.bitStream.close();
                    this.bitStream = null;
                }
                catch (BitstreamException bitstreamException) {
                    // empty catch block
                }
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!this.isStreaming()) {
                this.inputStream = this.mp3FileUrl.openStream();
            } else {
                URLConnection conn = this.mp3FileUrl.openConnection();
                conn.setRequestProperty("Icy-Metadata", "1");
                this.inputStream = new IcyInputStream((InputStream)new BufferedInputStream(conn.getInputStream()), this.tagParseListener);
            }
            this.bitStream = new Bitstream(this.inputStream);
            this.decoder = new Decoder();
            this.played_ms = 0;
            this.isSeeking = 0;
        }
        catch (Exception ex) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Log.error("[MP3Mixer]", ex);
        }
    }

    private boolean isStreaming() {
        return !this.mp3FileUrl.getProtocol().equalsIgnoreCase("file");
    }

    public boolean isSeekSupported() {
        return !this.isStreaming();
    }

    public int getMillisecondPosition() {
        if (!this.isStreaming()) {
            return this.played_ms;
        }
        return 0;
    }

    public int getLengthInMilliseconds() {
        if (!this.isStreaming()) {
            try {
                this.initialize();
                Header h = this.bitStream.readFrame();
                if (h != null) {
                    return (int)((double)h.total_ms(this.inputStream.available()) + 0.5);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    public void setMillisecondPosition(int milliseconds) {
        block17: {
            if (this.isSeeking > 0) {
                return;
            }
            try {
                try {
                    if (this.isStreaming()) break block17;
                    this.isSeeking = 1;
                    while (this.isSeeking != 2) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.played_ms > milliseconds) {
                        if (this.bitStream != null) {
                            try {
                                this.bitStream.close();
                                this.bitStream = null;
                            }
                            catch (BitstreamException bitstreamException) {
                                // empty catch block
                            }
                        }
                        if (this.inputStream != null) {
                            try {
                                this.inputStream.close();
                                this.inputStream = null;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        this.inputStream = this.mp3FileUrl.openStream();
                        this.bitStream = new Bitstream(this.inputStream);
                        this.decoder = new Decoder();
                        this.played_ms = 0;
                    }
                    float f_played_ms = this.played_ms;
                    while (f_played_ms < (float)milliseconds) {
                        Header h = this.bitStream.readFrame();
                        if (h == null) break;
                        f_played_ms += h.ms_per_frame();
                        this.bitStream.closeFrame();
                    }
                    this.played_ms = (int)((double)f_played_ms + 0.5);
                }
                catch (Throwable ex) {
                    Log.error("[MP3Mixer]", ex);
                    this.isSeeking = 0;
                }
            }
            finally {
                this.isSeeking = 0;
            }
        }
    }

    public int getChannelCount() {
        if (this.decoder != null) {
            return this.decoder.getOutputChannels();
        }
        return 0;
    }

    public int getCurrentKBperSecond() {
        Header h;
        if (this.bitStream != null && (h = this.bitStream.getHeader()) != null) {
            return h.bitrate_instant() / 1000;
        }
        return 0;
    }

    public int getCurrentSampleFrequency() {
        if (this.decoder != null) {
            return this.decoder.getOutputFrequency() / 1000;
        }
        return 0;
    }

    private byte[] getOutputBuffer(int length) {
        if (this.output == null || this.output.length < length) {
            this.output = new byte[length];
        }
        return this.output;
    }

    private int[] getDspBuffer(int length) {
        if (this.dspOutput == null || this.dspOutput.length < length) {
            this.dspOutput = new int[length];
        }
        return this.dspOutput;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startPlayback() {
        this.initialize();
        this.setIsPlaying();
        try {
            Header h = this.bitStream.readFrame();
            if (h == null) {
                return;
            }
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitStream);
            this.setAudioFormat(new AudioFormat(this.decoder.getOutputFrequency(), 16, this.decoder.getOutputChannels(), true, false));
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            block27: do {
                short[] samples = output.getBuffer();
                this.played_ms += samples.length / this.decoder.getOutputChannels() * 1000 / this.decoder.getOutputFrequency();
                int origLen = output.getBufferLength();
                int len = origLen << 1;
                byte[] b = this.getOutputBuffer(len);
                int[] dsp = this.getDspBuffer(origLen);
                int idx = 0;
                int pos = 0;
                while (true) {
                    if (origLen-- <= 0) {
                        Helpers.convertAnyToSigned24Bit(dsp, 0, b, 0, len, this.decoder.getOutputChannels(), 16, false, true);
                        this.writeSampleDataToProcessor(dsp, 0, len >> 1);
                        this.writeSampleDataToLine(b, 0, len);
                        this.bitStream.closeFrame();
                        if (!this.isStopping()) break;
                        this.setIsStopped();
                        break block27;
                    }
                    short s = samples[pos++];
                    b[idx++] = (byte)s;
                    b[idx++] = (byte)(s >>> 8);
                }
                if (this.isPausing()) {
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.isSeeking > 0) {
                    this.isSeeking = 2;
                    while (this.isSeeking > 0) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if ((h = this.bitStream.readFrame()) == null) continue;
                output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitStream);
            } while (h != null);
            if (h != null) return;
            this.setHasFinished();
            return;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.closeAudioDevice();
            this.setIsStopped();
            if (this.bitStream != null) {
                try {
                    this.bitStream.close();
                    this.bitStream = null;
                }
                catch (BitstreamException bitstreamException) {}
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                catch (IOException iOException) {}
            }
        }
    }
}

