/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mp3.MP3InfoPanel;
import de.quippy.javamod.multimedia.mp3.MP3Mixer;
import de.quippy.javamod.multimedia.mp3.MP3StreamInfoPanel;
import de.quippy.javamod.multimedia.mp3.id3.MP3FileID3Controller;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseEvent;
import de.quippy.javamod.multimedia.mp3.streaming.TagParseListener;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class MP3Container
extends MultimediaContainer
implements TagParseListener {
    private static final String[] MP3FILEEXTENSION = new String[]{"mp1", "mp2", "mp3"};
    private MP3Mixer currentMixer;
    private MP3InfoPanel mp3InfoPanel;
    private MP3StreamInfoPanel mp3StreamInfoPanel;
    private MP3FileID3Controller mp3FileIDTags = null;
    private JPanel mp3ConfigPanel;
    private boolean isStreaming;

    static {
        MultimediaContainerManager.registerContainer(new MP3Container());
    }

    public MultimediaContainer getInstance(URL mp3FileUrl) {
        MultimediaContainer result = super.getInstance(mp3FileUrl);
        boolean bl = this.isStreaming = !mp3FileUrl.getProtocol().equalsIgnoreCase("file");
        if (!this.isStreaming) {
            this.mp3FileIDTags = new MP3FileID3Controller(mp3FileUrl);
            ((MP3InfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.mp3FileIDTags);
        } else {
            this.mp3FileIDTags = null;
            ((MP3StreamInfoPanel)this.getInfoPanel()).clearFields();
        }
        return result;
    }

    public String getSongName() {
        if (this.mp3FileIDTags != null) {
            return this.mp3FileIDTags.getShortDescription();
        }
        return super.getSongName();
    }

    public boolean canExport() {
        return true;
    }

    public JPanel getConfigPanel() {
        if (this.mp3ConfigPanel == null) {
            this.mp3ConfigPanel = new JPanel();
        }
        return this.mp3ConfigPanel;
    }

    public JPanel getInfoPanel() {
        if (this.isStreaming) {
            if (this.mp3StreamInfoPanel == null) {
                this.mp3StreamInfoPanel = new MP3StreamInfoPanel();
            }
            return this.mp3StreamInfoPanel;
        }
        if (this.mp3InfoPanel == null) {
            this.mp3InfoPanel = new MP3InfoPanel();
        }
        return this.mp3InfoPanel;
    }

    public String[] getFileExtensionList() {
        return MP3FILEEXTENSION;
    }

    public String getName() {
        return "MP3-File";
    }

    public void configurationChanged(Properties newProps) {
    }

    public void configurationSave(Properties props) {
    }

    public Mixer createNewMixer() {
        this.currentMixer = new MP3Mixer(this.getFileURL());
        this.currentMixer.setTagParserListener(this);
        return this.currentMixer;
    }

    public void tagParsed(TagParseEvent tpe) {
        JPanel panel = this.getInfoPanel();
        if (panel instanceof MP3StreamInfoPanel) {
            ((MP3StreamInfoPanel)panel).fillInfoPanelWith(tpe.getTag());
            String currentSongName = ((MP3StreamInfoPanel)panel).getCurrentSongName();
            if (currentSongName != null && currentSongName.length() != 0) {
                this.fireMultimediaContainerEvent(new MultimediaContainerEvent(this, MultimediaContainerEvent.SONG_NAME_CHANGED, currentSongName));
            }
        }
    }
}

