/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.mixer.interpolation;

public class CubicSpline {
    public static final int SPLINE_QUANTBITS = 14;
    private static final int SPLINE_QUANTSCALE = 16384;
    private static final int SPLINE_FRACBITS = 10;
    private static final int SPLINE_LUTLEN = 1024;
    public static final int SPLINE_FRACSHIFT = 4;
    public static final int SPLINE_FRACMASK = 4092;
    public static final int[] lut = new int[4096];

    static {
        CubicSpline.initialize();
    }

    private CubicSpline() {
    }

    private static void initialize() {
        double lFlen = 9.765625E-4;
        double lScale = 16384.0;
        int i = 0;
        while (i < 1024) {
            double lX = (double)i * lFlen;
            int lIdx = i << 2;
            double lCm1 = Math.floor(0.5 + lScale * (-0.5 * lX * lX * lX + 1.0 * lX * lX - 0.5 * lX));
            double lC0 = Math.floor(0.5 + lScale * (1.5 * lX * lX * lX - 2.5 * lX * lX + 1.0));
            double lC1 = Math.floor(0.5 + lScale * (-1.5 * lX * lX * lX + 2.0 * lX * lX + 0.5 * lX));
            double lC2 = Math.floor(0.5 + lScale * (0.5 * lX * lX * lX - 0.5 * lX * lX));
            CubicSpline.lut[lIdx + 0] = (int)(lCm1 < -lScale ? -lScale : (lCm1 > lScale ? lScale : lCm1));
            CubicSpline.lut[lIdx + 1] = (int)(lC0 < -lScale ? -lScale : (lC0 > lScale ? lScale : lC0));
            CubicSpline.lut[lIdx + 2] = (int)(lC1 < -lScale ? -lScale : (lC1 > lScale ? lScale : lC1));
            CubicSpline.lut[lIdx + 3] = (int)(lC2 < -lScale ? -lScale : (lC2 > lScale ? lScale : lC2));
            int lSum = lut[lIdx + 0] + lut[lIdx + 1] + lut[lIdx + 2] + lut[lIdx + 3];
            if (lSum != 16384) {
                int lMax = lIdx;
                if (lut[lIdx + 1] > lut[lMax]) {
                    lMax = lIdx + 1;
                }
                if (lut[lIdx + 2] > lut[lMax]) {
                    lMax = lIdx + 2;
                }
                if (lut[lIdx + 3] > lut[lMax]) {
                    lMax = lIdx + 3;
                }
                int n = lMax;
                lut[n] = lut[n] + (16384 - lSum);
            }
            ++i;
        }
    }
}

