/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.mixer;

import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.instrument.Envelope;
import de.quippy.javamod.multimedia.mod.loader.instrument.Instrument;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.Pattern;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.system.Helpers;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class BasicModMixer {
    protected ChannelMemory[] channelMemory;
    protected int maxChannels;
    protected static final int MAX_NNA_CHANNELS = 200;
    protected int currentTempo;
    protected int currentBPM;
    protected int globalTuning;
    protected int globalVolume;
    protected int globalVolumSlideValue;
    protected boolean useFastSlides;
    protected int frequencyTableType;
    protected int currentTick;
    protected int currentRow;
    protected int currentArrangement;
    protected int currentPatternIndex;
    protected int samplePerTicks;
    protected int patternDelayCount;
    protected int patternTicksDelayCount;
    protected Pattern currentPattern;
    protected int volRampLen;
    protected int patternBreakRowIndex;
    protected int patternPosJumpPatternIndex;
    protected boolean jumpLoopPositionSet;
    protected int jumpLoopPatternIndex;
    protected int jumpLoopPatternRow;
    protected int jumpLoopRepeatCount;
    protected final Module mod;
    protected int sampleRate;
    protected int doISP;
    protected boolean doNoLoops;
    protected boolean doFastForward;
    protected boolean modFinished;
    protected boolean doFadeOut;
    protected int fadeOutValue;
    protected int fadeOutFac;
    protected int fadeOutSub;
    protected int[] vRampL;
    protected int[] vRampR;
    protected int[] nvRampL;
    protected int[] nvRampR;

    public BasicModMixer(Module mod, int sampleRate, int doISP, boolean doNoLoops) {
        this.mod = mod;
        this.sampleRate = sampleRate;
        this.doISP = doISP;
        this.doNoLoops = doNoLoops;
        this.maxChannels = mod.getNChannels();
        if (mod.getModType() == 8) {
            this.maxChannels += 200;
        }
        this.channelMemory = new ChannelMemory[this.maxChannels];
        this.vRampL = new int[16];
        this.vRampR = new int[16];
        this.nvRampL = new int[16];
        this.nvRampR = new int[16];
        this.initializeMixer();
    }

    public void changeSampleRate(int newSampleRate) {
        this.sampleRate = newSampleRate;
        this.samplePerTicks = this.calculateSamplesPerTick();
        this.calculateGlobalTuning();
        this.calculateVolRampLen();
        int c = 0;
        while (c < this.maxChannels) {
            ChannelMemory aktMemo = this.channelMemory[c];
            this.setNewPlayerTuningFor(aktMemo);
            ++c;
        }
    }

    public void changeISP(int newISP) {
        this.doISP = newISP;
    }

    public void changeDoNoLoops(boolean newDoNoLoops) {
        this.doNoLoops = newDoNoLoops;
    }

    public void setIsFastForward(boolean newFastForward) {
        this.doFastForward = newFastForward;
    }

    protected abstract void initializeMixer(int var1, ChannelMemory var2);

    public void initializeMixer() {
        this.calculateGlobalTuning();
        this.frequencyTableType = this.mod.getFrequencyTable();
        this.currentTempo = this.mod.getTempo();
        this.currentBPM = this.mod.getBPMSpeed();
        this.globalVolume = this.mod.getBaseVolume();
        this.globalVolumSlideValue = 0;
        this.useFastSlides = this.mod.doFastSlides();
        this.samplePerTicks = this.calculateSamplesPerTick();
        this.patternTicksDelayCount = 0;
        this.patternDelayCount = 0;
        this.currentRow = 0;
        this.currentArrangement = 0;
        this.currentTick = 0;
        this.currentArrangement = 0;
        this.currentPatternIndex = this.mod.getArrangement()[this.currentArrangement];
        this.currentPattern = this.mod.getPatternContainer().getPattern(this.currentPatternIndex);
        this.patternPosJumpPatternIndex = -1;
        this.patternBreakRowIndex = -1;
        this.jumpLoopPositionSet = false;
        this.jumpLoopRepeatCount = -1;
        this.jumpLoopPatternRow = -1;
        this.jumpLoopPatternIndex = -1;
        this.modFinished = false;
        this.calculateVolRampLen();
        this.mod.resetLoopRecognition();
        this.doFadeOut = false;
        this.fadeOutFac = 8;
        this.fadeOutValue = 1 << this.fadeOutFac;
        this.fadeOutSub = 1;
        int nChannels = this.mod.getNChannels();
        int c = 0;
        while (c < this.maxChannels) {
            this.channelMemory[c] = new ChannelMemory();
            if (c < nChannels) {
                ChannelMemory aktMemo = this.channelMemory[c];
                aktMemo.panning = this.mod.getPanningValue(c);
                aktMemo.channelVolume = this.mod.getChannelVolume(c);
                this.initializeMixer(c, aktMemo);
            }
            ++c;
        }
    }

    protected int calculateSamplesPerTick() {
        return ((this.sampleRate << 1) + (this.sampleRate >> 1)) / this.currentBPM;
    }

    private void calculateGlobalTuning() {
        this.globalTuning = (int)(3753235185664L / (long)this.sampleRate);
    }

    private void calculateVolRampLen() {
        this.volRampLen = this.sampleRate * 146 / 100000;
        if (this.volRampLen < 8) {
            this.volRampLen = 8;
        }
    }

    protected int getFineTunePeriod(ChannelMemory aktMemo, int period) {
        int noteIndex = period - 1;
        switch (this.frequencyTableType) {
            case 0: 
            case 1: {
                int s3mNote = Helpers.FreqS3MTable[noteIndex % 12];
                int s3mOctave = noteIndex / 12;
                if (aktMemo.currentFinetuneFrequency <= 0) {
                    aktMemo.currentFinetuneFrequency = 8363;
                }
                return (int)(8363L * ((long)s3mNote << 7) / ((long)aktMemo.currentFinetuneFrequency << s3mOctave));
            }
            case 2: {
                return Helpers.protracker_fineTunedPeriods[(aktMemo.currentFineTune >> 4) + 8][period - 25];
            }
            case 4: 
            case 16: {
                int fineTune = aktMemo.currentFineTune;
                int rFine = fineTune >> 4;
                int note = (noteIndex % 12 << 3) + 8;
                int octave = noteIndex / 12;
                int logIndex = note + rFine;
                if (logIndex < 0) {
                    logIndex = 0;
                } else if (logIndex > 103) {
                    logIndex = 103;
                }
                int v1 = Helpers.logtab[logIndex];
                if (fineTune < 0) {
                    --rFine;
                    fineTune = -fineTune;
                } else {
                    ++rFine;
                }
                logIndex = note + rFine;
                if (logIndex < 0) {
                    logIndex = 0;
                } else if (logIndex > 103) {
                    logIndex = 103;
                }
                int v2 = Helpers.logtab[logIndex];
                rFine = fineTune & 0xF;
                return v1 * (16 - rFine) + v2 * rFine >> octave + 4;
            }
            case 8: {
                int p = 7680 - (noteIndex << 6) - (aktMemo.currentFineTune >> 1);
                if (p < 1) {
                    return 4;
                }
                return p << 2;
            }
        }
        return (int)(8363L * (long)period / (long)aktMemo.currentFinetuneFrequency);
    }

    protected int getFineTunePeriod(ChannelMemory aktMemo) {
        if (this.frequencyTableType >= 2) {
            return aktMemo.assignedNoteIndex == 0 ? 0 : this.getFineTunePeriod(aktMemo, aktMemo.assignedNoteIndex + aktMemo.currentTranspose);
        }
        if (this.frequencyTableType == 1 || this.frequencyTableType == 0) {
            return aktMemo.assignedNoteIndex == 0 ? 0 : this.getFineTunePeriod(aktMemo, aktMemo.assignedNoteIndex);
        }
        return aktMemo.assignedNotePeriod == 0 ? 0 : this.getFineTunePeriod(aktMemo, aktMemo.assignedNotePeriod << 4);
    }

    protected void setNewPlayerTuningFor(ChannelMemory aktMemo, int newPeriod) {
        if (newPeriod <= 0) {
            aktMemo.currentTuning = 0;
        } else if (this.frequencyTableType == 8) {
            int newFrequency = Helpers.lintab[(newPeriod >>= 2) % 768] >> newPeriod / 768;
            aktMemo.currentTuning = (int)(((long)newFrequency << 16) / (long)this.sampleRate);
        } else {
            aktMemo.currentTuning = this.globalTuning / newPeriod;
        }
    }

    protected void setNewPlayerTuningFor(ChannelMemory aktMemo) {
        this.setNewPlayerTuningFor(aktMemo, aktMemo.currentNotePeriod);
    }

    protected long cutOffToFrequency(long cutOff, int flt_modifier, boolean isExFilterRange) {
        double fac = isExFilterRange ? 10240.0 : 12288.0;
        double fc = 110.0 * Math.pow(2.0, 0.25 + (double)(cutOff * (long)(flt_modifier + 256)) / fac);
        long freq = (long)fc;
        if (freq < 120L) {
            return 120L;
        }
        if (freq > 20000L) {
            return 20000L;
        }
        if (freq << 1 > (long)this.sampleRate) {
            return (long)this.sampleRate >> 1;
        }
        return freq;
    }

    protected void setupChannelFilter(ChannelMemory aktMemo, boolean bReset, int flt_modifier) {
        double cutOff = aktMemo.nCutOff + aktMemo.nCutSwing & 0x7F;
        double resonance = aktMemo.nResonance + aktMemo.nResSwing & 0x7F;
        double fc = this.cutOffToFrequency((long)cutOff, flt_modifier, (this.mod.getSongFlags() & 0x8000) != 0);
        double dmpfac = Math.pow(10.0, -(0.1875 * resonance) / 20.0);
        double d = (1.0 - 2.0 * dmpfac) * (fc *= 6.28318530716 / (double)this.sampleRate);
        if (d > 2.0) {
            d = 2.0;
        }
        d = (2.0 * dmpfac - d) / fc;
        double e = Math.pow(1.0 / fc, 2.0);
        double fg = 1.0 / (1.0 + d + e);
        double fg1 = -e * fg;
        double fg0 = 1.0 - fg - fg1;
        switch (aktMemo.nFilterMode) {
            case 1: {
                aktMemo.nFilter_A0 = (long)((1.0 - fg) * 4.294967296E9);
                aktMemo.nFilter_B0 = (long)(fg0 * 4.294967296E9);
                aktMemo.nFilter_B1 = (long)(fg1 * 4.294967296E9);
                aktMemo.nFilter_HP = -1L;
                break;
            }
            default: {
                aktMemo.nFilter_A0 = (long)(fg * 4.294967296E9);
                aktMemo.nFilter_B0 = (long)(fg0 * 4.294967296E9);
                aktMemo.nFilter_B1 = (long)(fg1 * 4.294967296E9);
                aktMemo.nFilter_HP = 0L;
            }
        }
        if (bReset) {
            aktMemo.nFilter_Y2 = 0L;
            aktMemo.nFilter_Y1 = 0L;
        }
        aktMemo.filterOn = true;
    }

    private long doResonance(ChannelMemory actMemo, long s) {
        long fy = s * actMemo.nFilter_A0 + actMemo.nFilter_Y1 * actMemo.nFilter_B0 + actMemo.nFilter_Y2 * actMemo.nFilter_B1 + 4096L >> 32;
        actMemo.nFilter_Y2 = actMemo.nFilter_Y1;
        actMemo.nFilter_Y1 = fy - (s & actMemo.nFilter_HP);
        return fy;
    }

    protected abstract void doRowEffects(ChannelMemory var1);

    protected abstract void doTickEffekts(ChannelMemory var1);

    protected abstract void doVolumeColumnRowEffekt(ChannelMemory var1);

    protected abstract void doVolumeColumnTickEffekt(ChannelMemory var1);

    protected abstract void resetAllEffects(ChannelMemory var1, PatternElement var2, boolean var3);

    protected abstract boolean isNoteDelayEffekt(ChannelMemory var1);

    protected abstract boolean isPortaToNoteEffekt(ChannelMemory var1);

    protected abstract boolean isSampleOffsetEffekt(ChannelMemory var1);

    protected void processEnvelopes(ChannelMemory aktMemo) {
        int currentVolume = aktMemo.currentVolume << 8;
        int currentPanning = aktMemo.panning;
        Instrument currentInstrument = aktMemo.assignedInstrument;
        if (currentInstrument != null) {
            Envelope pitchEnv;
            Envelope panningEnv;
            Envelope volumeEnv = currentInstrument.volumeEnvelope;
            if (volumeEnv != null && volumeEnv.on) {
                aktMemo.volEnvPos = volumeEnv.updatePosition(aktMemo.volEnvPos, aktMemo.keyOff);
                int newVol = volumeEnv.getValueForPosition(aktMemo.volEnvPos);
                currentVolume = currentVolume * newVol >> 9;
            }
            if ((panningEnv = currentInstrument.panningEnvelope) != null && panningEnv.on) {
                aktMemo.panEnvPos = panningEnv.updatePosition(aktMemo.panEnvPos, aktMemo.keyOff);
                currentPanning += panningEnv.getValueForPosition(aktMemo.panEnvPos) - 256;
            }
            if (aktMemo.keyOff) {
                if (volumeEnv.on) {
                    aktMemo.fadeOutVolume -= currentInstrument.volumeFadeOut << 1;
                    if (aktMemo.fadeOutVolume < 0) {
                        aktMemo.fadeOutVolume = 0;
                    }
                } else {
                    aktMemo.fadeOutVolume = 0;
                }
                currentVolume = currentVolume * aktMemo.fadeOutVolume >> 16;
            }
            if ((pitchEnv = currentInstrument.pitchEnvelope) != null && pitchEnv.on) {
                aktMemo.pitchEnvPos = pitchEnv.updatePosition(aktMemo.pitchEnvPos, aktMemo.keyOff);
                int pitchValue = pitchEnv.getValueForPosition(aktMemo.pitchEnvPos) - 256;
                if (pitchEnv.filter) {
                    this.setupChannelFilter(aktMemo, !aktMemo.filterOn, pitchValue);
                } else {
                    long a = aktMemo.currentNotePeriod;
                    long b = 0L;
                    if (pitchValue < 0) {
                        if ((pitchValue = -pitchValue) > 255) {
                            pitchValue = 255;
                        }
                        b = Helpers.LinearSlideUpTable[pitchValue];
                    } else {
                        if (pitchValue > 255) {
                            pitchValue = 255;
                        }
                        b = Helpers.LinearSlideDownTable[pitchValue];
                    }
                    this.setNewPlayerTuningFor(aktMemo, (int)(a * b >> 16));
                }
            }
        }
        currentVolume = currentVolume * aktMemo.channelVolume >> 6;
        currentVolume = currentVolume * this.globalVolume >> 7;
        if ((currentVolume = currentVolume * this.fadeOutValue >> this.fadeOutFac) < 0) {
            currentVolume = 0;
        } else if (currentVolume > 16384) {
            currentVolume = 16384;
        }
        if (currentPanning < 0) {
            currentPanning = 0;
        } else if (currentPanning > 256) {
            currentPanning = 256;
        }
        aktMemo.actRampVolLeft = aktMemo.actVolumeLeft;
        aktMemo.actRampVolRight = aktMemo.actVolumeRight;
        aktMemo.actVolumeLeft = currentVolume * (256 - currentPanning << 8);
        aktMemo.actVolumeRight = currentVolume * (currentPanning << 8);
        if (aktMemo.doSurround) {
            aktMemo.actVolumeLeft = -aktMemo.actVolumeLeft;
        }
        if (aktMemo.actVolumeLeft != aktMemo.actRampVolLeft) {
            aktMemo.deltaVolLeft = aktMemo.actVolumeLeft - aktMemo.actRampVolLeft;
            aktMemo.deltaVolLeft = aktMemo.deltaVolLeft > this.volRampLen ? (aktMemo.deltaVolLeft /= this.volRampLen) : (aktMemo.deltaVolLeft /= aktMemo.deltaVolLeft);
        } else {
            aktMemo.deltaVolLeft = 0;
        }
        if (aktMemo.actVolumeRight != aktMemo.actRampVolRight) {
            aktMemo.deltaVolRight = aktMemo.actVolumeRight - aktMemo.actRampVolRight;
            aktMemo.deltaVolRight = aktMemo.deltaVolRight > this.volRampLen ? (aktMemo.deltaVolRight /= this.volRampLen) : (aktMemo.deltaVolRight /= aktMemo.deltaVolRight);
        } else {
            aktMemo.deltaVolRight = 0;
        }
        Sample currentSample = aktMemo.currentSample;
        if (currentSample != null && currentSample.vibratoDepth > 0 && aktMemo.currentNotePeriod > 0) {
            int periodAdd;
            if (currentSample.vibratoSweep == 0) {
                aktMemo.autoVibratoAmplitude = currentSample.vibratoDepth << 8;
            } else if (!aktMemo.keyOff) {
                aktMemo.autoVibratoAmplitude += (currentSample.vibratoDepth << 8) / currentSample.vibratoSweep;
                if (aktMemo.autoVibratoAmplitude >> 8 > currentSample.vibratoDepth) {
                    aktMemo.autoVibratoAmplitude = currentSample.vibratoDepth << 8;
                }
            }
            aktMemo.autoVibratoTablePos += currentSample.vibratoRate;
            switch (currentSample.vibratoType & 7) {
                default: {
                    periodAdd = Helpers.ft2VibratoTable[aktMemo.autoVibratoTablePos & 0xFF];
                    break;
                }
                case 1: {
                    periodAdd = (aktMemo.autoVibratoTablePos & 0x80) == 128 ? 64 : -64;
                    break;
                }
                case 2: {
                    periodAdd = (64 + (aktMemo.autoVibratoTablePos >> 1) & 0x7F) - 64;
                    break;
                }
                case 3: {
                    periodAdd = (64 - (aktMemo.autoVibratoTablePos >> 1) & 0x7F) - 64;
                    break;
                }
                case 4: {
                    periodAdd = Helpers.ModRandomTable[aktMemo.autoVibratoTablePos & 0x3F];
                }
            }
            periodAdd = periodAdd * aktMemo.autoVibratoAmplitude >> 8;
            this.setNewPlayerTuningFor(aktMemo, aktMemo.currentNotePeriod + (periodAdd >> 4));
        }
    }

    protected void resetInstrument(ChannelMemory aktMemo) {
        aktMemo.currentSamplePos = 0;
        aktMemo.currentTuningPos = 0;
        aktMemo.currentDirection = 0;
        aktMemo.autoVibratoAmplitude = 0;
        aktMemo.autoVibratoTablePos = 0;
        aktMemo.pitchEnvPos = -1;
        aktMemo.panEnvPos = -1;
        aktMemo.volEnvPos = -1;
        aktMemo.instrumentFinished = false;
        aktMemo.filterOn = false;
    }

    public int getCurrentUsedChannels() {
        int result = 0;
        int i = 0;
        while (i < this.maxChannels) {
            if (this.isChannelActive(this.channelMemory[i])) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private boolean isChannelActive(ChannelMemory actMemo) {
        return actMemo.currentSample != null && actMemo.currentSample.sample != null && actMemo.currentTuning != 0 && !actMemo.instrumentFinished;
    }

    protected ChannelMemory getNNAChannelFor(ChannelMemory aktMemo) {
        int lowVol = 16384;
        ChannelMemory result = null;
        int c = this.mod.getNChannels();
        while (c < this.maxChannels) {
            ChannelMemory memo = this.channelMemory[c];
            int currentVolume = memo.currentVolume;
            if (currentVolume == 0) {
                return memo;
            }
            if (currentVolume < lowVol) {
                lowVol = currentVolume;
                result = memo;
            }
            ++c;
        }
        return result;
    }

    protected void setNewInstrumentAndPeriod(ChannelMemory aktMemo) {
        Instrument inst;
        PatternElement element = aktMemo.currentElement;
        Sample newSample = null;
        if (element.getInstrument() > 0) {
            if (aktMemo.assignedInstrument != null) {
                inst = aktMemo.assignedInstrument;
                newSample = this.mod.getInstrumentContainer().getSample(inst.getSampleIndex(aktMemo.assignedNoteIndex - 1));
                aktMemo.assignedNoteIndex = inst.getNoteIndex(aktMemo.assignedNoteIndex - 1) + 1;
                if ((inst.initialFilterCutoff & 0x80) != 0) {
                    aktMemo.nCutOff = inst.initialFilterCutoff & 0x7F;
                }
                if ((inst.initialFilterResonance & 0x80) != 0) {
                    aktMemo.nResonance = inst.initialFilterResonance & 0x7F;
                }
            } else {
                newSample = this.mod.getInstrumentContainer().getSample(aktMemo.assignedInstrumentIndex - 1);
            }
            if (newSample != null) {
                int pan = newSample.panning;
                if (pan != -1) {
                    aktMemo.doSurround = false;
                    aktMemo.panning = pan;
                }
                aktMemo.fadeOutVolume = 65536;
                aktMemo.currentSetVolume = aktMemo.currentVolume = newSample.volume;
            }
        }
        if (element.getPeriod() > 0 || element.getNoteIndex() > 0) {
            this.resetAllEffects(aktMemo, element, true);
            aktMemo.keyOff = false;
            if (aktMemo.assignedInstrument != null || aktMemo.assignedInstrumentIndex > 0) {
                if (newSample == null) {
                    if (aktMemo.assignedInstrument != null) {
                        inst = aktMemo.assignedInstrument;
                        newSample = this.mod.getInstrumentContainer().getSample(inst.getSampleIndex(aktMemo.assignedNoteIndex - 1));
                        aktMemo.assignedNoteIndex = inst.getNoteIndex(aktMemo.assignedNoteIndex - 1) + 1;
                        if ((inst.initialFilterCutoff & 0x80) != 0) {
                            aktMemo.nCutOff = inst.initialFilterCutoff & 0x7F;
                        }
                        if ((inst.initialFilterResonance & 0x80) != 0) {
                            aktMemo.nResonance = inst.initialFilterResonance & 0x7F;
                        }
                    } else {
                        newSample = this.mod.getInstrumentContainer().getSample(aktMemo.assignedInstrumentIndex - 1);
                    }
                }
                if (aktMemo.currentSample != newSample) {
                    aktMemo.currentSample = newSample;
                    if (newSample != null) {
                        this.resetInstrument(aktMemo);
                        aktMemo.currentFinetuneFrequency = newSample.baseFrequency;
                        aktMemo.currentFineTune = newSample.fineTune;
                        aktMemo.currentTranspose = newSample.transpose;
                    }
                }
            }
            if (aktMemo.currentSample != null && !this.isPortaToNoteEffekt(aktMemo)) {
                this.resetInstrument(aktMemo);
                aktMemo.portaTargetNotePeriod = aktMemo.currentNotePeriod = this.getFineTunePeriod(aktMemo);
                this.setNewPlayerTuningFor(aktMemo, aktMemo.currentNotePeriod);
                inst = aktMemo.assignedInstrument;
                if (inst != null) {
                    boolean makeFilter = false;
                    if ((inst.initialFilterCutoff & 0x80) != 0) {
                        aktMemo.nCutOff = inst.initialFilterCutoff & 0x7F;
                        makeFilter = true;
                    }
                    if ((inst.initialFilterResonance & 0x80) != 0) {
                        aktMemo.nResonance = inst.initialFilterResonance & 0x7F;
                        makeFilter = true;
                    }
                    if (aktMemo.nCutOff < 127 && makeFilter) {
                        this.setupChannelFilter(aktMemo, true, 256);
                    }
                }
            }
        }
    }

    protected void processEffekts(boolean inTick, ChannelMemory aktMemo) {
        if (inTick) {
            this.doVolumeColumnTickEffekt(aktMemo);
            this.doTickEffekts(aktMemo);
        } else {
            this.doVolumeColumnRowEffekt(aktMemo);
            this.doRowEffects(aktMemo);
        }
        this.processEnvelopes(aktMemo);
    }

    protected void doRowEvent() {
        PatternRow patternRow = this.currentPattern.getPatternRow(this.currentRow);
        if (patternRow == null) {
            return;
        }
        if (this.mod.isArrangementPositionPlayed(this.currentArrangement) && patternRow.isRowPlayed() && !this.jumpLoopPositionSet) {
            this.doFadeOut = this.doNoLoops;
        }
        patternRow.setRowPlayed();
        int nChannels = this.mod.getNChannels();
        int c = 0;
        while (c < nChannels) {
            PatternElement element = patternRow.getPatternElement(c);
            ChannelMemory aktMemo = this.channelMemory[c];
            this.resetAllEffects(aktMemo, element, false);
            aktMemo.currentElement = element;
            if (element.getPeriod() > 0) {
                aktMemo.assignedNotePeriod = element.getPeriod();
            }
            if (element.getNoteIndex() > 0) {
                aktMemo.assignedNoteIndex = element.getNoteIndex();
            }
            if (element.getInstrument() > 0) {
                aktMemo.assignedInstrumentIndex = element.getInstrument();
                aktMemo.assignedInstrument = this.mod.getInstrumentContainer().getInstrument(element.getInstrument() - 1);
            }
            aktMemo.effekt = element.getEffekt();
            aktMemo.effektParam = element.getEffektOp();
            aktMemo.volumeEffekt = element.getVolumeEffekt();
            aktMemo.volumeEffektOp = element.getVolumeEffektOp();
            if (element.getPeriod() == -1 || element.getNoteIndex() == -1) {
                aktMemo.keyOff = true;
            } else if (element.getPeriod() == -2 || element.getNoteIndex() == -2) {
                aktMemo.fadeOutVolume = 0;
            } else if (!this.isNoteDelayEffekt(aktMemo)) {
                this.setNewInstrumentAndPeriod(aktMemo);
            }
            this.processEffekts(false, aktMemo);
            ++c;
        }
    }

    protected boolean doTickEvents() {
        block13: {
            int nChannels;
            block14: {
                block15: {
                    block12: {
                        if (this.doFadeOut) {
                            this.fadeOutValue -= this.fadeOutSub;
                            if (this.fadeOutValue <= 0) {
                                return true;
                            }
                        }
                        nChannels = this.maxChannels;
                        if (this.patternTicksDelayCount <= 0) break block12;
                        int c = 0;
                        while (c < nChannels) {
                            ChannelMemory aktMemo = this.channelMemory[c];
                            this.processEffekts(true, aktMemo);
                            ++c;
                        }
                        --this.patternTicksDelayCount;
                        break block13;
                    }
                    --this.currentTick;
                    if (this.currentTick > 0) break block14;
                    this.currentTick = this.currentTempo;
                    if (this.patternDelayCount <= 0) break block15;
                    int c = 0;
                    while (c < nChannels) {
                        ChannelMemory aktMemo = this.channelMemory[c];
                        this.processEffekts(true, aktMemo);
                        ++c;
                    }
                    --this.patternDelayCount;
                    break block13;
                }
                if (this.currentArrangement >= this.mod.getSongLength()) {
                    return true;
                }
                this.doRowEvent();
                ++this.currentRow;
                if (this.currentRow < this.currentPattern.getRowCount() && this.patternBreakRowIndex == -1 && this.patternPosJumpPatternIndex == -1) break block13;
                this.mod.setArrangementPositionPlayed(this.currentArrangement);
                if (this.patternPosJumpPatternIndex != -1) {
                    this.currentArrangement = this.patternPosJumpPatternIndex;
                    this.patternPosJumpPatternIndex = -1;
                } else {
                    ++this.currentArrangement;
                }
                if (this.patternBreakRowIndex != -1) {
                    this.currentRow = this.patternBreakRowIndex;
                    this.patternBreakRowIndex = -1;
                } else {
                    this.currentRow = 0;
                }
                if (this.currentArrangement < this.mod.getSongLength()) {
                    this.currentPatternIndex = this.mod.getArrangement()[this.currentArrangement];
                    this.currentPattern = this.mod.getPatternContainer().getPattern(this.currentPatternIndex);
                } else {
                    this.currentPatternIndex = -1;
                    this.currentPattern = null;
                }
                break block13;
            }
            int c = 0;
            while (c < nChannels) {
                ChannelMemory aktMemo = this.channelMemory[c];
                this.processEffekts(true, aktMemo);
                ++c;
            }
        }
        return false;
    }

    protected void fitIntoLoops(ChannelMemory actMemo) {
        Sample ins = actMemo.currentSample;
        if (actMemo.currentDirection >= 0) {
            actMemo.currentTuningPos += actMemo.currentTuning;
            if (actMemo.currentTuningPos >= 65536) {
                actMemo.currentSamplePos += actMemo.currentTuningPos >> 16;
                actMemo.currentTuningPos &= 0xFFFF;
                if ((ins.loopType & 1) == 0) {
                    actMemo.instrumentFinished = actMemo.currentSamplePos >= ins.length;
                } else if ((ins.loopType & 4) == 0) {
                    if (actMemo.currentSamplePos >= ins.repeatStop) {
                        actMemo.currentSamplePos = ins.repeatStart + (actMemo.currentSamplePos - ins.repeatStart) % ins.repeatLength;
                    }
                } else if (actMemo.currentSamplePos >= ins.repeatStop) {
                    actMemo.currentDirection = -1;
                    actMemo.currentSamplePos = ins.repeatStop - (actMemo.currentSamplePos - ins.repeatStart) % ins.repeatLength - 1;
                }
            }
        } else {
            actMemo.currentTuningPos -= actMemo.currentTuning;
            if (actMemo.currentTuningPos <= 0) {
                int hi = (-actMemo.currentTuningPos >> 16) + 1;
                actMemo.currentSamplePos -= hi;
                actMemo.currentTuningPos += hi << 16;
                if (actMemo.currentSamplePos <= ins.repeatStart) {
                    actMemo.currentDirection = 1;
                    actMemo.currentSamplePos = ins.repeatStart + (ins.repeatStart - actMemo.currentSamplePos) % ins.repeatLength;
                }
            }
        }
    }

    private void mixChannelIntoBuffers(int[] leftBuffer, int[] rightBuffer, int startIndex, int endIndex, ChannelMemory actMemo) {
        int i = startIndex;
        while (i < endIndex) {
            long sample = actMemo.currentSample.getInterpolatedSample(this.doISP, actMemo.currentSamplePos, actMemo.currentTuningPos);
            if (actMemo.filterOn) {
                sample = this.doResonance(actMemo, sample);
            }
            long volL = actMemo.actRampVolLeft;
            if (actMemo.deltaVolLeft > 0 && volL > (long)actMemo.actVolumeLeft || actMemo.deltaVolLeft < 0 && volL < (long)actMemo.actVolumeLeft) {
                actMemo.actRampVolLeft = actMemo.actVolumeLeft;
                volL = actMemo.actRampVolLeft;
                actMemo.deltaVolLeft = 0;
            } else {
                actMemo.actRampVolLeft += actMemo.deltaVolLeft;
            }
            long volR = actMemo.actRampVolRight;
            if (actMemo.deltaVolRight > 0 && volR > (long)actMemo.actVolumeRight || actMemo.deltaVolRight < 0 && volR < (long)actMemo.actVolumeRight) {
                actMemo.actRampVolRight = actMemo.actVolumeRight;
                volR = actMemo.actRampVolRight;
                actMemo.deltaVolRight = 0;
            } else {
                actMemo.actRampVolRight += actMemo.deltaVolRight;
            }
            int n = i;
            leftBuffer[n] = leftBuffer[n] + (int)(sample * volL >> 32);
            int n2 = i++;
            rightBuffer[n2] = rightBuffer[n2] + (int)(sample * volR >> 32);
            this.fitIntoLoops(actMemo);
            if (actMemo.instrumentFinished) break;
        }
    }

    private void fillRampDataIntoBuffers(int[] leftBuffer, int[] rightBuffer, ChannelMemory aktMemo) {
        int currentTuningPos = aktMemo.currentTuningPos;
        int currentSamplePos = aktMemo.currentSamplePos;
        int currentDirection = aktMemo.currentDirection;
        boolean instrumentFinished = aktMemo.instrumentFinished;
        int actRampVolLeft = aktMemo.actRampVolLeft;
        int actRampVolRight = aktMemo.actRampVolRight;
        this.mixChannelIntoBuffers(leftBuffer, rightBuffer, 0, 16, aktMemo);
        aktMemo.currentTuningPos = currentTuningPos;
        aktMemo.currentSamplePos = currentSamplePos;
        aktMemo.instrumentFinished = instrumentFinished;
        aktMemo.currentDirection = currentDirection;
        aktMemo.actRampVolLeft = actRampVolLeft;
        aktMemo.actRampVolRight = actRampVolRight;
    }

    public int mixIntoBuffer(int[] leftBuffer, int[] rightBuffer, int count) {
        if (this.modFinished) {
            return -1;
        }
        int bufferIdx = 0;
        int endIndex = this.samplePerTicks;
        int maxEndIndex = count - 16;
        while (endIndex < maxEndIndex && !this.modFinished) {
            int c = 0;
            while (c < this.maxChannels) {
                ChannelMemory actMemo = this.channelMemory[c];
                if (!actMemo.muted && this.isChannelActive(actMemo)) {
                    this.mixChannelIntoBuffers(leftBuffer, rightBuffer, bufferIdx, endIndex, actMemo);
                    if (!actMemo.instrumentFinished) {
                        this.fillRampDataIntoBuffers(this.nvRampL, this.nvRampR, actMemo);
                    }
                }
                ++c;
            }
            int n = 0;
            while (n < 16) {
                int difFade = 16 - n;
                leftBuffer[bufferIdx + n] = leftBuffer[bufferIdx + n] * n + this.vRampL[n] * difFade >> 4;
                rightBuffer[bufferIdx + n] = rightBuffer[bufferIdx + n] * n + this.vRampR[n] * difFade >> 4;
                this.vRampL[n] = this.nvRampL[n];
                this.vRampR[n] = this.nvRampR[n];
                this.nvRampR[n] = 0;
                this.nvRampL[n] = 0;
                ++n;
            }
            bufferIdx += this.samplePerTicks;
            this.modFinished = this.doTickEvents();
            endIndex += this.samplePerTicks;
        }
        return bufferIdx;
    }

    protected class ChannelMemory {
        public PatternElement currentElement;
        public boolean muted = false;
        public int assignedNotePeriod = 0;
        public int currentNotePeriod = 0;
        public int currentFinetuneFrequency = 0;
        public int assignedNoteIndex;
        public int currentFineTune = 0;
        public int currentTranspose;
        public int currentVolume = 0;
        public int currentSetVolume = 0;
        public int channelVolume = 0;
        public int fadeOutVolume = 65536;
        public int panning = 128;
        public int actVolumeLeft;
        public int actVolumeRight;
        public int actRampVolLeft = 0;
        public int actRampVolRight = 0;
        public int deltaVolLeft = 0;
        public int deltaVolRight = 0;
        public int noteDelayCount = -1;
        public int noteCutCount = -1;
        public Instrument assignedInstrument;
        public int assignedInstrumentIndex;
        public Sample currentSample;
        public int currentTuning = 0;
        public int currentTuningPos = 0;
        public int currentSamplePos = 0;
        public int currentDirection = 0;
        public int volEnvPos = -1;
        public int panEnvPos = -1;
        public int pitchEnvPos = -1;
        public boolean instrumentFinished = true;
        public boolean keyOff = false;
        public int keyOffCounter = -1;
        public int effekt;
        public int effektParam;
        public int volumeEffekt;
        public int volumeEffektOp;
        public int channelVolumSlideValue = 0;
        public boolean glissando = false;
        public int arpegioIndex = -1;
        public int[] arpegioNote = new int[3];
        public int portaStepUp = 0;
        public int portaStepUpEnd = 0;
        public int portaStepDown = 0;
        public int portaStepDownEnd = 0;
        public int finePortaUp = 0;
        public int finePortaDown = 0;
        public int finePortaUpEx = 0;
        public int finePortaDownEx = 0;
        public int portaNoteStep = 0;
        public int portaTargetNotePeriod = 0;
        public int volumSlideValue = 0;
        public int panningSlideValue;
        public int vibratoTablePos = 0;
        public int vibratoStep = 0;
        public int vibratoAmplitude = 0;
        public int vibratoType = 0;
        public boolean vibratoOn = false;
        public boolean vibratoNoRetrig = false;
        public int autoVibratoTablePos = 0;
        public int autoVibratoAmplitude = 0;
        public int tremoloTablePos = 0;
        public int tremoloStep = 0;
        public int tremoloAmplitude = 0;
        public int tremoloType = 0;
        public boolean tremoloOn = false;
        public boolean tremoloNoRetrig = false;
        public int panbrelloTablePos = 0;
        public int panbrelloStep = 0;
        public int panbrelloAmplitude = 0;
        public int panbrelloType = 0;
        public boolean panbrelloOn = false;
        public boolean panbrelloNoRetrig = false;
        public int tremorCount = this.tremorOntime = this.tremorOfftime;
        public int tremorOntime;
        public int tremorOfftime;
        public int retrigCount = 0;
        public int retrigMemo = 0;
        public int retrigVolSlide = 0;
        public int sampleOffset = 0;
        public boolean doSurround = false;
        public boolean filterOn = false;
        public int nFilterMode = 0;
        public int nResonance = 0;
        public int nCutOff = 0;
        public int nCutSwing = 0;
        public int nResSwing = 0;
        public long nFilter_A0 = 0L;
        public long nFilter_B0 = 0L;
        public long nFilter_B1 = 0L;
        public long nFilter_HP = 0L;
        public long nFilter_Y1 = 0L;
        public long nFilter_Y2 = 0L;

        public void deepCopy(ChannelMemory fromMe) {
            try {
                Field[] fields = ChannelMemory.class.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    Field f = fields[i];
                    if (!Modifier.isFinal(f.getModifiers())) {
                        f.set(this, f.get(fromMe));
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

