/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.Envelope;
import de.quippy.javamod.multimedia.mod.loader.instrument.Instrument;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.Pattern;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.multimedia.mod.loader.tracker.ProTrackerMod;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.IOException;

public class XMMod
extends ProTrackerMod {
    private static final String[] MODFILEEXTENSION = new String[]{"xm"};
    private int version;
    private int headerSize;
    private int songRestart;
    private int flag;

    static {
        ModuleFactory.registerModule(new XMMod());
    }

    public XMMod() {
    }

    protected XMMod(String fileName) {
        super(fileName);
    }

    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    public int getFrequencyTable() {
        return (this.songFlags & 0x10) != 0 ? 8 : 4;
    }

    public int getSongRestart() {
        return this.songRestart;
    }

    private void setIntoPatternElement(PatternElement currentElement, ModfileInputStream inputStream) throws IOException {
        int volume;
        int flags;
        long pos = inputStream.getFilePointer();
        int lookahead = inputStream.readByteAsInt();
        inputStream.seek(pos);
        int n = flags = (lookahead & 0x80) != 0 ? inputStream.readByteAsInt() : 31;
        if ((flags & 1) != 0) {
            int period = 0;
            int noteIndex = inputStream.readByteAsInt();
            if (noteIndex == 97) {
                period = -1;
                noteIndex = -1;
            } else if (noteIndex != 0) {
                if (noteIndex < 97) {
                    noteIndex += 12;
                }
                period = Helpers.noteValues[(noteIndex -= 12) - 1];
            }
            currentElement.setNoteIndex(noteIndex);
            currentElement.setPeriod(period);
        }
        if ((flags & 2) != 0) {
            currentElement.setInstrument(inputStream.readByteAsInt());
        }
        if ((flags & 4) != 0 && (volume = inputStream.readByteAsInt()) != 0) {
            if (volume <= 80) {
                currentElement.setVolumeEffekt(1);
                currentElement.setVolumeEffektOp(volume - 16);
            } else {
                currentElement.setVolumeEffekt((volume >> 4) - 4);
                currentElement.setVolumeEffektOp(volume & 0xF);
            }
        }
        if ((flags & 8) != 0) {
            currentElement.setEffekt(inputStream.readByteAsInt());
        }
        if ((flags & 0x10) != 0) {
            currentElement.setEffektOp(inputStream.readByteAsInt());
        }
    }

    private boolean isXMMod(String kennung) {
        if (kennung.equals("Extended Module: ")) {
            return true;
        }
        return kennung.toLowerCase().equals("extended module: ");
    }

    public boolean checkLoadingPossible(ModfileInputStream inputStream) throws IOException {
        String xmID = inputStream.readString(17);
        inputStream.seek(0L);
        return this.isXMMod(xmID);
    }

    protected Module getNewInstance(String fileName) {
        return new XMMod(fileName);
    }

    public void loadModFileInternal(ModfileInputStream inputStream) throws IOException {
        this.setModType(2);
        this.setBaseVolume(128);
        this.setModID(inputStream.readString(17));
        if (!this.isXMMod(this.getModID())) {
            throw new IOException("Unsupported XM Module!");
        }
        this.setSongName(inputStream.readString(20));
        inputStream.skip(1L);
        this.setTrackerName(inputStream.readString(20));
        this.version = inputStream.readIntelWord();
        if (this.version < 260) {
            Log.info("XM-Version is below 0x0104... ");
        }
        long LSEEK = inputStream.getFilePointer();
        this.headerSize = inputStream.readIntelDWord();
        this.setSongLength(inputStream.readIntelWord());
        this.songRestart = inputStream.readIntelWord();
        this.setNChannels(inputStream.readIntelWord());
        this.setNPattern(inputStream.readIntelWord());
        this.setNInstruments(inputStream.readIntelWord());
        this.flag = inputStream.readIntelWord();
        if ((this.flag & 1) != 0) {
            this.songFlags |= 0x10;
        }
        if ((this.flag & 0x1000) != 0) {
            this.songFlags |= 0x8000;
        }
        this.setTempo(inputStream.readIntelWord());
        this.setBPMSpeed(inputStream.readIntelWord());
        int illegalPatternNum = 0;
        this.allocArrangement(256);
        int i = 0;
        while (i < 256) {
            this.getArrangement()[i - illegalPatternNum] = inputStream.readByteAsInt();
            ++i;
        }
        inputStream.seek(LSEEK + (long)this.headerSize);
        PatternContainer patternContainer = new PatternContainer(this.getNPattern());
        int pattNum = 0;
        while (pattNum < this.getNPattern()) {
            LSEEK = inputStream.getFilePointer();
            int patternHeaderSize = inputStream.readIntelDWord();
            int packingType = inputStream.readByteAsInt();
            if (packingType != 0) {
                throw new IOException("Unknown pattern packing type: " + packingType);
            }
            int rows = inputStream.readIntelWord();
            int packedPatternDataSize = inputStream.readIntelWord();
            inputStream.seek(LSEEK + (long)patternHeaderSize);
            Pattern currentPattern = new Pattern(rows);
            if (packedPatternDataSize > 0) {
                int row = 0;
                while (row < rows) {
                    PatternRow currentRow = new PatternRow(this.getNChannels());
                    int channel = 0;
                    while (channel < this.getNChannels()) {
                        PatternElement currentElement = new PatternElement(pattNum, row, channel);
                        this.setIntoPatternElement(currentElement, inputStream);
                        currentRow.setPatternElement(channel, currentElement);
                        ++channel;
                    }
                    currentPattern.setPatternRow(row, currentRow);
                    ++row;
                }
            }
            patternContainer.setPattern(pattNum, currentPattern);
            ++pattNum;
        }
        this.setPatternContainer(patternContainer);
        InstrumentsContainer instrumentContainer = new InstrumentsContainer(this, this.getNInstruments(), 0);
        this.setInstrumentContainer(instrumentContainer);
        int sampleOffsetIndex = 0;
        int ins = 0;
        while (ins < this.getNInstruments()) {
            Sample current;
            int vibratoType = 0;
            int vibratoSweep = 0;
            int vibratoDepth = 0;
            int vibratoRate = 0;
            LSEEK = inputStream.getFilePointer();
            Instrument currentIns = new Instrument();
            int instrumentHeaderSize = inputStream.readIntelDWord();
            currentIns.setName(inputStream.readString(22));
            inputStream.readByteAsInt();
            int anzSamples = inputStream.readIntelWord();
            if (anzSamples > 0) {
                this.setNSamples(this.getNSamples() + anzSamples);
                inputStream.readIntelDWord();
                int[] sampleIndex = new int[96];
                int[] noteIndex = new int[96];
                int i2 = 0;
                while (i2 < 96) {
                    sampleIndex[i2] = inputStream.readByteAsInt() + sampleOffsetIndex + 1;
                    noteIndex[i2] = i2;
                    ++i2;
                }
                currentIns.setIndexArray(sampleIndex);
                currentIns.setNoteArray(noteIndex);
                int[] volumeEnvelopePosition = new int[12];
                int[] volumeEnvelopeValue = new int[12];
                int i3 = 0;
                while (i3 < 12) {
                    volumeEnvelopePosition[i3] = inputStream.readIntelWord();
                    volumeEnvelopeValue[i3] = inputStream.readIntelWord();
                    ++i3;
                }
                Envelope volumeEnvelope = new Envelope();
                volumeEnvelope.setPosition(volumeEnvelopePosition);
                volumeEnvelope.setValue(volumeEnvelopeValue);
                currentIns.setVolumeEnvelope(volumeEnvelope);
                int[] panningEnvelopePosition = new int[12];
                int[] panningEnvelopeValue = new int[12];
                int i4 = 0;
                while (i4 < 12) {
                    panningEnvelopePosition[i4] = inputStream.readIntelWord();
                    panningEnvelopeValue[i4] = inputStream.readIntelWord();
                    ++i4;
                }
                Envelope panningEnvelope = new Envelope();
                panningEnvelope.setPosition(panningEnvelopePosition);
                panningEnvelope.setValue(panningEnvelopeValue);
                currentIns.setPanningEnvelope(panningEnvelope);
                volumeEnvelope.setNPoints(inputStream.readByteAsInt());
                panningEnvelope.setNPoints(inputStream.readByteAsInt());
                volumeEnvelope.setSustainPoint(inputStream.readByteAsInt());
                volumeEnvelope.setLoopStartPoint(inputStream.readByteAsInt());
                volumeEnvelope.setLoopEndPoint(inputStream.readByteAsInt());
                panningEnvelope.setSustainPoint(inputStream.readByteAsInt());
                panningEnvelope.setLoopStartPoint(inputStream.readByteAsInt());
                panningEnvelope.setLoopEndPoint(inputStream.readByteAsInt());
                volumeEnvelope.setXMType(inputStream.readByteAsInt());
                panningEnvelope.setXMType(inputStream.readByteAsInt());
                vibratoType = inputStream.readByteAsInt();
                vibratoSweep = inputStream.readByteAsInt();
                vibratoDepth = inputStream.readByteAsInt();
                vibratoRate = inputStream.readByteAsInt();
                currentIns.setVolumeFadeOut(inputStream.readIntelWord());
                inputStream.skip(2L);
            }
            inputStream.seek(LSEEK + (long)instrumentHeaderSize);
            instrumentContainer.reallocSampleSpace(this.getNSamples());
            int samIndex = 0;
            while (samIndex < anzSamples) {
                current = new Sample();
                current.setVibratoType(vibratoType);
                current.setVibratoSweep(vibratoSweep);
                current.setVibratoDepth(vibratoDepth);
                current.setVibratoRate(vibratoRate);
                current.setLength(inputStream.readIntelDWord());
                int repeatStart = inputStream.readIntelDWord();
                int repeatLength = inputStream.readIntelDWord();
                int repeatStop = repeatStart + repeatLength;
                int vol = inputStream.readByteAsInt() & 0x7F;
                current.setVolume(vol > 64 ? 64 : vol);
                int fine = inputStream.readByteAsInt();
                fine = fine > 127 ? fine - 256 : fine;
                current.setFineTune(fine);
                current.setBaseFrequency(Helpers.it_fineTuneTable[(fine >> 4) + 8]);
                current.setFlags(inputStream.readByteAsInt());
                int loopType = 0;
                if ((current.flags & 3) != 0) {
                    loopType |= 1;
                }
                if ((current.flags & 2) == 2) {
                    loopType |= 4;
                }
                current.setLoopType(loopType);
                if ((current.flags & 0x10) != 0) {
                    current.length >>= 1;
                    repeatStart >>= 1;
                    repeatStop >>= 1;
                }
                current.setRepeatStart(repeatStart);
                current.setRepeatStop(repeatStop);
                current.setRepeatLength(repeatStop - repeatStart);
                current.setPanning(inputStream.readByteAsInt());
                int transpose = inputStream.readByteAsInt();
                current.setTranspose(transpose > 127 ? transpose - 256 : transpose);
                inputStream.skip(1L);
                current.setName(inputStream.readString(22));
                instrumentContainer.setSample(samIndex + sampleOffsetIndex, current);
                ++samIndex;
            }
            samIndex = 0;
            while (samIndex < anzSamples) {
                current = instrumentContainer.getSample(samIndex + sampleOffsetIndex);
                int flags = 2;
                if ((current.flags & 0x10) != 0) {
                    flags |= 4;
                }
                this.readSampleData(current, flags, inputStream);
                ++samIndex;
            }
            instrumentContainer.setInstrument(ins, currentIns);
            sampleOffsetIndex += anzSamples;
            ++ins;
        }
        this.cleanUpArrangement();
    }
}

