/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.multimedia.mod.mixer.ProTrackerMixer;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ProTrackerMod
extends Module {
    private static final String[] MODFILEEXTENSION = new String[]{"nst", "mod", "wow"};
    private boolean isAmigaLike;

    static {
        ModuleFactory.registerModule(new ProTrackerMod());
    }

    public ProTrackerMod() {
    }

    protected ProTrackerMod(String fileName) {
        super(fileName);
    }

    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    public BasicModMixer getModMixer(int sampleRate, int doISP, boolean doNoLoops) {
        return new ProTrackerMixer(this, sampleRate, doISP, doNoLoops);
    }

    public int getPanningValue(int channel) {
        if (channel % 3 != 0) {
            return 256;
        }
        return 0;
    }

    public int getChannelVolume(int channel) {
        return 64;
    }

    public int getFrequencyTable() {
        return this.isAmigaLike ? 2 : 4;
    }

    public boolean doFastSlides() {
        return false;
    }

    private String getModType(String kennung) {
        if (kennung.length() == 4) {
            this.setNSamples(31);
            if (kennung.equals("M.K.") || kennung.equals("M!K!") || kennung.equals("M&K!") || kennung.equals("N.T.")) {
                this.isAmigaLike = true;
                this.setNChannels(4);
                return "ProTracker";
            }
            if (kennung.startsWith("FLT")) {
                this.isAmigaLike = false;
                this.setNChannels(Integer.parseInt(Character.toString(kennung.charAt(3))));
                return "StarTrekker";
            }
            if (kennung.startsWith("TDZ")) {
                this.isAmigaLike = false;
                this.setNChannels(Integer.parseInt(Character.toString(kennung.charAt(3))));
                return "StarTrekker";
            }
            if (kennung.endsWith("CHN")) {
                this.isAmigaLike = false;
                this.setNChannels(Integer.parseInt(Character.toString(kennung.charAt(0))));
                return "StarTrekker";
            }
            if (kennung.equals("CD81") || kennung.equals("OKTA")) {
                this.isAmigaLike = false;
                this.setNChannels(8);
                return "Atari Oktalyzer";
            }
            String firstKennung = kennung.substring(0, 2);
            String lastKennung = kennung.substring(2, 4);
            if (lastKennung.equals("CH") || lastKennung.equals("CN")) {
                this.isAmigaLike = false;
                this.setNChannels(Integer.parseInt(firstKennung));
                return "TakeTracker";
            }
        }
        this.isAmigaLike = true;
        this.setNSamples(15);
        this.setNChannels(4);
        this.setModID("NONE");
        return "NoiseTracker";
    }

    private int calculatePatternCount(int fileSize) {
        int totalPatternBytes;
        int headerLen = 150;
        if (this.getNSamples() > 15) {
            headerLen += 4;
        }
        int sampleLen = 0;
        int i = 0;
        while (i < this.getNSamples()) {
            sampleLen = (int)((long)sampleLen + (30L + (long)this.getInstrumentContainer().getSample((int)i).length));
            ++i;
        }
        int spaceForPattern = fileSize - headerLen - sampleLen;
        int maxPatternNumber = 0;
        int i2 = 0;
        while (i2 < this.getSongLength()) {
            int patternNumber = this.getArrangement()[i2];
            if (patternNumber > maxPatternNumber && patternNumber < 128) {
                maxPatternNumber = this.getArrangement()[i2];
            }
            ++i2;
        }
        if (this.getModID().equals("M.K.") && (totalPatternBytes = ++maxPatternNumber * 2048) == spaceForPattern) {
            this.isAmigaLike = true;
            this.setNChannels(8);
            this.setTrackerName("Grave Composer");
        }
        int bytesPerPattern = 256 * this.getNChannels();
        this.setNPattern(spaceForPattern / bytesPerPattern);
        int bytesLeft = spaceForPattern % bytesPerPattern;
        if (bytesLeft > 0) {
            if (maxPatternNumber > this.getNPattern()) {
                bytesLeft -= bytesPerPattern;
                this.setNPattern(maxPatternNumber + 1);
            } else {
                bytesLeft += (this.getNPattern() - maxPatternNumber) * bytesPerPattern;
                this.setNPattern(maxPatternNumber);
            }
            return bytesLeft;
        }
        return 0;
    }

    private PatternElement createNewPatternElement(int pattNum, int row, int channel, int note) {
        PatternElement pe = new PatternElement(pattNum, row, channel);
        if (this.getNSamples() > 15) {
            pe.setInstrument(((note & 0xF0000000) >> 24 | (note & 0xF000) >> 12) & this.getNSamples());
            pe.setPeriod((note & 0xFFF0000) >> 16);
        } else {
            pe.setInstrument((note & 0xF000) >> 12 & this.getNSamples());
            pe.setPeriod((note & 0xFFFF0000) >> 16);
        }
        if (pe.getPeriod() > 0) {
            pe.setNoteIndex(Helpers.getNoteIndexForPeriod(pe.getPeriod()) + 1);
        }
        pe.setEffekt((note & 0xF00) >> 8);
        pe.setEffektOp(note & 0xFF);
        if (pe.getEffekt() == 12 && pe.getEffektOp() > 64) {
            pe.setEffektOp(64);
        }
        return pe;
    }

    public boolean checkLoadingPossible(ModfileInputStream inputStream) throws IOException {
        inputStream.seek(1080L);
        String modID = inputStream.readString(4);
        inputStream.seek(0L);
        return modID.equals("M.K.") || modID.equals("M!K!") || modID.equals("M&K!") || modID.equals("N.T.") || modID.startsWith("FLT") || modID.startsWith("TDZ") || modID.endsWith("CHN") || modID.equals("CD81") || modID.equals("OKTA") || modID.endsWith("CH") || modID.endsWith("CN");
    }

    protected Module getNewInstance(String fileName) {
        return new ProTrackerMod(fileName);
    }

    public void loadModFileInternal(ModfileInputStream inputStream) throws IOException {
        this.setModType(1);
        this.setBaseVolume(128);
        this.setBPMSpeed(125);
        this.setTempo(6);
        inputStream.seek(1080L);
        this.setModID(inputStream.readString(4));
        inputStream.seek(0L);
        this.setTrackerName(this.getModType(this.getModID()));
        this.setSongName(inputStream.readString(20));
        this.setNInstruments(this.getNSamples());
        InstrumentsContainer instrumentContainer = new InstrumentsContainer(this, 0, this.getNSamples());
        this.setInstrumentContainer(instrumentContainer);
        int i = 0;
        while (i < this.getNSamples()) {
            Sample current = new Sample();
            current.setName(inputStream.readString(22));
            current.setLength(inputStream.readMotorolaWord() << 1);
            int fine = inputStream.readByteAsInt() & 0xF;
            fine = fine > 7 ? fine - 16 : fine;
            current.setFineTune(fine << 4);
            current.setTranspose(0);
            current.setBaseFrequency(Helpers.it_fineTuneTable[fine + 8]);
            int vol = inputStream.readByteAsInt() & 0x7F;
            current.setVolume(vol > 64 ? 64 : vol);
            int repeatStart = inputStream.readMotorolaWord() << 1;
            int repeatLength = inputStream.readMotorolaWord() << 1;
            int repeatStop = repeatStart + repeatLength;
            if (current.length < 4) {
                current.length = 0;
            }
            if (current.length > 0) {
                if (repeatStart > current.length) {
                    repeatStart = current.length - 1;
                }
                if (repeatStop > current.length) {
                    repeatStop = current.length;
                }
                if (repeatStart >= repeatStop || repeatStop <= 8 || repeatStop - repeatStart <= 4) {
                    repeatStop = 0;
                    repeatStart = 0;
                    current.setLoopType(0);
                }
                if (repeatStart < repeatStop) {
                    current.setLoopType(1);
                }
            } else {
                current.setLoopType(0);
            }
            current.setRepeatStart(repeatStart);
            current.setRepeatStop(repeatStop);
            current.setRepeatLength(repeatStop - repeatStart);
            current.setPanning(-1);
            instrumentContainer.setSample(i, current);
            ++i;
        }
        this.setSongLength(inputStream.readByteAsInt());
        inputStream.skip(1L);
        this.allocArrangement(128);
        i = 0;
        while (i < 128) {
            this.getArrangement()[i] = inputStream.readByteAsInt();
            ++i;
        }
        if (this.getNSamples() > 15) {
            inputStream.skip(4L);
        }
        int bytesLeft = this.calculatePatternCount((int)inputStream.getLength());
        PatternContainer patternContainer = new PatternContainer(this.getNPattern(), 64, this.getNChannels());
        this.setPatternContainer(patternContainer);
        int pattNum = 0;
        while (pattNum < this.getNPattern()) {
            int value;
            int channel;
            int row;
            if (this.getModID().equals("FLT8")) {
                row = 0;
                while (row < 64) {
                    channel = 0;
                    while (channel < 4) {
                        value = inputStream.readMotorolaDWord();
                        patternContainer.setPatternElement(this.createNewPatternElement(pattNum, row, channel, value));
                        ++channel;
                    }
                    ++row;
                }
                row = 0;
                while (row < 64) {
                    channel = 4;
                    while (channel < 8) {
                        value = inputStream.readMotorolaDWord();
                        patternContainer.setPatternElement(this.createNewPatternElement(pattNum, row, channel, value));
                        ++channel;
                    }
                    ++row;
                }
            } else {
                row = 0;
                while (row < 64) {
                    channel = 0;
                    while (channel < this.getNChannels()) {
                        value = inputStream.readMotorolaDWord();
                        patternContainer.setPatternElement(this.createNewPatternElement(pattNum, row, channel, value));
                        ++channel;
                    }
                    ++row;
                }
            }
            ++pattNum;
        }
        if (bytesLeft < 0) {
            int calcSamplePos = this.getInstrumentContainer().getFullSampleLength();
            calcSamplePos = (int)inputStream.getLength() - calcSamplePos;
            if ((long)calcSamplePos < inputStream.getFilePointer()) {
                inputStream.seek(calcSamplePos);
            }
        }
        int i2 = 0;
        while (i2 < this.getNSamples()) {
            Sample current = this.getInstrumentContainer().getSample(i2);
            this.readSampleData(current, 0, inputStream);
            ++i2;
        }
        this.cleanUpArrangement();
    }
}

