/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.pattern;

import de.quippy.javamod.system.Helpers;

public class PatternElement {
    private int patternIndex;
    private int row;
    private int channel;
    private int period;
    private int noteIndex;
    private int instrument;
    private int effekt;
    private int effektOp;
    private int volumeEffekt;
    private int volumeEffektOp;

    public PatternElement(int patternIndex, int patternRow, int channel) {
        this.patternIndex = patternIndex;
        this.row = patternRow;
        this.channel = channel;
        this.period = 0;
        this.noteIndex = 0;
        this.instrument = 0;
        this.volumeEffekt = 0;
        this.volumeEffektOp = 0;
        this.effekt = 0;
        this.effektOp = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Helpers.getNoteNameToPeriod(this.noteIndex));
        if (this.period == 0 && this.noteIndex != 0 || this.period != 0 && this.noteIndex == 0) {
            sb.append('!');
        } else {
            sb.append(' ');
        }
        if (this.instrument != 0) {
            sb.append(Helpers.getAsHex(this.instrument, 2));
        } else {
            sb.append("..");
        }
        if (this.volumeEffekt != 0) {
            switch (this.volumeEffekt) {
                case 1: {
                    sb.append('v');
                    break;
                }
                case 2: {
                    sb.append('d');
                    break;
                }
                case 3: {
                    sb.append('c');
                    break;
                }
                case 4: {
                    sb.append('b');
                    break;
                }
                case 5: {
                    sb.append('a');
                    break;
                }
                case 6: {
                    sb.append('u');
                    break;
                }
                case 7: {
                    sb.append('h');
                    break;
                }
                case 8: {
                    sb.append('p');
                    break;
                }
                case 9: {
                    sb.append('l');
                    break;
                }
                case 10: {
                    sb.append('r');
                    break;
                }
                case 11: {
                    sb.append('g');
                }
            }
            sb.append(Helpers.getAsHex(this.volumeEffektOp, 2));
        } else {
            sb.append(" ..");
        }
        sb.append(' ');
        if (this.effekt != 0) {
            if (this.effekt < 15) {
                sb.append(Helpers.getAsHex(this.effekt, 1));
            } else {
                sb.append((char)(70 + this.effekt - 15));
            }
            sb.append(Helpers.getAsHex(this.effektOp, 2));
        } else {
            sb.append("...");
        }
        return sb.toString();
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public int getEffekt() {
        return this.effekt;
    }

    public void setEffekt(int effekt) {
        this.effekt = effekt;
    }

    public int getEffektOp() {
        return this.effektOp;
    }

    public void setEffektOp(int effektOp) {
        this.effektOp = effektOp;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setInstrument(int instrument) {
        this.instrument = instrument;
    }

    public int getNoteIndex() {
        return this.noteIndex;
    }

    public void setNoteIndex(int noteIndex) {
        this.noteIndex = noteIndex;
    }

    public int getPatternIndex() {
        return this.patternIndex;
    }

    public void setPatternIndex(int patternIndex) {
        this.patternIndex = patternIndex;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getVolumeEffekt() {
        return this.volumeEffekt;
    }

    public void setVolumeEffekt(int volumeEffekt) {
        this.volumeEffekt = volumeEffekt;
    }

    public int getVolumeEffektOp() {
        return this.volumeEffektOp;
    }

    public void setVolumeEffektOp(int volumeEffektOp) {
        this.volumeEffektOp = volumeEffektOp;
    }
}

