/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.pattern;

import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.system.Helpers;

public class Pattern {
    private PatternRow[] patternRow;

    public Pattern(int rows) {
        this.patternRow = new PatternRow[rows];
    }

    public Pattern(int rows, int channels) {
        this(rows);
        int i = 0;
        while (i < rows) {
            this.patternRow[i] = new PatternRow(channels);
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.patternRow.length) {
            sb.append(Helpers.getAsHex(i, 2)).append(": ").append(this.patternRow[i].toString()).append('\n');
            ++i;
        }
        return sb.toString();
    }

    public int getRowCount() {
        return this.patternRow.length;
    }

    public void resetRowsPlayed() {
        int i = 0;
        while (i < this.patternRow.length) {
            PatternRow row = this.patternRow[i];
            if (row != null) {
                row.resetRowPlayed();
            }
            ++i;
        }
    }

    public PatternRow[] getPatternRow() {
        return this.patternRow;
    }

    public PatternRow getPatternRow(int row) {
        return this.patternRow[row];
    }

    public PatternElement getPatternElement(int row, int channel) {
        return this.patternRow[row].getPatternElement(channel);
    }

    public void setPatternRow(PatternRow[] patternRow) {
        this.patternRow = patternRow;
    }

    public void setPatternRow(int row, PatternRow patternRow) {
        this.patternRow[row] = patternRow;
    }

    public void setPatternElement(int row, int channel, PatternElement patternElement) {
        this.patternRow[row].setPatternElement(channel, patternElement);
    }
}

