/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleFactory {
    private static HashMap<String, Module> fileExtensionMap;
    private static ArrayList<Module> modulesArray;

    private ModuleFactory() {
    }

    private static HashMap<String, Module> getFileExtensionMap() {
        if (fileExtensionMap == null) {
            fileExtensionMap = new HashMap();
        }
        return fileExtensionMap;
    }

    private static ArrayList<Module> getModulesArray() {
        if (modulesArray == null) {
            modulesArray = new ArrayList();
        }
        return modulesArray;
    }

    public static void registerModule(Module mod) {
        ModuleFactory.getModulesArray().add(mod);
        String[] extensions = mod.getFileExtensionList();
        int i = 0;
        while (i < extensions.length) {
            ModuleFactory.getFileExtensionMap().put(extensions[i], mod);
            ++i;
        }
    }

    public static void deregisterModule(Module mod) {
        ModuleFactory.getModulesArray().remove(mod);
        String[] extensions = mod.getFileExtensionList();
        int i = 0;
        while (i < extensions.length) {
            ModuleFactory.getFileExtensionMap().remove(extensions[i]);
            ++i;
        }
    }

    public static String[] getSupportedFileExtensions() {
        Set<String> keys = ModuleFactory.getFileExtensionMap().keySet();
        String[] result = new String[keys.size()];
        return keys.toArray(result);
    }

    public static Module getModuleFromExtension(String extension) {
        return ModuleFactory.getFileExtensionMap().get(extension.toLowerCase());
    }

    private static Module getModuleFromStreamByID(ModfileInputStream input) {
        for (Module mod : ModuleFactory.getModulesArray()) {
            try {
                if (!mod.checkLoadingPossible(input)) continue;
                return mod;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Module getModuleFromStream(ModfileInputStream input) {
        for (Module mod : ModuleFactory.getModulesArray()) {
            try {
                Module result = mod.loadModFile(input);
                input.seek(0L);
                return result;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static Module getInstance(String fileName) throws IOException {
        return ModuleFactory.getInstance(new File(fileName));
    }

    public static Module getInstance(File file) throws IOException {
        return ModuleFactory.getInstance(file.toURI().toURL());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Module getInstance(URL url) throws IOException {
        ModfileInputStream inputStream = null;
        inputStream = new ModfileInputStream(url);
        Module mod = null;
        mod = ModuleFactory.getModuleFromStreamByID(inputStream);
        if (mod != null) {
            Module module = mod.loadModFile(inputStream);
            return module;
        }
        mod = ModuleFactory.getModuleFromStream(inputStream);
        if (mod == null) throw new IOException("Unsupported MOD-Type: " + inputStream.getFileName());
        Module module = mod;
        return module;
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

