/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import javax.sound.sampled.AudioFormat;

public class ModMixer
extends BasicMixer {
    private static final int TMPBUFFERLENGTH = 2048;
    private final Module mod;
    private final BasicModMixer modMixer;
    private int bufferSize;
    private int outputBufferSize;
    private int sampleSizeInBits;
    private int channels;
    private int sampleRate;
    private int doISP;
    private boolean doNoLoops;
    private boolean doWideStereoMix;
    private boolean doNoiseReduction;
    private boolean doMegaBass;
    private boolean isSeeking;
    private int[] LBuffer;
    private int[] RBuffer;
    private byte[] output;
    private int[] dspOutput;
    private long currentSamplesWritten;
    private int maxWideStereo;
    private int[] wideLBuffer;
    private int[] wideRBuffer;
    private int readPointer;
    private int writePointer;
    private int nLeftNR;
    private int nRightNR;
    private int nXBassSum;
    private int nXBassBufferPos;
    private int nXBassDlyPos;
    private int nXBassMask;
    private int nXBassDepth;
    private int[] XBassBuffer;
    private int[] XBassDelay;

    public ModMixer(Module mod, int sampleSizeInBits, int channels, int sampleRate, int doISP, boolean doWideStereoMix, boolean doNoiseReduction, boolean doMegaBass, boolean doNoLoops) {
        this.mod = mod;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.sampleRate = sampleRate;
        this.doWideStereoMix = channels < 2 ? false : doWideStereoMix;
        this.doNoiseReduction = doNoiseReduction;
        this.doMegaBass = doMegaBass;
        this.doISP = doISP;
        this.doNoLoops = doNoLoops;
        this.modMixer = this.mod.getModMixer(sampleRate, doISP, doNoLoops);
        this.isSeeking = false;
    }

    private void initialize() {
        this.closeAudioDevice();
        this.bufferSize = this.sampleRate >> 2;
        this.LBuffer = new int[this.bufferSize];
        this.RBuffer = new int[this.bufferSize];
        this.outputBufferSize = this.bufferSize * this.channels;
        this.dspOutput = new int[this.outputBufferSize];
        int bytesPerSample = this.sampleSizeInBits >> 3;
        this.outputBufferSize *= bytesPerSample;
        this.output = new byte[this.outputBufferSize];
        this.maxWideStereo = this.sampleRate / 50;
        this.wideLBuffer = new int[this.maxWideStereo];
        this.wideRBuffer = new int[this.maxWideStereo];
        this.readPointer = 0;
        this.writePointer = this.maxWideStereo - 1;
        this.initMegaBass();
        this.nLeftNR = 0;
        this.nRightNR = 0;
        this.setAudioFormat(new AudioFormat(this.sampleRate, this.sampleSizeInBits, this.channels, true, false));
    }

    private void initMegaBass() {
        int nXBassSamples = this.sampleRate * 14 / 10000;
        if (nXBassSamples > 64) {
            nXBassSamples = 64;
        }
        int mask = 2;
        while (mask <= nXBassSamples) {
            mask <<= 1;
        }
        this.XBassBuffer = new int[64];
        this.XBassDelay = new int[64];
        this.nXBassMask = (mask >> 1) - 1;
        this.nXBassSum = 0;
        this.nXBassBufferPos = 0;
        this.nXBassDlyPos = 0;
        this.nXBassDepth = 6;
    }

    public void setDoNoiseReduction(boolean doNoiseReduction) {
        this.doNoiseReduction = doNoiseReduction;
    }

    public void setDoWideStereoMix(boolean doWideStereoMix) {
        this.doWideStereoMix = doWideStereoMix;
    }

    public void setDoMegaBass(boolean doMegaBass) {
        this.doMegaBass = doMegaBass;
    }

    public void setDoNoLoops(boolean doNoLoops) {
        this.modMixer.changeDoNoLoops(doNoLoops);
    }

    public void setDoISP(int doISP) {
        this.modMixer.changeISP(doISP);
    }

    public void setSampleRate(int sampleRate) {
        boolean wasPlaying;
        int oldSampleRate = this.sampleRate;
        boolean bl = wasPlaying = !this.isPaused();
        if (wasPlaying) {
            this.pausePlayback();
        }
        this.sampleRate = sampleRate;
        this.modMixer.changeSampleRate(sampleRate);
        this.initialize();
        this.openAudioDevice();
        if (!this.isInitialized()) {
            this.sampleRate = oldSampleRate;
            this.modMixer.changeSampleRate(oldSampleRate);
            this.initialize();
            this.openAudioDevice();
        }
        if (wasPlaying) {
            this.pausePlayback();
        }
    }

    public void setSampleSizeInBits(int sampleSizeInBits) {
        boolean wasPlaying;
        int oldsampleSizeInBits = this.sampleSizeInBits;
        boolean bl = wasPlaying = !this.isPaused();
        if (wasPlaying) {
            this.pausePlayback();
        }
        this.sampleSizeInBits = sampleSizeInBits;
        this.initialize();
        this.openAudioDevice();
        if (!this.isInitialized()) {
            this.sampleSizeInBits = oldsampleSizeInBits;
            this.initialize();
            this.openAudioDevice();
        }
        if (wasPlaying) {
            this.pausePlayback();
        }
    }

    public void setChannels(int channels) {
        boolean wasPlaying;
        int oldChannels = this.channels;
        boolean bl = wasPlaying = !this.isPaused();
        if (wasPlaying) {
            this.pausePlayback();
        }
        this.channels = channels;
        this.initialize();
        this.openAudioDevice();
        if (!this.isInitialized()) {
            this.channels = oldChannels;
            this.initialize();
            this.openAudioDevice();
        }
        if (wasPlaying) {
            this.pausePlayback();
        }
    }

    public Module getMod() {
        return this.mod;
    }

    public BasicModMixer getModMixer() {
        return this.modMixer;
    }

    public boolean isSeekSupported() {
        return true;
    }

    public int getMillisecondPosition() {
        return (int)(this.currentSamplesWritten * 1000L / (long)this.sampleRate);
    }

    public void setMillisecondPosition(int milliseconds) {
        if (this.isSeeking) {
            return;
        }
        this.isSeeking = true;
        if (this.getMillisecondPosition() > milliseconds) {
            this.modMixer.initializeMixer();
            this.currentSamplesWritten = 0L;
        }
        int[] tmpLBuffer = new int[2048];
        int[] tmpRBuffer = new int[2048];
        this.modMixer.changeSampleRate(1000);
        this.modMixer.changeISP(0);
        while (this.getMillisecondPosition() < milliseconds) {
            int sampleCount = this.modMixer.mixIntoBuffer(tmpLBuffer, tmpRBuffer, 2048);
            if (sampleCount <= 0) break;
            this.currentSamplesWritten += (long)(sampleCount * this.sampleRate / 1000);
        }
        this.modMixer.changeSampleRate(this.sampleRate);
        this.modMixer.changeISP(this.doISP);
        this.isSeeking = false;
    }

    public int getLengthInMilliseconds() {
        int[] tmpLBuffer = new int[2048];
        int[] tmpRBuffer = new int[2048];
        this.modMixer.changeSampleRate(1000);
        this.modMixer.changeISP(0);
        this.modMixer.changeDoNoLoops(true);
        int fullLength = 0;
        this.modMixer.setIsFastForward(true);
        while (fullLength < 3600000) {
            int sampleCount = this.modMixer.mixIntoBuffer(tmpLBuffer, tmpRBuffer, 2048);
            if (sampleCount <= 0) break;
            fullLength += sampleCount;
        }
        this.modMixer.setIsFastForward(false);
        this.modMixer.changeSampleRate(this.sampleRate);
        this.modMixer.changeISP(this.doISP);
        this.modMixer.changeDoNoLoops(this.doNoLoops);
        this.modMixer.initializeMixer();
        return fullLength;
    }

    public int getChannelCount() {
        if (this.modMixer != null) {
            return this.modMixer.getCurrentUsedChannels();
        }
        return 0;
    }

    public int getCurrentKBperSecond() {
        return this.getChannelCount() * this.sampleSizeInBits * this.sampleRate / 1000;
    }

    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    public void startPlayback() {
        this.initialize();
        this.currentSamplesWritten = 0L;
        this.setIsPlaying();
        int xba = this.nXBassDepth + 1;
        int xbamask = (1 << xba) - 1;
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                int count;
                do {
                    if ((count = this.modMixer.mixIntoBuffer(this.LBuffer, this.RBuffer, this.bufferSize)) > 0) {
                        int ox = 0;
                        int ix = 0;
                        int dspx = 0;
                        while (ix < count) {
                            int lsample = this.LBuffer[ix];
                            this.LBuffer[ix] = 0;
                            int rsample = this.RBuffer[ix];
                            this.RBuffer[ix] = 0;
                            ++ix;
                            if (this.doWideStereoMix) {
                                this.wideLBuffer[this.writePointer] = lsample;
                                this.wideRBuffer[this.writePointer++] = rsample;
                                if (this.writePointer >= this.maxWideStereo) {
                                    this.writePointer = 0;
                                }
                                rsample += this.wideLBuffer[this.readPointer] >> 1;
                                lsample += this.wideRBuffer[this.readPointer++] >> 1;
                                if (this.readPointer >= this.maxWideStereo) {
                                    this.readPointer = 0;
                                }
                            }
                            if (this.doMegaBass) {
                                int tmp;
                                this.nXBassSum -= this.XBassBuffer[this.nXBassBufferPos];
                                int tmp0 = lsample + rsample;
                                this.XBassBuffer[this.nXBassBufferPos] = tmp = tmp0 + (tmp0 >> 31 & xbamask) >> xba;
                                this.nXBassSum += tmp;
                                int v = this.XBassDelay[this.nXBassDlyPos];
                                this.XBassDelay[this.nXBassDlyPos] = lsample;
                                lsample = v + this.nXBassSum;
                                v = this.XBassDelay[this.nXBassDlyPos + 1];
                                this.XBassDelay[this.nXBassDlyPos + 1] = rsample;
                                rsample = v + this.nXBassSum;
                                this.nXBassDlyPos = this.nXBassDlyPos + 2 & this.nXBassMask;
                                this.nXBassBufferPos = this.nXBassBufferPos + 1 & this.nXBassMask;
                            }
                            if (this.doNoiseReduction) {
                                int vnr = lsample >> 1;
                                lsample = vnr + this.nLeftNR;
                                this.nLeftNR = vnr;
                                vnr = rsample >> 1;
                                rsample = vnr + this.nRightNR;
                                this.nRightNR = vnr;
                            }
                            if (lsample > 0x7FFFFF) {
                                lsample = 0x7FFFFF;
                            } else if (lsample < -8388608) {
                                lsample = -8388608;
                            }
                            if (rsample > 0x7FFFFF) {
                                rsample = 0x7FFFFF;
                            } else if (rsample < -8388608) {
                                rsample = -8388608;
                            }
                            if (this.channels == 2) {
                                this.dspOutput[dspx++] = lsample;
                                this.dspOutput[dspx++] = rsample;
                                switch (this.sampleSizeInBits) {
                                    case 24: {
                                        this.output[ox++] = (byte)lsample;
                                        this.output[ox++] = (byte)(lsample >> 8);
                                        this.output[ox++] = (byte)(lsample >> 16);
                                        this.output[ox++] = (byte)rsample;
                                        this.output[ox++] = (byte)(rsample >> 8);
                                        this.output[ox++] = (byte)(rsample >> 16);
                                        break;
                                    }
                                    case 16: {
                                        this.output[ox++] = (byte)(lsample >> 8);
                                        this.output[ox++] = (byte)(lsample >> 16);
                                        this.output[ox++] = (byte)(rsample >> 8);
                                        this.output[ox++] = (byte)(rsample >> 16);
                                        break;
                                    }
                                    default: {
                                        this.output[ox++] = (byte)(lsample >> 16);
                                        this.output[ox++] = (byte)(rsample >> 16);
                                        break;
                                    }
                                }
                                continue;
                            }
                            int sample = (lsample >> 1) + (rsample >> 1);
                            this.dspOutput[dspx++] = sample;
                            switch (this.sampleSizeInBits) {
                                case 24: {
                                    this.output[ox++] = (byte)sample;
                                    this.output[ox++] = (byte)(sample >> 8);
                                    this.output[ox++] = (byte)(sample >> 16);
                                    break;
                                }
                                case 16: {
                                    this.output[ox++] = (byte)(sample >> 8);
                                    this.output[ox++] = (byte)(sample >> 16);
                                    break;
                                }
                                default: {
                                    this.output[ox++] = (byte)(sample >> 16);
                                }
                            }
                        }
                        this.writeSampleDataToProcessor(this.dspOutput, 0, dspx);
                        this.writeSampleDataToLine(this.output, 0, ox);
                        this.currentSamplesWritten += (long)count;
                    }
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (this.isPausing()) {
                        this.setIsPaused();
                        while (this.isPaused()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    while (this.isSeeking) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (count != -1);
                if (count == -1) {
                    this.setHasFinished();
                }
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.closeAudioDevice();
            this.setIsStopped();
        }
    }
}

