/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mod.ModConfigPanel;
import de.quippy.javamod.multimedia.mod.ModInfoPanel;
import de.quippy.javamod.multimedia.mod.ModMixer;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.system.Log;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class ModContainer
extends MultimediaContainer {
    public static final String PROPERTY_PLAYER_BITSPERSAMPLE = "javamod.player.bitspersample";
    public static final String PROPERTY_PLAYER_STEREO = "javamod.player.stereo";
    public static final String PROPERTY_PLAYER_FREQUENCY = "javamod.player.frequency";
    public static final String PROPERTY_PLAYER_ISP = "javamod.player.ISP";
    public static final String PROPERTY_PLAYER_WIDESTEREOMIX = "javamod.player.widestereomix";
    public static final String PROPERTY_PLAYER_NOISEREDUCTION = "javamod.player.noisereduction";
    public static final String PROPERTY_PLAYER_MEGABASS = "javamod.player.megabass";
    public static final String PROPERTY_PLAYER_NOLOOPS = "javamod.player.noloops";
    public static final String DEFAULT_WIDESTEREOMIX = "false";
    public static final String DEFAULT_NOISEREDUCTION = "false";
    public static final String DEFAULT_MEGABASS = "false";
    public static final String DEFAULT_NOLOOPS = "false";
    public static final String DEFAULT_SAMPLERATE = "44100";
    public static final String DEFAULT_CHANNEL = "2";
    public static final String DEFAULT_BITSPERSAMPLE = "16";
    public static final String DEFAULT_INTERPOLATION_INDEX = "1";
    public static final String[] SAMPLERATE = new String[]{"8000", "11025", "22050", "44100", "48000", "96000"};
    public static final String[] CHANNELS = new String[]{"1", "2"};
    public static final String[] BITSPERSAMPLE = new String[]{"8", "16", "24"};
    public static final String[] INTERPOLATION = new String[]{"none", "linear", "cubic spline", "windowed FIR"};
    private Module currentMod;
    private ModMixer currentMixer;
    private ModInfoPanel modInfoPanel;
    private ModConfigPanel modConfigPanel;

    static {
        MultimediaContainerManager.registerContainer(new ModContainer());
    }

    public MultimediaContainer getInstance(URL url) {
        MultimediaContainer result = super.getInstance(url);
        try {
            this.currentMod = ModuleFactory.getInstance(url);
            if (this.currentMod == null) {
                Log.error("This modfile is corrupt!", new Exception("This modfile is corrupt!"));
                result = null;
            } else {
                ((ModInfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.currentMod);
            }
        }
        catch (Exception ex) {
            this.currentMod = null;
            throw new RuntimeException(ex);
        }
        return result;
    }

    public String getSongName() {
        if (this.currentMod != null) {
            return this.currentMod.getSongName();
        }
        return super.getSongName();
    }

    public boolean canExport() {
        return true;
    }

    public JPanel getInfoPanel() {
        if (this.modInfoPanel == null) {
            this.modInfoPanel = new ModInfoPanel();
        }
        return this.modInfoPanel;
    }

    public JPanel getConfigPanel() {
        if (this.modConfigPanel == null) {
            this.modConfigPanel = new ModConfigPanel();
            this.modConfigPanel.setParentContainer(this);
        }
        return this.modConfigPanel;
    }

    public String[] getFileExtensionList() {
        return ModuleFactory.getSupportedFileExtensions();
    }

    public String getName() {
        return "Mod-File";
    }

    public void configurationChanged(Properties props) {
        ModConfigPanel configPanel = (ModConfigPanel)this.getConfigPanel();
        configPanel.getPlayerSetUp_SampleRate().setSelectedItem(props.getProperty(PROPERTY_PLAYER_FREQUENCY, DEFAULT_SAMPLERATE));
        configPanel.getPlayerSetUp_BitsPerSample().setSelectedItem(props.getProperty(PROPERTY_PLAYER_BITSPERSAMPLE, DEFAULT_BITSPERSAMPLE));
        configPanel.getPlayerSetUp_Channels().setSelectedItem(props.getProperty(PROPERTY_PLAYER_STEREO, DEFAULT_CHANNEL));
        configPanel.getPlayerSetUp_Interpolation().setSelectedIndex(Integer.parseInt(props.getProperty(PROPERTY_PLAYER_ISP, DEFAULT_INTERPOLATION_INDEX)));
        configPanel.getPlayerSetUp_WideStereoMix().setSelected(Boolean.parseBoolean(props.getProperty(PROPERTY_PLAYER_WIDESTEREOMIX, "false")));
        configPanel.getPlayerSetUp_NoiseReduction().setSelected(Boolean.parseBoolean(props.getProperty(PROPERTY_PLAYER_NOISEREDUCTION, "false")));
        configPanel.getPlayerSetUp_MegaBass().setSelected(Boolean.parseBoolean(props.getProperty(PROPERTY_PLAYER_MEGABASS, "false")));
        configPanel.getPlayerSetUp_NoLoops().setSelected(Boolean.parseBoolean(props.getProperty(PROPERTY_PLAYER_NOLOOPS, "false")));
    }

    public void configurationSave(Properties props) {
        ModConfigPanel configPanel = (ModConfigPanel)this.getConfigPanel();
        props.setProperty(PROPERTY_PLAYER_FREQUENCY, configPanel.getPlayerSetUp_SampleRate().getSelectedItem().toString());
        props.setProperty(PROPERTY_PLAYER_BITSPERSAMPLE, configPanel.getPlayerSetUp_BitsPerSample().getSelectedItem().toString());
        props.setProperty(PROPERTY_PLAYER_STEREO, configPanel.getPlayerSetUp_Channels().getSelectedItem().toString());
        props.setProperty(PROPERTY_PLAYER_ISP, Integer.toString(configPanel.getPlayerSetUp_Interpolation().getSelectedIndex()));
        props.setProperty(PROPERTY_PLAYER_WIDESTEREOMIX, Boolean.toString(configPanel.getPlayerSetUp_WideStereoMix().isSelected()));
        props.setProperty(PROPERTY_PLAYER_NOISEREDUCTION, Boolean.toString(configPanel.getPlayerSetUp_NoiseReduction().isSelected()));
        props.setProperty(PROPERTY_PLAYER_MEGABASS, Boolean.toString(configPanel.getPlayerSetUp_MegaBass().isSelected()));
        props.setProperty(PROPERTY_PLAYER_NOLOOPS, Boolean.toString(configPanel.getPlayerSetUp_NoLoops().isSelected()));
    }

    public Mixer createNewMixer() {
        if (this.currentMod == null) {
            return null;
        }
        Properties props = new Properties();
        this.configurationSave(props);
        int frequency = Integer.parseInt(props.getProperty(PROPERTY_PLAYER_FREQUENCY, DEFAULT_SAMPLERATE));
        int bitsPerSample = Integer.parseInt(props.getProperty(PROPERTY_PLAYER_BITSPERSAMPLE, DEFAULT_BITSPERSAMPLE));
        int channels = Integer.parseInt(props.getProperty(PROPERTY_PLAYER_STEREO, DEFAULT_CHANNEL));
        int isp = Integer.parseInt(props.getProperty(PROPERTY_PLAYER_ISP, DEFAULT_INTERPOLATION_INDEX));
        boolean wideStereoMix = Boolean.parseBoolean(props.getProperty(PROPERTY_PLAYER_WIDESTEREOMIX, "false"));
        boolean noiseReduction = Boolean.parseBoolean(props.getProperty(PROPERTY_PLAYER_NOISEREDUCTION, "false"));
        boolean megaBass = Boolean.parseBoolean(props.getProperty(PROPERTY_PLAYER_MEGABASS, "false"));
        boolean noLoops = Boolean.parseBoolean(props.getProperty(PROPERTY_PLAYER_NOLOOPS, "false"));
        this.currentMixer = new ModMixer(this.currentMod, bitsPerSample, channels, frequency, isp, wideStereoMix, noiseReduction, megaBass, noLoops);
        return this.currentMixer;
    }

    public ModMixer getCurrentMixer() {
        return this.currentMixer;
    }

    public Module getCurrentMod() {
        return this.currentMod;
    }
}

