/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.midi;

import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.File;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class MidiMixer
extends BasicMixer {
    private boolean capture;
    private Mixer.Info mixerInfo;
    private Line.Info inputPortInfo;
    private int bufferSize;
    private int[] dspOutput;
    private byte[] output;
    private int sampleSizeInBits;
    private int sampleSizeInBytes;
    private int channels;
    private int sampleRate;
    private boolean isBigEndian;
    private boolean isSigned;
    private TargetDataLine targetDataLine;
    private Sequence sequence;
    private Sequencer sequencer = null;
    private MidiDevice midiOutput = null;
    private MidiDevice.Info outputDeviceInfo;
    private File soundBankFile;

    public MidiMixer(Sequence sequence, MidiDevice.Info outputDeviceInfo, File soundBankFile, boolean capture, Mixer.Info mixerInfo, Line.Info inputPortInfo) {
        this.outputDeviceInfo = outputDeviceInfo;
        this.soundBankFile = soundBankFile;
        this.sequence = sequence;
        this.capture = capture;
        this.mixerInfo = mixerInfo;
        this.inputPortInfo = inputPortInfo;
        this.targetDataLine = null;
        if (capture) {
            this.setAudioFormat(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false));
            this.channels = this.getAudioFormat().getChannels();
            this.sampleSizeInBits = this.getAudioFormat().getSampleSizeInBits();
            this.sampleSizeInBytes = this.sampleSizeInBits >> 3;
            this.sampleRate = (int)this.getAudioFormat().getSampleRate();
            this.isBigEndian = this.getAudioFormat().isBigEndian();
            this.isSigned = this.getAudioFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
            this.bufferSize = 250 * this.channels * this.sampleSizeInBytes * this.sampleRate / 1000;
            this.dspOutput = new int[this.bufferSize];
            this.bufferSize *= this.sampleSizeInBytes;
            this.output = new byte[this.bufferSize];
        }
    }

    private void initialize() {
        if (this.capture) {
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.getAudioFormat());
            try {
                if (this.mixerInfo != null) {
                    Mixer mixer = AudioSystem.getMixer(this.mixerInfo);
                    this.targetDataLine = (TargetDataLine)mixer.getLine(info);
                } else {
                    this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                }
                this.targetDataLine.open();
            }
            catch (LineUnavailableException ex) {
                this.targetDataLine = null;
            }
            try {
                Mixer portMixer = Helpers.getPortMixer();
                Line inputPort = portMixer.getLine(this.inputPortInfo);
                inputPort.open();
                Control[] controles = inputPort.getControls();
                int i = 0;
                while (i < controles.length) {
                    if (controles[i] instanceof CompoundControl) {
                        Control[] children = ((CompoundControl)controles[i]).getMemberControls();
                        int j = 0;
                        while (j < children.length) {
                            if (children[i] instanceof BooleanControl && children[i].getType().getClass().getName().endsWith("BCT")) {
                                ((BooleanControl)children[i]).setValue(true);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (LineUnavailableException ex) {
                Log.error("[MidiMixer]", ex);
            }
        }
    }

    public boolean isSeekSupported() {
        return true;
    }

    public int getMillisecondPosition() {
        if (this.sequencer != null) {
            return (int)(this.sequencer.getMicrosecondPosition() / 1000L);
        }
        return 0;
    }

    public void setMillisecondPosition(int milliseconds) {
        if (this.sequencer != null) {
            this.sequencer.setMicrosecondPosition((long)milliseconds * 1000L);
        }
    }

    public int getLengthInMilliseconds() {
        this.initialize();
        this.openAudioDevice();
        int result = this.sequencer != null ? (int)(this.sequencer.getMicrosecondLength() / 1000L) : 0;
        this.closeAudioDevice();
        return result;
    }

    public int getChannelCount() {
        Sequence sequence;
        if (this.sequencer != null && (sequence = this.sequencer.getSequence()) != null) {
            return sequence.getTracks().length;
        }
        return 0;
    }

    public int getCurrentKBperSecond() {
        return 0;
    }

    public int getCurrentSampleFrequency() {
        return 44;
    }

    public void setNewOutputDevice(MidiDevice.Info newDeviceInfo) {
        boolean isPlaying = this.isPlaying();
        if (isPlaying) {
            this.stopLine();
        }
        try {
            if (this.midiOutput != null) {
                this.midiOutput.close();
                this.midiOutput = null;
            }
            this.midiOutput = newDeviceInfo != null ? MidiSystem.getMidiDevice(this.outputDeviceInfo) : MidiSystem.getMidiDevice(newDeviceInfo);
            if (!this.midiOutput.isOpen()) {
                this.midiOutput.open();
            }
            if (this.midiOutput instanceof Synthesizer && this.soundBankFile != null && this.soundBankFile.length() != 0L) {
                try {
                    Soundbank bank = MidiSystem.getSoundbank(this.soundBankFile);
                    ((Synthesizer)this.midiOutput).loadAllInstruments(bank);
                }
                catch (Exception ex) {
                    Log.error("Error occured when opening soundfont bank", ex);
                }
            }
            Receiver synthReceiver = this.midiOutput.getReceiver();
            Transmitter seqTransmitter = this.sequencer.getTransmitter();
            seqTransmitter.setReceiver(synthReceiver);
            if (isPlaying) {
                this.startLine();
            }
        }
        catch (MidiUnavailableException ex) {
            this.closeAudioDevice();
            Log.error("Error occured when opening midi device", ex);
        }
    }

    protected void openAudioDevice() {
        if (this.capture) {
            this.setKeepSilent(true);
            super.openAudioDevice();
        } else {
            this.closeAudioDevice();
        }
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.addMetaEventListener(new MetaEventListener(){

                public void meta(MetaMessage event) {
                    if (event.getType() == 47) {
                        MidiMixer.this.stopPlayback();
                        MidiMixer.this.closeAudioDevice();
                        MidiMixer.this.setHasFinished();
                    }
                }
            });
            this.sequencer.setSequence(this.sequence);
            this.sequencer.open();
            if (!(this.sequencer instanceof Synthesizer)) {
                this.setNewOutputDevice(this.outputDeviceInfo);
            }
        }
        catch (Exception ex) {
            Log.error("[MidiMixer]", ex);
        }
    }

    protected void closeAudioDevice() {
        this.stopLine();
        if (this.midiOutput != null && this.midiOutput.isOpen()) {
            this.midiOutput.close();
        }
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.close();
        }
        this.midiOutput = null;
        this.sequencer = null;
        if (this.capture) {
            super.closeAudioDevice();
        }
    }

    protected void startLine() {
        if (this.targetDataLine != null) {
            this.targetDataLine.start();
        }
        if (this.sequencer != null) {
            this.sequencer.start();
        }
    }

    protected void stopLine() {
        if (this.sequencer != null) {
            this.sequencer.stop();
        }
        if (this.targetDataLine != null) {
            if (this.targetDataLine.isRunning()) {
                this.targetDataLine.drain();
            }
            this.targetDataLine.stop();
        }
    }

    protected boolean isInitialized() {
        if (this.capture && this.targetDataLine == null) {
            return false;
        }
        return this.sequencer != null;
    }

    public void startPlayback() {
        this.initialize();
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                this.startLine();
                this.setIsPlaying();
                long framePosition = 0L;
                do {
                    if (this.targetDataLine != null) {
                        int byteCount;
                        int amount = this.targetDataLine.available();
                        if (amount > this.bufferSize) {
                            amount = this.bufferSize;
                        }
                        if ((byteCount = this.targetDataLine.read(this.output, 0, amount)) > 0) {
                            Helpers.convertAnyToSigned24Bit(this.dspOutput, 0, this.output, 0, byteCount, this.channels, this.sampleSizeInBits, this.isBigEndian, this.isSigned);
                            this.writeSampleDataToProcessor(this.dspOutput, 0, byteCount / this.sampleSizeInBytes);
                            this.writeSampleDataToLine(this.output, 0, byteCount);
                            this.setInternatFramePosition(framePosition);
                            framePosition += (long)(byteCount / this.channels);
                        }
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.isStopping()) {
                        this.setIsStopped();
                    }
                    if (!this.isPausing()) continue;
                    this.setIsPaused();
                    while (this.isPaused()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (this.isPlaying());
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.setIsStopped();
        }
        this.closeAudioDevice();
    }
}

