/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.midi;

import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MidiInfoPanel
extends JPanel {
    private static final long serialVersionUID = -2853660365143541701L;
    private JLabel midiNameLabel = null;
    private JTextField midiName = null;
    private JLabel midiDurationLabel = null;
    private JTextField midiDuration = null;
    private JLabel midiInfoLabel = null;
    private JScrollPane scrollPane_midiInfo = null;
    private JTextArea midiInfo = null;

    public MidiInfoPanel() {
        this.initialize();
    }

    public MidiInfoPanel(LayoutManager layout) {
        super(layout);
        this.initialize();
    }

    public MidiInfoPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public MidiInfoPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    private void initialize() {
        this.setName("MidiInfoPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getMidiNameLabel(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getMidiName(), Helpers.getGridBagConstraint(1, 0, 1, 0, 2, 17, 1.0, 0.0));
        this.add((Component)this.getMidiDurationLabel(), Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getMidiDuration(), Helpers.getGridBagConstraint(1, 1, 1, 0, 2, 17, 1.0, 0.0));
        this.add((Component)this.getMidiInfoLabel(), Helpers.getGridBagConstraint(0, 2, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getScrollPane_MidiInfo(), Helpers.getGridBagConstraint(0, 3, 1, 0, 1, 17, 1.0, 1.0));
    }

    public JLabel getMidiNameLabel() {
        if (this.midiNameLabel == null) {
            this.midiNameLabel = new JLabel("Midi file name:");
            this.midiNameLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.midiNameLabel;
    }

    public JLabel getMidiDurationLabel() {
        if (this.midiDurationLabel == null) {
            this.midiDurationLabel = new JLabel("Duration:");
            this.midiDurationLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.midiDurationLabel;
    }

    public JTextField getMidiName() {
        if (this.midiName == null) {
            this.midiName = new JTextField();
            this.midiName.setEditable(false);
            this.midiName.setFont(Helpers.DIALOG_FONT);
        }
        return this.midiName;
    }

    public JTextField getMidiDuration() {
        if (this.midiDuration == null) {
            this.midiDuration = new JTextField();
            this.midiDuration.setEditable(false);
            this.midiDuration.setHorizontalAlignment(10);
            this.midiDuration.setFont(Helpers.DIALOG_FONT);
            this.midiDuration.setColumns(5);
        }
        return this.midiDuration;
    }

    public JLabel getMidiInfoLabel() {
        if (this.midiInfoLabel == null) {
            this.midiInfoLabel = new JLabel();
            this.midiInfoLabel.setName("midiInfoLabel");
            this.midiInfoLabel.setText("Midi information in File");
            this.midiInfoLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.midiInfoLabel;
    }

    private JScrollPane getScrollPane_MidiInfo() {
        if (this.scrollPane_midiInfo == null) {
            this.scrollPane_midiInfo = new JScrollPane();
            this.scrollPane_midiInfo.setName("scrollPane_midiInfo");
            this.scrollPane_midiInfo.setViewportView(this.getMidiInfo());
        }
        return this.scrollPane_midiInfo;
    }

    public JTextArea getMidiInfo() {
        if (this.midiInfo == null) {
            this.midiInfo = new JTextArea();
            this.midiInfo.setName("midiInfo");
            this.midiInfo.setEditable(false);
            this.midiInfo.setFont(Helpers.DIALOG_FONT);
        }
        return this.midiInfo;
    }

    public void fillInfoPanelWith(Sequence currentSequence, String songName) {
        int seconds = (int)(currentSequence.getMicrosecondLength() / 1000000L);
        int min = seconds / 60;
        int sec = seconds % 60;
        String minStr = Integer.toString(min);
        if (min < 10) {
            minStr = "  " + minStr;
        }
        String secStr = Integer.toString(sec);
        if (sec < 10) {
            secStr = "0" + secStr;
        }
        this.getMidiDuration().setText(String.valueOf(minStr) + ":" + secStr);
        this.getMidiName().setText(songName);
        Track[] tracks = currentSequence.getTracks();
        StringBuilder fullText = new StringBuilder();
        int t = 0;
        while (t < tracks.length) {
            int size = tracks[t].size();
            int ticks = 0;
            while (ticks < size) {
                int type;
                MidiEvent event = tracks[t].get(ticks);
                MidiMessage message = event.getMessage();
                if (message instanceof MetaMessage && (type = ((MetaMessage)message).getType()) <= 4) {
                    fullText.append(new String(((MetaMessage)message).getData())).append('\n');
                }
                ++ticks;
            }
            ++t;
        }
        this.getMidiInfo().setText(fullText.toString());
        this.getMidiInfo().setSelectionStart(0);
        this.getMidiInfo().setSelectionEnd(0);
    }
}

