/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.midi;

import de.quippy.javamod.io.wav.RMIFile;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.midi.MidiConfigPanel;
import de.quippy.javamod.multimedia.midi.MidiInfoPanel;
import de.quippy.javamod.multimedia.midi.MidiMixer;
import de.quippy.javamod.system.Helpers;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JPanel;

public class MidiContainer
extends MultimediaContainer {
    private static final String[] MIDIFILEEXTENSION = new String[]{"mid", "rmf", "rmi"};
    public static final String PROPERTY_MIDIPLAYER_OUTPUTDEVICE = "javamod.player.midi.outputdevice";
    public static final String PROPERTY_MIDIPLAYER_SOUNDBANK = "javamod.player.midi.soundbankurl";
    public static final String PROPERTY_MIDIPLAYER_CAPTURE = "javamod.player.midi.capture";
    public static final String PROPERTY_MIDIPLAYER_MIXERNAME = "javamod.player.midi.mixername";
    public static final String PROPERTY_MIDIPLAYER_PORTNAME = "javamod.player.midi.portname";
    public static final String DEFAULT_OUTPUTDEVICE = "Java Sound Synthesizer";
    public static final String DEFAULT_SOUNDBANKURL = "";
    public static final String DEFAULT_CAPUTRE = "0";
    public static final String DEFAULT_MIXERNAME = "";
    public static final String DEFAULT_PORTNAME = "";
    public static final MidiDevice.Info[] MIDIOUTDEVICEINFOS = MidiContainer.getMidiOutDevices();
    public static final Mixer.Info[] MIXERDEVICEINFOS = MidiContainer.getInputMixerNames();
    public static final Line.Info[] INPUTPORTINFOS = MidiContainer.getInputPortNames();
    private MidiConfigPanel midiConfigPanel;
    private JPanel midiInfoPanel;
    private MidiMixer currentMixer;
    private Sequence currentSequence;

    static {
        MultimediaContainerManager.registerContainer(new MidiContainer());
    }

    public MultimediaContainer getInstance(URL midiFileUrl) {
        MultimediaContainer result = super.getInstance(midiFileUrl);
        try {
            String fileName = midiFileUrl.getPath();
            String extension = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
            this.currentSequence = extension.equals("rmi") ? RMIFile.open(midiFileUrl) : MidiSystem.getSequence(midiFileUrl);
            ((MidiInfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.currentSequence, this.getSongName());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public String[] getFileExtensionList() {
        return MIDIFILEEXTENSION;
    }

    public String getName() {
        return "Midi-File";
    }

    public boolean canExport() {
        return ((MidiConfigPanel)this.getConfigPanel()).getCapture().isSelected();
    }

    public JPanel getConfigPanel() {
        if (this.midiConfigPanel == null) {
            this.midiConfigPanel = new MidiConfigPanel();
            this.midiConfigPanel.setParentContainer(this);
        }
        return this.midiConfigPanel;
    }

    public JPanel getInfoPanel() {
        if (this.midiInfoPanel == null) {
            this.midiInfoPanel = new MidiInfoPanel();
        }
        return this.midiInfoPanel;
    }

    private File getSoundBankFile() {
        String soundBankFile = ((MidiConfigPanel)this.getConfigPanel()).getMidiSoundBankURL().getText();
        return new File(soundBankFile);
    }

    public de.quippy.javamod.mixer.Mixer createNewMixer() {
        Line.Info inputPortInfo;
        MidiConfigPanel configPanel = (MidiConfigPanel)this.getConfigPanel();
        MidiDevice.Info info = MIDIOUTDEVICEINFOS[configPanel.getMidiOutputDevice().getSelectedIndex()];
        boolean capture = configPanel.getCapture().isSelected();
        int mixerIndex = configPanel.getMixerInputDevice().getSelectedIndex();
        Mixer.Info mixerInfo = mixerIndex != -1 ? MIXERDEVICEINFOS[mixerIndex] : null;
        int portIndex = configPanel.getMixerInputPort().getSelectedIndex();
        Line.Info info2 = inputPortInfo = portIndex != -1 ? INPUTPORTINFOS[portIndex] : null;
        if (capture && (mixerInfo == null || inputPortInfo == null)) {
            capture = false;
        }
        this.currentMixer = new MidiMixer(this.currentSequence, info, this.getSoundBankFile(), capture, mixerInfo, inputPortInfo);
        return this.currentMixer;
    }

    public void configurationChanged(Properties newProps) {
        Line.Info inputPortInfo;
        MidiConfigPanel configPanel = (MidiConfigPanel)this.getConfigPanel();
        configPanel.getMidiOutputDevice().setSelectedItem(MidiContainer.getMidiOutDevice(newProps.getProperty(PROPERTY_MIDIPLAYER_OUTPUTDEVICE, DEFAULT_OUTPUTDEVICE)));
        configPanel.getMidiSoundBankURL().setText(newProps.getProperty(PROPERTY_MIDIPLAYER_SOUNDBANK, ""));
        configPanel.getCapture().setSelected(new Boolean(newProps.getProperty(PROPERTY_MIDIPLAYER_CAPTURE, DEFAULT_CAPUTRE)));
        Mixer.Info mixerInfo = MidiContainer.getMixerInfo(newProps.getProperty(PROPERTY_MIDIPLAYER_MIXERNAME, ""));
        if (mixerInfo != null) {
            int i = 0;
            while (i < MIXERDEVICEINFOS.length) {
                if (MIXERDEVICEINFOS[i].toString().equals(mixerInfo.toString())) {
                    configPanel.getMixerInputDevice().setSelectedIndex(i);
                }
                ++i;
            }
        }
        if ((inputPortInfo = MidiContainer.getPortInfo(newProps.getProperty(PROPERTY_MIDIPLAYER_PORTNAME, ""))) != null) {
            int i = 0;
            while (i < INPUTPORTINFOS.length) {
                if (INPUTPORTINFOS[i].toString().equals(inputPortInfo.toString())) {
                    configPanel.getMixerInputPort().setSelectedIndex(i);
                }
                ++i;
            }
        }
    }

    public void configurationSave(Properties props) {
        Line.Info lineInfo;
        MidiConfigPanel configPanel = (MidiConfigPanel)this.getConfigPanel();
        MidiDevice.Info outputDevice = (MidiDevice.Info)configPanel.getMidiOutputDevice().getSelectedItem();
        if (outputDevice != null) {
            props.setProperty(PROPERTY_MIDIPLAYER_OUTPUTDEVICE, outputDevice.getName());
        }
        props.setProperty(PROPERTY_MIDIPLAYER_SOUNDBANK, configPanel.getMidiSoundBankURL().getText());
        props.setProperty(PROPERTY_MIDIPLAYER_CAPTURE, Boolean.toString(configPanel.getCapture().isSelected()));
        Mixer.Info mixerInfo = (Mixer.Info)configPanel.getMixerInputDevice().getSelectedItem();
        if (mixerInfo != null) {
            props.setProperty(PROPERTY_MIDIPLAYER_MIXERNAME, mixerInfo.getName());
        }
        if ((lineInfo = (Line.Info)configPanel.getMixerInputPort().getSelectedItem()) != null) {
            props.setProperty(PROPERTY_MIDIPLAYER_PORTNAME, lineInfo.toString());
        }
    }

    private static MidiDevice.Info[] getMidiOutDevices() {
        ArrayList<MidiDevice.Info> midiOuts = new ArrayList<MidiDevice.Info>();
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < infos.length) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
                if (device instanceof Synthesizer || device.getClass().getName().endsWith("MidiOutDevice")) {
                    midiOuts.add(infos[i]);
                }
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
            ++i;
        }
        MidiDevice.Info[] result = new MidiDevice.Info[midiOuts.size()];
        midiOuts.toArray(result);
        return result;
    }

    private static MidiDevice.Info getMidiOutDevice(String midiDeviceName) {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getName().equalsIgnoreCase(midiDeviceName)) {
                return infos[i];
            }
            ++i;
        }
        return null;
    }

    private static Mixer.Info[] getInputMixerNames() {
        ArrayList<Mixer.Info> mixers = new ArrayList<Mixer.Info>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        Line.Info lineInfo = new Line.Info(TargetDataLine.class);
        int i = 0;
        while (i < mixerInfos.length) {
            Mixer mixer = AudioSystem.getMixer(mixerInfos[i]);
            if (mixer.isLineSupported(lineInfo)) {
                mixers.add(mixerInfos[i]);
            }
            ++i;
        }
        Mixer.Info[] result = new Mixer.Info[mixers.size()];
        mixers.toArray(result);
        return result;
    }

    private static Mixer.Info getMixerInfo(String fromName) {
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < mixerInfos.length) {
            if (mixerInfos[i].getName().equalsIgnoreCase(fromName)) {
                return mixerInfos[i];
            }
            ++i;
        }
        return null;
    }

    private static Line.Info[] getInputPortNames() {
        Mixer mixer = Helpers.getPortMixer();
        if (mixer != null) {
            return mixer.getSourceLineInfo();
        }
        return null;
    }

    private static Line.Info getPortInfo(String fromName) {
        Mixer mixer = Helpers.getPortMixer();
        if (mixer != null) {
            Line.Info[] sourceLines = mixer.getSourceLineInfo();
            int i = 0;
            while (i < sourceLines.length) {
                if (sourceLines[i].toString().equalsIgnoreCase(fromName)) {
                    return sourceLines[i];
                }
                ++i;
            }
        }
        return null;
    }

    public MidiMixer getCurrentMixer() {
        return this.currentMixer;
    }
}

