/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.midi;

import de.quippy.javamod.main.gui.filechooser.FileChooserFilter;
import de.quippy.javamod.main.gui.filechooser.FileChooserResult;
import de.quippy.javamod.multimedia.midi.MidiContainer;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.sound.midi.MidiDevice;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class MidiConfigPanel
extends JPanel {
    private static final long serialVersionUID = -3555440476406286002L;
    private JLabel midiOutputDeviceLabel = null;
    private JComboBox midiOutputDevice = null;
    private JLabel midiSoundBankLabel = null;
    private JTextField midiSoundBankUrl = null;
    private JButton searchButton = null;
    private JCheckBox capture = null;
    private JLabel mixerInputDeviceLabel = null;
    private JComboBox mixerInputDevice = null;
    private JLabel mixerInputPortLabel = null;
    private JComboBox mixerInputPort = null;
    private MidiContainer parentContainer;

    public MidiConfigPanel() {
        this.initialize();
    }

    public MidiConfigPanel(LayoutManager layout) {
        super(layout);
        this.initialize();
    }

    public MidiConfigPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    public MidiConfigPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initialize();
    }

    public MidiContainer getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(MidiContainer parent) {
        this.parentContainer = parent;
    }

    private void initialize() {
        this.setName("MidiConfigPane");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getMidiOutputDeviceLabel(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getMidiSoundBankLabel(), Helpers.getGridBagConstraint(1, 0, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getMidiOutputDevice(), Helpers.getGridBagConstraint(0, 1, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getMidiSoundBankURL(), Helpers.getGridBagConstraint(1, 1, 1, 1, 2, 17, 1.0, 0.0));
        this.add((Component)this.getSearchButton(), Helpers.getGridBagConstraint(2, 1, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getCapture(), Helpers.getGridBagConstraint(0, 2, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getMixerInputDeviceLabel(), Helpers.getGridBagConstraint(1, 2, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getMixerInputPortLabel(), Helpers.getGridBagConstraint(2, 2, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getMixerInputDevice(), Helpers.getGridBagConstraint(1, 3, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getMixerInputPort(), Helpers.getGridBagConstraint(2, 3, 1, 0, 0, 17, 0.0, 0.0));
    }

    public JCheckBox getCapture() {
        if (this.capture == null) {
            this.capture = new JCheckBox("Capture Midi-Output");
            this.capture.setFont(Helpers.DIALOG_FONT);
        }
        return this.capture;
    }

    public JLabel getMidiOutputDeviceLabel() {
        if (this.midiOutputDeviceLabel == null) {
            this.midiOutputDeviceLabel = new JLabel("Midi Ouput Devices");
            this.midiOutputDeviceLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.midiOutputDeviceLabel;
    }

    public JLabel getMidiSoundBankLabel() {
        if (this.midiSoundBankLabel == null) {
            this.midiSoundBankLabel = new JLabel("soundbank file for default synthesizer");
            this.midiSoundBankLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.midiSoundBankLabel;
    }

    public JLabel getMixerInputDeviceLabel() {
        if (this.mixerInputDeviceLabel == null) {
            this.mixerInputDeviceLabel = new JLabel("Capture Devices");
            this.mixerInputDeviceLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.mixerInputDeviceLabel;
    }

    public JLabel getMixerInputPortLabel() {
        if (this.mixerInputPortLabel == null) {
            this.mixerInputPortLabel = new JLabel("Input Port");
            this.mixerInputPortLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.mixerInputPortLabel;
    }

    public JComboBox getMidiOutputDevice() {
        if (this.midiOutputDevice == null) {
            this.midiOutputDevice = new JComboBox();
            this.midiOutputDevice.setName("midiOutputDevice");
            DefaultComboBoxModel<MidiDevice.Info> theModel = new DefaultComboBoxModel<MidiDevice.Info>(MidiContainer.MIDIOUTDEVICEINFOS);
            this.midiOutputDevice.setModel(theModel);
            this.midiOutputDevice.setFont(Helpers.DIALOG_FONT);
            this.midiOutputDevice.setEnabled(true);
        }
        return this.midiOutputDevice;
    }

    public JTextField getMidiSoundBankURL() {
        if (this.midiSoundBankUrl == null) {
            this.midiSoundBankUrl = new JTextField();
            this.midiSoundBankUrl.setColumns(20);
            this.midiSoundBankUrl.setFont(Helpers.DIALOG_FONT);
        }
        return this.midiSoundBankUrl;
    }

    private void doSelectSoundbankFile() {
        FileFilter[] fileFilter = new FileFilter[]{new FileChooserFilter("gm", "Soundbank file")};
        FileChooserResult selectedFile = Helpers.selectFileNameFor(this, null, "Select soundbank file", fileFilter, 0);
        if (selectedFile != null) {
            File select = selectedFile.getSelectedFile();
            this.getMidiSoundBankURL().setText(select.toString());
        }
    }

    public JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new JButton();
            this.searchButton.setMnemonic('S');
            this.searchButton.setText("Search");
            this.searchButton.setFont(Helpers.DIALOG_FONT);
            this.searchButton.setToolTipText("Search a soundbank file for the default synthesizer");
            this.searchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MidiConfigPanel.this.doSelectSoundbankFile();
                }
            });
        }
        return this.searchButton;
    }

    public JComboBox getMixerInputDevice() {
        if (this.mixerInputDevice == null) {
            this.mixerInputDevice = new JComboBox();
            this.mixerInputDevice.setName("mixerInputDevice");
            DefaultComboBoxModel<Mixer.Info> theModel = new DefaultComboBoxModel<Mixer.Info>(MidiContainer.MIXERDEVICEINFOS);
            this.mixerInputDevice.setModel(theModel);
            this.mixerInputDevice.setFont(Helpers.DIALOG_FONT);
            this.mixerInputDevice.setEnabled(true);
        }
        return this.mixerInputDevice;
    }

    public JComboBox getMixerInputPort() {
        if (this.mixerInputPort == null) {
            this.mixerInputPort = new JComboBox();
            this.mixerInputPort.setName("mixerInputPort");
            DefaultComboBoxModel<Line.Info> theModel = new DefaultComboBoxModel<Line.Info>(MidiContainer.INPUTPORTINFOS);
            this.mixerInputPort.setModel(theModel);
            this.mixerInputPort.setFont(Helpers.DIALOG_FONT);
            this.mixerInputPort.setEnabled(true);
        }
        return this.mixerInputPort;
    }
}

