/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia;

import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEventListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.sound.sampled.UnsupportedAudioFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultimediaContainerManager {
    private static HashMap<String, MultimediaContainer> fileExtensionMap;
    private static ArrayList<MultimediaContainer> containerArray;
    private static Properties containerConfigs;

    private MultimediaContainerManager() {
    }

    private static HashMap<String, MultimediaContainer> getFileExtensionMap() {
        if (fileExtensionMap == null) {
            fileExtensionMap = new HashMap();
        }
        return fileExtensionMap;
    }

    private static ArrayList<MultimediaContainer> getContainerArray() {
        if (containerArray == null) {
            containerArray = new ArrayList();
        }
        return containerArray;
    }

    private static String getExtensionFrom(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
    }

    private static String getPreceedingExtensionFrom(String fileName) {
        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        int dot = (fileName = fileName.substring(fileName.lastIndexOf(47) + 1)).indexOf(46);
        if (dot > 0) {
            return fileName.substring(0, dot).toLowerCase();
        }
        return "";
    }

    public static Properties getContainerConfigs() {
        if (containerConfigs == null) {
            containerConfigs = new Properties();
        }
        return containerConfigs;
    }

    public static void getContainerConfigs(Properties intoProps) {
        MultimediaContainerManager.fireConfiggurationSave();
        Enumeration<Object> propertyEnum = MultimediaContainerManager.getContainerConfigs().keys();
        while (propertyEnum.hasMoreElements()) {
            Object key = propertyEnum.nextElement();
            Object value = MultimediaContainerManager.getContainerConfigs().get(key);
            intoProps.put(key, value);
        }
    }

    public static void configureContainer(Properties fromProps) {
        Enumeration<Object> propertyEnum = fromProps.keys();
        while (propertyEnum.hasMoreElements()) {
            Object key = propertyEnum.nextElement();
            Object value = fromProps.get(key);
            MultimediaContainerManager.getContainerConfigs().put(key, value);
        }
        MultimediaContainerManager.fireConfiggurationChanged();
    }

    private static void fireConfiggurationChanged() {
        ArrayList<MultimediaContainer> listeners = MultimediaContainerManager.getContainerArray();
        int i = 0;
        while (i < listeners.size()) {
            listeners.get(i).configurationChanged(MultimediaContainerManager.getContainerConfigs());
            ++i;
        }
    }

    private static void fireConfiggurationSave() {
        ArrayList<MultimediaContainer> listeners = MultimediaContainerManager.getContainerArray();
        int i = 0;
        while (i < listeners.size()) {
            listeners.get(i).configurationSave(MultimediaContainerManager.getContainerConfigs());
            ++i;
        }
    }

    public static void registerContainer(MultimediaContainer container) {
        MultimediaContainerManager.getContainerArray().add(container);
        String[] extensions = container.getFileExtensionList();
        int i = 0;
        while (i < extensions.length) {
            MultimediaContainerManager.getFileExtensionMap().put(extensions[i], container);
            ++i;
        }
    }

    public static void deregisterContainer(MultimediaContainer container) {
        MultimediaContainerManager.getContainerArray().remove(container);
        String[] extensions = container.getFileExtensionList();
        int i = 0;
        while (i < extensions.length) {
            MultimediaContainerManager.getFileExtensionMap().remove(extensions[i]);
            ++i;
        }
    }

    public static void updateLookAndFeel() {
        ArrayList<MultimediaContainer> listeners = MultimediaContainerManager.getContainerArray();
        int i = 0;
        while (i < listeners.size()) {
            listeners.get(i).updateLookAndFeel();
            ++i;
        }
    }

    public static String[] getSupportedFileExtensions() {
        Set<String> keys = MultimediaContainerManager.getFileExtensionMap().keySet();
        String[] result = new String[keys.size()];
        return keys.toArray(result);
    }

    public static HashMap<String, String[]> getSupportedFileExtensionsPerContainer() {
        ArrayList<MultimediaContainer> listeners = MultimediaContainerManager.getContainerArray();
        HashMap<String, String[]> result = new HashMap<String, String[]>(listeners.size());
        int i = 0;
        while (i < listeners.size()) {
            result.put(listeners.get(i).getName(), listeners.get(i).getFileExtensionList());
            ++i;
        }
        return result;
    }

    public static MultimediaContainer getMultimediaContainerForType(String type) throws UnsupportedAudioFileException {
        MultimediaContainer container = MultimediaContainerManager.getFileExtensionMap().get(type.toLowerCase());
        if (container == null) {
            throw new UnsupportedAudioFileException(type);
        }
        return container;
    }

    public static MultimediaContainer getMultimediaContainer(URL url) throws UnsupportedAudioFileException {
        MultimediaContainer container;
        String fileName = url.getPath();
        MultimediaContainer baseContainer = MultimediaContainerManager.getFileExtensionMap().get(MultimediaContainerManager.getExtensionFrom(fileName));
        if (baseContainer == null) {
            baseContainer = MultimediaContainerManager.getFileExtensionMap().get(MultimediaContainerManager.getPreceedingExtensionFrom(fileName));
        }
        if (baseContainer == null) {
            if (url.getProtocol().equalsIgnoreCase("file")) {
                throw new UnsupportedAudioFileException(fileName);
            }
            baseContainer = MultimediaContainerManager.getFileExtensionMap().get("mp3");
        }
        if ((container = baseContainer.getInstance(url)) == null) {
            throw new UnsupportedAudioFileException(fileName);
        }
        return container;
    }

    public static MultimediaContainer getMultimediaContainer(URI uri) throws MalformedURLException, UnsupportedAudioFileException {
        return MultimediaContainerManager.getMultimediaContainer(uri.toURL());
    }

    public static MultimediaContainer getMultimediaContainer(File file) throws MalformedURLException, UnsupportedAudioFileException {
        return MultimediaContainerManager.getMultimediaContainer(file.toURI());
    }

    public static MultimediaContainer getMultimediaContainer(String fileName) throws MalformedURLException, UnsupportedAudioFileException {
        return MultimediaContainerManager.getMultimediaContainer(new File(fileName));
    }

    public static void addMultimediaContainerEventListener(MultimediaContainerEventListener listener) {
        ArrayList<MultimediaContainer> containers = MultimediaContainerManager.getContainerArray();
        int i = 0;
        while (i < containers.size()) {
            containers.get(i).addListener(listener);
            ++i;
        }
    }

    public static void removeMultimediaContainerEventListener(MultimediaContainerEventListener listener) {
        ArrayList<MultimediaContainer> containers = MultimediaContainerManager.getContainerArray();
        int i = 0;
        while (i < containers.size()) {
            containers.get(i).removeListener(listener);
            ++i;
        }
    }
}

