/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerEventListener;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class MultimediaContainer {
    private ArrayList<MultimediaContainerEventListener> listeners = new ArrayList();
    private URL fileURL;

    public MultimediaContainer getInstance(URL url) {
        this.fileURL = url;
        return this;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public void updateLookAndFeel() {
        SwingUtilities.updateComponentTreeUI(this.getInfoPanel());
        SwingUtilities.updateComponentTreeUI(this.getConfigPanel());
    }

    public void addListener(MultimediaContainerEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MultimediaContainerEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireMultimediaContainerEvent(MultimediaContainerEvent event) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).multimediaContainerEventOccured(event);
            ++i;
        }
    }

    public String getSongName() {
        String url;
        try {
            url = URLDecoder.decode(this.fileURL.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            url = this.fileURL.toString();
        }
        int lastSlash = url.lastIndexOf(47);
        return url.substring(lastSlash + 1);
    }

    public abstract boolean canExport();

    public abstract JPanel getInfoPanel();

    public abstract JPanel getConfigPanel();

    public abstract String[] getFileExtensionList();

    public abstract String getName();

    public abstract void configurationChanged(Properties var1);

    public abstract void configurationSave(Properties var1);

    public abstract Mixer createNewMixer();
}

