/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp;

public class FFT {
    private static final int FRAC_BITS = 16;
    private static final int FRAC_FAC = 65536;
    private final long[] xre;
    private final long[] xim;
    private final float[] mag;
    private final long[] fftSin;
    private final long[] fftCos;
    private final int[] fftBr;
    private final int ss;
    private final int ss2;
    private final int nu;

    public FFT(int pSampleSize) {
        this.ss = pSampleSize;
        this.ss2 = this.ss >> 1;
        this.nu = (int)(Math.log(this.ss) / Math.log(2.0));
        this.xre = new long[this.ss];
        this.xim = new long[this.ss];
        this.mag = new float[this.ss2];
        this.fftSin = new long[this.nu * this.ss2];
        this.fftCos = new long[this.nu * this.ss2];
        this.fftBr = new int[this.ss];
        this.prepareFFTTables();
    }

    /*
     * Unable to fully structure code
     */
    private void prepareFFTTables() {
        n2 = this.ss2;
        nu1 = this.nu - 1;
        k = 0;
        x = 0;
        l = 1;
        ** GOTO lbl24
        {
            i = 1;
            while (i <= n2) {
                p = FFT.bitrev(k >> nu1, this.nu);
                arg = 3.141592653589793 * p * 2.0 / (double)this.ss;
                this.fftSin[x] = (long)(Math.sin(arg) * 65536.0);
                this.fftCos[x] = (long)(Math.cos(arg) * 65536.0);
                ++k;
                ++x;
                ++i;
            }
            k += n2;
            do {
                if (k < this.ss) continue block0;
                k = 0;
                --nu1;
                n2 >>= 1;
                ++l;
lbl24:
                // 2 sources

            } while (l <= this.nu);
        }
        k = 0;
        while (k < this.ss) {
            this.fftBr[k] = FFT.bitrev(k, this.nu);
            ++k;
        }
    }

    private static long longSqrt(long value) {
        int scale = 8;
        int bits = 64;
        long sqrt = 0L;
        long rest = 0L;
        int i = 0;
        while (i < 8) {
            long i3;
            rest = rest << 8 | value >> (bits -= 8) & 0xFFL;
            long i2 = (sqrt << 5) + 1L;
            int k0 = 0;
            while ((i3 = rest - i2) >= 0L) {
                rest = i3;
                i2 += 2L;
                ++k0;
            }
            sqrt = (sqrt << 4) + (long)k0;
            ++i;
        }
        return sqrt;
    }

    private static int bitrev(int j, int nu) {
        int j1 = j;
        int k = 0;
        int i = 1;
        while (i <= nu) {
            int j2 = j1 >> 1;
            k = (k << 1) + j1 - (j2 << 1);
            j1 = j2;
            ++i;
        }
        return k;
    }

    public float[] calculate(float[] pSample) {
        int wAps = pSample.length / this.ss;
        int n2 = this.ss2;
        int nu1 = this.nu - 1;
        int a = 0;
        int b = 0;
        while (a < pSample.length) {
            this.xre[b] = (long)(pSample[a] * 65536.0f);
            this.xim[b] = 0L;
            a += wAps;
            ++b;
        }
        int x = 0;
        int l = 1;
        while (l <= this.nu) {
            int k = 0;
            while (k < this.ss) {
                int i = 1;
                while (i <= n2) {
                    long c = this.fftCos[x];
                    long s = this.fftSin[x];
                    int kn2 = k + n2;
                    long tr = this.xre[kn2] * c + this.xim[kn2] * s >> 16;
                    long ti = this.xim[kn2] * c - this.xre[kn2] * s >> 16;
                    this.xre[kn2] = this.xre[k] - tr;
                    this.xim[kn2] = this.xim[k] - ti;
                    int n = k;
                    this.xre[n] = this.xre[n] + tr;
                    int n3 = k++;
                    this.xim[n3] = this.xim[n3] + ti;
                    ++x;
                    ++i;
                }
                k += n2;
            }
            --nu1;
            n2 >>= 1;
            ++l;
        }
        int k = 0;
        while (k < this.ss) {
            int r = this.fftBr[k];
            if (r > k) {
                long tr = this.xre[k];
                long ti = this.xim[k];
                this.xre[k] = this.xre[r];
                this.xim[k] = this.xim[r];
                this.xre[r] = tr;
                this.xim[r] = ti;
            }
            ++k;
        }
        this.mag[0] = (float)(FFT.longSqrt(this.xre[0] * this.xre[0] + this.xim[0] * this.xim[0]) >> 16) / (float)this.ss;
        int i = 1;
        while (i < this.ss2) {
            this.mag[i] = (float)(FFT.longSqrt(this.xre[i] * this.xre[i] + this.xim[i] * this.xim[i]) << 1 >> 16) / (float)this.ss;
            ++i;
        }
        return this.mag;
    }
}

