/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp;

import de.quippy.javamod.mixer.dsp.DspProcessorCallBack;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;

public class AudioProcessor {
    private final Object lock = new Object();
    private final int desiredBufferSize;
    private final long waitForNanos;
    private final ArrayList<DspProcessorCallBack> callBacks;
    private SourceDataLine sourceDataLine;
    private volatile long internalFramePosition;
    private volatile boolean useInternalCounter;
    private int sampleBufferSize;
    private int[] sampleBuffer;
    private int channels;
    private int currentWritePosition;
    private ProcessorTask processorThread;

    public AudioProcessor(int desiredBufferSize, int desiredFPS) {
        this.desiredBufferSize = desiredBufferSize;
        this.waitForNanos = 1000000000L / (long)desiredFPS;
        this.callBacks = new ArrayList();
    }

    public AudioProcessor() {
        this(1024, 70);
    }

    public void addListener(DspProcessorCallBack callBack) {
        this.callBacks.add(callBack);
    }

    public void removeListener(DspProcessorCallBack callBack) {
        this.callBacks.remove(callBack);
    }

    public void setUseInternalCounter(boolean useInternalCounter) {
        this.useInternalCounter = useInternalCounter;
    }

    public void setInternalFramePosition(long internalFramePosition) {
        this.internalFramePosition = internalFramePosition;
    }

    public void initializeProcessor(SourceDataLine sourceDataLine) {
        this.sourceDataLine = sourceDataLine;
        AudioFormat audioFormat = sourceDataLine.getFormat();
        this.channels = audioFormat.getChannels();
        this.sampleBufferSize = sourceDataLine.getBufferSize();
        this.sampleBuffer = new int[this.sampleBufferSize];
        this.currentWritePosition = 0;
        this.internalFramePosition = 0L;
        this.useInternalCounter = false;
        this.processorThread = new ProcessorTask(this);
        this.processorThread.start();
    }

    public void stop() {
        if (this.processorThread != null) {
            this.processorThread.stopProcessorTask();
            while (this.processorThread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.processorThread = null;
            this.sampleBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSampleData(int[] newSampleData, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentWritePosition + length >= this.sampleBufferSize) {
                int rest = this.sampleBufferSize - this.currentWritePosition;
                System.arraycopy(newSampleData, offset, this.sampleBuffer, this.currentWritePosition, rest);
                this.currentWritePosition = length - rest;
                System.arraycopy(newSampleData, offset + rest, this.sampleBuffer, 0, this.currentWritePosition);
            } else {
                System.arraycopy(newSampleData, offset, this.sampleBuffer, this.currentWritePosition, length);
                this.currentWritePosition += length;
            }
        }
    }

    public void writeSampleData(int[] newSampleData) {
        this.writeSampleData(newSampleData, 0, newSampleData.length);
    }

    private final class ProcessorTask
    extends Thread {
        private final AudioProcessor me;
        private final int[] leftBuffer;
        private final int[] rightBuffer;
        private final long nanoWait;
        private volatile boolean process;

        public ProcessorTask(AudioProcessor parent) {
            this.me = parent;
            this.leftBuffer = new int[this.me.desiredBufferSize];
            this.rightBuffer = new int[this.me.desiredBufferSize];
            this.process = true;
            this.nanoWait = parent.waitForNanos;
            this.setDaemon(true);
            this.setName("AudioProcessor");
            this.setPriority(10);
        }

        public void stopProcessorTask() {
            this.process = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.process) {
                long now = System.nanoTime();
                Object object = AudioProcessor.this.lock;
                synchronized (object) {
                    int currentReadPosition = (int)((this.me.useInternalCounter ? this.me.internalFramePosition : this.me.sourceDataLine.getLongFramePosition()) * (long)this.me.channels % (long)this.me.sampleBufferSize);
                    int i = 0;
                    while (i < this.me.desiredBufferSize) {
                        if (currentReadPosition >= this.me.sampleBufferSize) {
                            currentReadPosition = 0;
                        }
                        if (this.me.channels == 2) {
                            this.leftBuffer[i] = this.me.sampleBuffer[currentReadPosition++];
                            this.rightBuffer[i] = this.me.sampleBuffer[currentReadPosition++];
                        } else {
                            this.leftBuffer[i] = this.rightBuffer[i] = this.me.sampleBuffer[currentReadPosition++];
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < this.me.callBacks.size()) {
                    ((DspProcessorCallBack)this.me.callBacks.get(i)).currentSampleChanged(this.leftBuffer, this.rightBuffer);
                    ++i;
                }
                long stillToWait = this.nanoWait - (System.nanoTime() - now);
                if (stillToWait > 0L) {
                    try {
                        Thread.sleep(stillToWait / 1000000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

