/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer;

import de.quippy.javamod.mixer.Mixer;

public abstract class BasicMixer
extends Mixer {
    private static final int ISNOTHING = 0;
    private static final int ISDOING = 1;
    private static final int ISDONE = 2;
    private int paused;
    private int stopped;
    private boolean hasFinished;

    public BasicMixer() {
        this.setIsStopped();
    }

    public boolean isPaused() {
        return this.paused == 2;
    }

    public boolean isPausing() {
        return this.paused == 1;
    }

    public boolean isStopped() {
        return this.stopped == 2;
    }

    public boolean isStopping() {
        return this.stopped == 1;
    }

    public boolean isNotPausingNorPaused() {
        return this.paused == 0;
    }

    public boolean isNotStoppingNorStopped() {
        return this.stopped == 0;
    }

    public boolean isPlaying() {
        return !this.isStopped();
    }

    public boolean hasFinished() {
        return this.hasFinished;
    }

    protected void setIsPausing() {
        this.paused = 1;
        this.stopped = 0;
    }

    protected void setIsPaused() {
        this.paused = 2;
        this.stopped = 0;
    }

    protected void setIsStopping() {
        this.paused = 0;
        this.stopped = 1;
    }

    protected void setIsStopped() {
        this.paused = 0;
        this.stopped = 2;
    }

    protected void setIsPlaying() {
        this.paused = 0;
        this.stopped = 0;
    }

    protected void setHasFinished() {
        this.hasFinished = true;
    }

    public void stopPlayback() {
        if (this.isNotStoppingNorStopped()) {
            this.setIsStopping();
            while (!this.isStopped()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.stopLine();
        }
    }

    public void pausePlayback() {
        if (this.isNotPausingNorPaused() && this.isNotStoppingNorStopped()) {
            this.setIsPausing();
            while (!this.isPaused() && !this.isStopped()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.stopLine();
        } else if (this.isPaused()) {
            this.startLine();
            this.setIsPlaying();
        }
    }
}

