/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.playlist;

import de.quippy.javamod.main.playlist.PlayListEntry;
import de.quippy.javamod.system.Log;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayList {
    private ArrayList<PlayListEntry> entries;
    private int current;
    private boolean shuffle;
    private int[] arrangement;

    public PlayList(boolean shuffle) {
        this.entries = new ArrayList();
        this.current = -1;
        this.shuffle = shuffle;
        this.setArrangement();
    }

    public PlayList(ArrayList<PlayListEntry> entries, boolean shuffle) {
        this.entries = entries;
        this.current = -1;
        this.shuffle = shuffle;
        this.setArrangement();
    }

    public PlayList(File[] files, boolean shuffle) {
        this.entries = new ArrayList(files.length);
        int i = 0;
        while (i < files.length) {
            this.entries.add(new PlayListEntry(files[i]));
            ++i;
        }
        this.current = -1;
        this.shuffle = shuffle;
        this.setArrangement();
    }

    public PlayList(String[] fileNames, boolean shuffle) {
        this.entries = new ArrayList(fileNames.length);
        int i = 0;
        while (i < fileNames.length) {
            this.entries.add(new PlayListEntry(fileNames[i]));
            ++i;
        }
        this.current = -1;
        this.shuffle = shuffle;
        this.setArrangement();
    }

    public void setShuffle(boolean shuffle) {
        boolean oShuffle = this.shuffle;
        this.shuffle = shuffle;
        if (oShuffle != shuffle) {
            this.setArrangement();
        }
    }

    private void setArrangement() {
        this.arrangement = new int[this.entries.size()];
        if (this.shuffle) {
            Random rnd = new Random(System.currentTimeMillis());
            boolean[] alreadyPicked = new boolean[this.entries.size()];
            int i = 0;
            while (i < this.arrangement.length) {
                int nextIndex;
                while (alreadyPicked[nextIndex = rnd.nextInt(this.arrangement.length)]) {
                }
                alreadyPicked[nextIndex] = true;
                this.arrangement[i] = nextIndex;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.arrangement.length) {
                this.arrangement[i] = i;
                ++i;
            }
        }
    }

    public PlayListEntry getCurrentEntry() {
        if (this.current < this.arrangement.length) {
            return this.entries.get(this.arrangement[this.current]);
        }
        return null;
    }

    public boolean next() {
        if (this.hasNext()) {
            ++this.current;
            return true;
        }
        return false;
    }

    public boolean previous() {
        if (this.hasPrevious()) {
            --this.current;
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        return this.current < this.arrangement.length - 1;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public void savePlayListTo(File f) throws IOException {
        if (f.exists()) {
            f.delete();
            f.createNewFile();
        }
        PrintStream ps = null;
        try {
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));
            int i = 0;
            while (i < this.entries.size()) {
                PlayListEntry entry = this.entries.get(i);
                URL aFile = entry.getFile();
                ps.println(aFile.toString());
                ++i;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void savePlayListTo(String fileName) throws IOException {
        this.savePlayListTo(new File(fileName));
    }

    private static URL createAbsolutePathForFile(URL baseURL, String fileName) {
        File entry = new File(fileName);
        try {
            if (!entry.isAbsolute()) {
                if (File.separatorChar != '/') {
                    fileName = fileName.replace(File.separatorChar, '/');
                }
                String path = baseURL.toURI().getPath();
                int lastSlash = path.lastIndexOf(47);
                path = path.substring(0, lastSlash + 1);
                if (fileName.startsWith("/")) {
                    fileName = fileName.substring(1);
                }
                int iterations = 0;
                while (!new File(String.valueOf(path) + fileName).exists() && iterations < 256) {
                    path = String.valueOf(path) + "../";
                    ++iterations;
                }
                if (iterations < 256) {
                    path = String.valueOf(path) + fileName;
                    try {
                        URI uri = new URI(baseURL.getProtocol(), null, path, null);
                        return uri.normalize().toURL();
                    }
                    catch (URISyntaxException x) {
                        Log.error("[createAbsolutePathForFile]", x);
                    }
                }
            }
            return entry.toURI().toURL();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static PlayList readPLSFile(URL playListURL, BufferedReader br, boolean shuffle) throws IOException {
        String line;
        ArrayList<PlayListEntry> entries = new ArrayList<PlayListEntry>();
        while ((line = br.readLine()) != null) {
            if (line.length() == 0 || !line.startsWith("File")) continue;
            int gleich = line.indexOf(61);
            line = line.substring(gleich + 1);
            try {
                URL url = new URL(line);
                entries.add(new PlayListEntry(url));
            }
            catch (MalformedURLException ex) {
                entries.add(new PlayListEntry(PlayList.createAbsolutePathForFile(playListURL, line)));
            }
        }
        if (entries.size() > 0) {
            return new PlayList(entries, shuffle);
        }
        return null;
    }

    private static PlayList readM3UFile(URL playListURL, BufferedReader br, boolean shuffle) throws IOException {
        String line;
        ArrayList<PlayListEntry> entries = new ArrayList<PlayListEntry>();
        while ((line = br.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            try {
                URL url = new URL(line);
                entries.add(new PlayListEntry(url));
            }
            catch (MalformedURLException ex) {
                entries.add(new PlayListEntry(PlayList.createAbsolutePathForFile(playListURL, line)));
            }
        }
        if (entries.size() > 0) {
            return new PlayList(entries, shuffle);
        }
        return null;
    }

    public static PlayList createFromFile(URL url, boolean shuffle) throws IOException {
        PlayList result;
        block6: {
            BufferedReader br = null;
            result = null;
            try {
                br = new BufferedReader(new InputStreamReader(url.openStream()));
                String line = br.readLine();
                if (line == null) break block6;
                if (line.equalsIgnoreCase("[playlist]")) {
                    result = PlayList.readPLSFile(url, br, shuffle);
                    break block6;
                }
                if (line.equalsIgnoreCase("#EXTM3U")) {
                    result = PlayList.readM3UFile(url, br, shuffle);
                    break block6;
                }
                throw new IllegalArgumentException("Unsupported Playlist File: " + url.toString());
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        return result;
    }

    public static PlayList createFromFile(File f, boolean shuffle) throws IOException {
        return PlayList.createFromFile(f.toURI().toURL(), shuffle);
    }

    public static PlayList createFromFile(String fileName, boolean shuffle) throws IOException {
        return PlayList.createFromFile(new File(fileName), shuffle);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int lastIndex = this.entries.size() - 1;
        int i = 0;
        while (i <= lastIndex) {
            result.append('[').append(this.entries.get(i)).append(']');
            if (i < lastIndex) {
                result.append(',');
            }
            ++i;
        }
        return result.toString();
    }
}

