/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.filechooser;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    private ArrayList<String> mExtensions = new ArrayList();
    private String mDescription;

    public FileChooserFilter() {
    }

    public FileChooserFilter(String extension, String description) {
        this();
        this.mExtensions.add(extension.toLowerCase());
        this.mDescription = description == null ? String.valueOf(extension) + " files" : description;
    }

    public FileChooserFilter(String extension) {
        this(extension, null);
    }

    public FileChooserFilter(String[] extensions, String description) {
        this();
        this.mDescription = description != null ? description : "";
        int i = 0;
        while (i < extensions.length) {
            String suffix = extensions[i].toLowerCase();
            if (description == null) {
                this.mDescription = String.valueOf(this.mDescription) + "*." + suffix + " ";
            }
            this.mExtensions.add(extensions[i].toLowerCase());
            ++i;
        }
    }

    public FileChooserFilter(String[] extensions) {
        this(extensions, null);
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        int len = this.mExtensions.size();
        if (len == 0) {
            return true;
        }
        int i = 0;
        while (i < len) {
            String suffix = this.mExtensions.get(i);
            if (f.getName().toLowerCase().endsWith(String.valueOf('.') + suffix)) {
                return true;
            }
            if (f.getName().toLowerCase().startsWith(String.valueOf(suffix) + '.')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDescription() {
        return this.mDescription;
    }
}

