/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.MeterPanelBase;
import java.awt.Color;
import java.awt.Graphics;

public final class VUMeterPanel
extends MeterPanelBase {
    private static final long serialVersionUID = -4587795218202329414L;
    private int maxPeakValue;
    private int currentLevel = 0;
    private int currentMaxPeakLevel = 0;
    private Color[] color;
    private Color[] colorLow;
    private int RampDownValue;
    private int maxPeakLevelRampDownValue;
    private int maxPeakLevelRampDownDelay;
    private int myAnzLines;

    public VUMeterPanel(int updateRate, int maxPeakValue) {
        super(updateRate);
        this.maxPeakValue = maxPeakValue;
        this.startThread();
    }

    protected synchronized void doThreadUpdate() {
        super.doThreadUpdate();
    }

    protected void componentWasResized(int newTop, int newLeft, int newWidth, int newHeight) {
        this.RampDownValue = (int)((float)this.maxPeakValue / ((float)newHeight * ((float)this.getDesiredFPS() / 200.0f)));
        this.maxPeakLevelRampDownDelay = this.RampDownValue / this.getDesiredFPS();
        this.maxPeakLevelRampDownValue = 0;
        this.myAnzLines = newHeight >> 1;
        this.color = new Color[this.myAnzLines];
        this.colorLow = new Color[this.myAnzLines];
        int i = 0;
        while (i < this.myAnzLines) {
            int color1 = i * 255 / this.myAnzLines;
            int color2 = 255 - color1;
            this.color[i] = new Color(color1, color2, 0);
            this.colorLow[i] = new Color(color1 >> 1, color2 >> 1, 0);
            ++i;
        }
    }

    public void setVUMeter(int[] samples) {
        this.setVUMeter(samples, samples.length);
    }

    public void setVUMeter(int[] samples, int length) {
        int newLevel = 0;
        int i = 0;
        while (i < length) {
            int v = samples[i];
            if (v < 0) {
                v *= -1;
            }
            if (v > newLevel) {
                newLevel = v;
            }
            ++i;
        }
        if (newLevel > this.currentLevel) {
            this.currentLevel = newLevel;
        }
    }

    public void setVUMeter(int newLevel) {
        if (newLevel < 0) {
            newLevel *= -1;
        }
        if (newLevel > this.currentLevel) {
            this.currentLevel = newLevel;
        }
    }

    protected void drawMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight) {
        this.currentLevel -= this.RampDownValue;
        if (this.currentLevel < 0) {
            this.currentLevel = 0;
        }
        this.currentMaxPeakLevel -= this.maxPeakLevelRampDownValue;
        if (this.currentMaxPeakLevel < 0) {
            this.currentMaxPeakLevel = 0;
        } else {
            this.maxPeakLevelRampDownValue += this.maxPeakLevelRampDownDelay;
        }
        if (this.currentLevel > this.currentMaxPeakLevel) {
            this.currentMaxPeakLevel = this.currentLevel;
            this.maxPeakLevelRampDownValue = this.maxPeakLevelRampDownDelay;
        }
        if (g == null) {
            return;
        }
        int level = this.myAnzLines * this.currentLevel / this.maxPeakValue - 1;
        int maxPeakLevel = this.myAnzLines * this.currentMaxPeakLevel / this.maxPeakValue - 1;
        int i = 0;
        while (i < this.myAnzLines) {
            g.setColor(i >= level && i != maxPeakLevel ? this.colorLow[i] : this.color[i]);
            int ly = newHeight - (i << 1);
            g.drawLine(0, ly, newWidth, ly);
            ++i;
        }
    }
}

