/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import javax.swing.JPanel;

public abstract class ThreadUpdatePanel
extends JPanel {
    private static final long serialVersionUID = 499420014207584726L;
    private volatile boolean threadRunning;
    private final int desiredFPS;
    private final MeterUpdateThread uiUpdateThread;
    private final long nanoWait;

    public ThreadUpdatePanel(int desiredFPS) {
        this.desiredFPS = desiredFPS;
        this.nanoWait = 1000000000L / (long)desiredFPS;
        this.uiUpdateThread = new MeterUpdateThread(this);
    }

    protected void startThread() {
        this.threadRunning = true;
        this.uiUpdateThread.start();
    }

    protected void stopThread() {
        this.threadRunning = false;
    }

    public int getDesiredFPS() {
        return this.desiredFPS;
    }

    protected abstract void doThreadUpdate();

    private final class MeterUpdateThread
    extends Thread {
        private final ThreadUpdatePanel me;

        public MeterUpdateThread(ThreadUpdatePanel me) {
            this.me = me;
            this.setName("ThreadUpdatePanel::" + this.getClass().getName());
            this.setDaemon(true);
            this.setPriority(10);
        }

        public void run() {
            while (this.me.threadRunning) {
                long now = System.nanoTime();
                this.me.doThreadUpdate();
                long stillToWait = ThreadUpdatePanel.this.nanoWait - (System.nanoTime() - now);
                if (stillToWait > 0L) {
                    try {
                        Thread.sleep(stillToWait / 1000000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

