/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.ThreadUpdatePanel;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public final class SeekBarPanel
extends ThreadUpdatePanel {
    private static final long serialVersionUID = -3570075762823459752L;
    private JTextField timeTextField = null;
    private JLabel timeLabel = null;
    private JTextField KBSField = null;
    private JLabel KBSLabel = null;
    private JTextField KHZField = null;
    private JLabel KHZLabel = null;
    private JTextField activeChannelsTextField = null;
    private JLabel activeChannelsLabel = null;
    private JProgressBar timeBar = null;
    private int maxLengthInMillis = 0;
    private int displayWhat = 0;
    private Mixer currentMixer;

    public SeekBarPanel(int desiredFPS) {
        super(desiredFPS);
        this.initialize();
        this.startThread();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTimeTextField(), Helpers.getGridBagConstraint(0, 0, 1, 1, 2, 17, 1.0, 0.0));
        this.add((Component)this.getTimeLabel(), Helpers.getGridBagConstraint(1, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getKBSField(), Helpers.getGridBagConstraint(2, 0, 1, 1, 2, 17, 1.0, 0.0));
        this.add((Component)this.getKBSLabel(), Helpers.getGridBagConstraint(3, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getKHZField(), Helpers.getGridBagConstraint(4, 0, 1, 1, 2, 17, 0.5, 0.0));
        this.add((Component)this.getKHZLabel(), Helpers.getGridBagConstraint(5, 0, 1, 1, 0, 17, 0.0, 0.0));
        this.add((Component)this.getActiveChannelsTextField(), Helpers.getGridBagConstraint(6, 0, 1, 1, 2, 17, 0.5, 0.0));
        this.add((Component)this.getActiveChannelsLabel(), Helpers.getGridBagConstraint(7, 0, 1, 0, 0, 17, 0.0, 0.0));
        this.add((Component)this.getTimeBar(), Helpers.getGridBagConstraint(0, 1, 1, 0, 2, 17, 1.0, 0.0));
    }

    private JTextField getTimeTextField() {
        if (this.timeTextField == null) {
            this.timeTextField = new JTextField("0:00", 5);
            this.timeTextField.setHorizontalAlignment(11);
            this.timeTextField.setEditable(false);
            this.timeTextField.setName("timeTextField");
            this.timeTextField.setFont(Helpers.DIALOG_FONT);
            this.timeTextField.setCursor(Cursor.getPredefinedCursor(12));
            this.timeTextField.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent pEvent) {
                    if (pEvent.getButton() == 1 && SeekBarPanel.this.currentMixer != null) {
                        SeekBarPanel.this.displayWhat = 1 - SeekBarPanel.this.displayWhat;
                    }
                }
            });
        }
        return this.timeTextField;
    }

    public JLabel getTimeLabel() {
        if (this.timeLabel == null) {
            this.timeLabel = new JLabel();
            this.timeLabel.setName("timeLabel");
            this.timeLabel.setText("time");
            this.timeLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.timeLabel;
    }

    public JTextField getKBSField() {
        if (this.KBSField == null) {
            this.KBSField = new JTextField("--", 4);
            this.KBSField.setHorizontalAlignment(11);
            this.KBSField.setEditable(false);
            this.KBSField.setName("KBSField");
            this.KBSField.setFont(Helpers.DIALOG_FONT);
        }
        return this.KBSField;
    }

    public JLabel getKBSLabel() {
        if (this.KBSLabel == null) {
            this.KBSLabel = new JLabel();
            this.KBSLabel.setName("KBSLabel");
            this.KBSLabel.setText("KB/s");
            this.KBSLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.KBSLabel;
    }

    public JTextField getKHZField() {
        if (this.KHZField == null) {
            this.KHZField = new JTextField("--", 2);
            this.KHZField.setHorizontalAlignment(11);
            this.KHZField.setEditable(false);
            this.KHZField.setName("KHZField");
            this.KHZField.setFont(Helpers.DIALOG_FONT);
        }
        return this.KHZField;
    }

    public JLabel getKHZLabel() {
        if (this.KHZLabel == null) {
            this.KHZLabel = new JLabel();
            this.KHZLabel.setName("KHZLabel");
            this.KHZLabel.setText("KHZ");
            this.KHZLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.KHZLabel;
    }

    public JTextField getActiveChannelsTextField() {
        if (this.activeChannelsTextField == null) {
            this.activeChannelsTextField = new JTextField("--", 3);
            this.activeChannelsTextField.setHorizontalAlignment(11);
            this.activeChannelsTextField.setEditable(false);
            this.activeChannelsTextField.setName("activeChannelsTextField");
            this.activeChannelsTextField.setFont(Helpers.DIALOG_FONT);
        }
        return this.activeChannelsTextField;
    }

    public JLabel getActiveChannelsLabel() {
        if (this.activeChannelsLabel == null) {
            this.activeChannelsLabel = new JLabel();
            this.activeChannelsLabel.setName("activeChannelsLabel");
            this.activeChannelsLabel.setText("Chn");
            this.activeChannelsLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.activeChannelsLabel;
    }

    private JProgressBar getTimeBar() {
        if (this.timeBar == null) {
            this.timeBar = new JProgressBar(0, 0);
            this.timeBar.setValue(0);
            this.timeBar.setCursor(Cursor.getPredefinedCursor(12));
            this.timeBar.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent pEvent) {
                    if (pEvent.getButton() == 1 && SeekBarPanel.this.currentMixer != null) {
                        Point p = pEvent.getPoint();
                        double x = p.getX();
                        int width = SeekBarPanel.this.timeBar.getWidth();
                        BoundedRangeModel model = SeekBarPanel.this.getTimeBar().getModel();
                        int timeCode = (int)((double)model.getMaximum() * x) / width;
                        SeekBarPanel.this.currentMixer.setMillisecondPosition(timeCode);
                    }
                }
            });
        }
        return this.timeBar;
    }

    public synchronized void setCurrentMixer(Mixer newMixer) {
        this.currentMixer = newMixer;
        this.getTimeBar().setValue(0);
        this.getTimeTextField().setText("0:00");
        this.getKBSField().setText("--");
        this.getKHZField().setText("--");
        this.getActiveChannelsTextField().setText("--");
        if (this.currentMixer != null) {
            BoundedRangeModel model = this.getTimeBar().getModel();
            this.maxLengthInMillis = this.currentMixer.getLengthInMilliseconds();
            model.setMaximum(this.maxLengthInMillis);
        }
    }

    protected synchronized void doThreadUpdate() {
        if (this.currentMixer != null) {
            long timeCode = this.currentMixer.getMillisecondPosition();
            this.getTimeBar().setValue((int)timeCode);
            if (this.displayWhat == 1) {
                timeCode = (long)this.maxLengthInMillis - timeCode;
            }
            int sec = (int)(timeCode / 1000L % 60L);
            int min = (int)(timeCode / 60000L);
            this.getTimeTextField().setText(String.valueOf(min < 10 ? "  " : "") + Integer.toString(min) + ':' + (sec < 10 ? "0" : "") + Integer.toString(sec));
            this.getKBSField().setText(Integer.toString(this.currentMixer.getCurrentKBperSecond()));
            this.getKHZField().setText(Integer.toString(this.currentMixer.getCurrentSampleFrequency()));
            this.getActiveChannelsTextField().setText(Integer.toString(this.currentMixer.getChannelCount()));
        }
    }
}

