/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.MeterPanelBase;
import de.quippy.javamod.mixer.dsp.FFT;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public final class SAMeterPanel
extends MeterPanelBase {
    private static final long serialVersionUID = 3032239961770238793L;
    private static final int FFT_SAMPLE_SIZE = 512;
    private FFT fftCalc;
    private Color[] color;
    private Color[] SKcolor;
    private int SKMax;
    private float[] fftLevels;
    private float[] maxFFTLevels;
    private int[] samples;
    private float[] floatSamples;
    private int anzSamples;
    private float maxPeakValue;
    private float[] maxPeakLevelRampDownValue;
    private int bands;
    private int multiplier;
    private float RampDownValue;
    private float maxPeakLevelRampDownDelay;
    private int myBottom;
    private int myHalfHeight;
    private int barWidth;
    private int drawWhat;
    private boolean switched;

    public SAMeterPanel(int bands, int updateRate, int maxPeakValue) {
        super(updateRate);
        this.bands = bands;
        this.fftCalc = new FFT(512);
        this.multiplier = 256 / bands;
        this.maxPeakValue = maxPeakValue;
        this.fftLevels = new float[this.bands];
        this.maxFFTLevels = new float[this.bands];
        this.maxPeakLevelRampDownValue = new float[this.bands];
        this.drawWhat = 0;
        this.switched = true;
        this.prepareDisplayToggleListener();
        this.startThread();
    }

    private void prepareDisplayToggleListener() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent pEvent) {
                if (pEvent.getButton() == 1) {
                    SAMeterPanel sAMeterPanel = SAMeterPanel.this;
                    sAMeterPanel.drawWhat = sAMeterPanel.drawWhat + 1;
                    if (SAMeterPanel.this.drawWhat > 2) {
                        SAMeterPanel.this.drawWhat = 0;
                    }
                    SAMeterPanel.this.switched = true;
                }
            }
        });
    }

    protected void componentWasResized(int newTop, int newLeft, int newWidth, int newHeight) {
        this.RampDownValue = 1.0f / ((float)newHeight * ((float)this.getDesiredFPS() / 50.0f));
        this.maxPeakLevelRampDownDelay = this.RampDownValue / (float)this.getDesiredFPS();
        if (newTop < 0 || newLeft < 0 || newWidth < 0 || newHeight < 0) {
            return;
        }
        this.myBottom = newTop + newHeight;
        this.myHalfHeight = newHeight >> 1;
        this.barWidth = newWidth / this.bands;
        this.color = new Color[newHeight + 1];
        int i = 0;
        while (i <= newHeight) {
            int color1 = i * 255 / newHeight;
            int color2 = 255 - color1;
            this.color[i] = new Color(color1, color2, 0);
            ++i;
        }
        this.SKMax = 768;
        this.SKcolor = new Color[this.SKMax];
        i = 0;
        while (i < 256) {
            this.SKcolor[i] = new Color(0, 0, i);
            ++i;
        }
        i = 256;
        while (i < 512) {
            this.SKcolor[i] = new Color(i - 256, 0, 511 - i);
            ++i;
        }
        i = 512;
        while (i < 768) {
            this.SKcolor[i] = new Color(255, i - 512, 0);
            ++i;
        }
    }

    public void setMeter(int[] newSamples) {
        if (newSamples != null) {
            this.anzSamples = newSamples.length;
            if (this.samples == null || this.samples.length != this.anzSamples) {
                this.samples = new int[this.anzSamples];
                this.floatSamples = new float[this.anzSamples];
            }
            System.arraycopy(newSamples, 0, this.samples, 0, this.anzSamples);
            int i = 0;
            while (i < this.anzSamples) {
                this.floatSamples[i] = (float)newSamples[i] / this.maxPeakValue;
                ++i;
            }
            float[] resultFFTSamples = this.fftCalc.calculate(this.floatSamples);
            int a = 0;
            int bd = 0;
            while (bd < this.bands) {
                float wFs = resultFFTSamples[a];
                int b = 1;
                while (b < this.multiplier) {
                    wFs += resultFFTSamples[a + b];
                    ++b;
                }
                if ((wFs *= (float)Math.log(bd + 2)) > 1.0f) {
                    wFs = 1.0f;
                }
                if (wFs > this.fftLevels[bd]) {
                    this.fftLevels[bd] = wFs;
                }
                a += this.multiplier;
                ++bd;
            }
        } else {
            this.samples = null;
            this.floatSamples = null;
        }
    }

    protected void drawMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight) {
        int i = 0;
        while (i < this.bands) {
            int n = i;
            this.fftLevels[n] = this.fftLevels[n] - this.RampDownValue;
            if (this.fftLevels[i] < 0.0f) {
                this.fftLevels[i] = 0.0f;
            }
            int n2 = i;
            this.maxFFTLevels[n2] = this.maxFFTLevels[n2] - this.maxPeakLevelRampDownValue[i];
            if (this.maxFFTLevels[i] < 0.0f) {
                this.maxFFTLevels[i] = 0.0f;
            } else {
                int n3 = i;
                this.maxPeakLevelRampDownValue[n3] = this.maxPeakLevelRampDownValue[n3] + this.maxPeakLevelRampDownDelay;
            }
            ++i;
        }
        if (g == null) {
            return;
        }
        switch (this.drawWhat) {
            default: {
                this.drawSAMeter(g, newTop, newLeft, newWidth, newHeight);
                break;
            }
            case 1: {
                this.drawWaveMeter(g, newTop, newLeft, newWidth, newHeight);
                break;
            }
            case 2: {
                this.drawSKMeter(g, newTop, newLeft, newWidth, newHeight);
            }
        }
    }

    private void drawWaveMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, newWidth, newHeight);
        g.setColor(Color.GREEN);
        g.drawLine(0, this.myHalfHeight, newWidth, this.myHalfHeight);
        if (this.samples == null) {
            return;
        }
        int add = this.anzSamples / newWidth >> 1;
        if (add <= 0) {
            add = 1;
        }
        int xpOld = 0;
        int ypOld = this.myHalfHeight - this.samples[0] * this.myHalfHeight / 0x7FFFFF;
        if (ypOld < 0) {
            ypOld = 0;
        } else if (ypOld > newHeight) {
            ypOld = newHeight;
        }
        if (this.samples != null && this.anzSamples > 0) {
            g.setColor(Color.WHITE);
            int i = add;
            while (i < this.anzSamples) {
                int xp = i * newWidth / this.anzSamples;
                if (xp < 0) {
                    xp = 0;
                } else if (xp > newWidth) {
                    xp = newWidth;
                }
                int yp = this.myHalfHeight - this.samples[i] * this.myHalfHeight / 0x7FFFFF;
                if (yp < 0) {
                    yp = 0;
                } else if (yp > newHeight) {
                    yp = newHeight;
                }
                g.drawLine(xpOld, ypOld, xp, yp);
                xpOld = xp;
                ypOld = yp;
                i += add;
            }
        }
    }

    private void drawSAMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, newWidth, newHeight);
        int i = 0;
        while (i < this.bands) {
            if (this.fftLevels[i] > this.maxFFTLevels[i]) {
                this.maxFFTLevels[i] = this.fftLevels[i];
                this.maxPeakLevelRampDownValue[i] = this.maxPeakLevelRampDownDelay;
            }
            int barX = i * this.barWidth;
            int barX1 = barX + this.barWidth - 2;
            int barHeight = (int)((float)newHeight * this.fftLevels[i]);
            int maxBarHeight = (int)((float)newHeight * this.maxFFTLevels[i]);
            int c = barHeight;
            int y = this.myBottom - barHeight;
            while (y < this.myBottom) {
                g.setColor(this.color[c--]);
                g.drawLine(barX, y, barX1, y);
                ++y;
            }
            if (maxBarHeight > barHeight) {
                g.setColor(this.color[maxBarHeight]);
                g.drawLine(barX, this.myBottom - maxBarHeight, barX1, this.myBottom - maxBarHeight);
            }
            ++i;
        }
    }

    private void drawSKMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight) {
        if (this.switched) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, newWidth, newHeight);
            this.switched = false;
        }
        g.copyArea(0, 0, newWidth - 1, newHeight, 1, 0);
        int max = this.bands - 1;
        int i = 0;
        while (i <= max) {
            int bary = newHeight * (max - i) / this.bands;
            g.setColor(this.SKcolor[(int)((float)this.SKMax * this.fftLevels[i])]);
            g.drawLine(0, bary, 0, bary + 2);
            ++i;
        }
    }
}

