/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RoundSlider
extends JComponent {
    private static final long serialVersionUID = 7401158894851891182L;
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static final double PI_2 = Math.PI * 2;
    private static final double START_ANG = 5.497787143782138;
    private static final double LENGTH_ANG = 4.71238898038469;
    private ChangeEvent changeEvent = null;
    private double lastAngle;
    private double currentAngle;
    private float currentValue;

    public RoundSlider() {
        this.initialize();
    }

    private void initialize() {
        this.setValue(0.0f);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                int height;
                int width = RoundSlider.this.getWidth();
                int middle = (width <= (height = RoundSlider.this.getHeight()) ? width : height) >> 1;
                int xpos = me.getX() - middle;
                int ypos = me.getY() - middle;
                RoundSlider.this.lastAngle = Math.atan2(xpos, ypos);
                if (xpos < 0) {
                    RoundSlider roundSlider = RoundSlider.this;
                    roundSlider.lastAngle = roundSlider.lastAngle + Math.PI * 2;
                }
                RoundSlider.this.requestFocus();
            }

            public void mouseClicked(MouseEvent me) {
                int height;
                int width = RoundSlider.this.getWidth();
                int middle = (width <= (height = RoundSlider.this.getHeight()) ? width : height) >> 1;
                int xpos = me.getX() - middle;
                int ypos = me.getY() - middle;
                double ang = Math.atan2(xpos, ypos);
                if (xpos < 0) {
                    ang += Math.PI * 2;
                }
                RoundSlider.this.setValue((float)((5.497787143782138 - ang) / 4.71238898038469));
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent me) {
                int height;
                int width = RoundSlider.this.getWidth();
                int middle = (width <= (height = RoundSlider.this.getHeight()) ? width : height) >> 1;
                int xpos = me.getX() - middle;
                int ypos = me.getY() - middle;
                double ang = Math.atan2(xpos, ypos);
                if (xpos < 0) {
                    ang += Math.PI * 2;
                }
                double diff = ang - RoundSlider.this.lastAngle;
                RoundSlider.this.lastAngle = ang;
                float newValue = (float)((double)RoundSlider.this.getValue() - diff / 4.71238898038469);
                if ((double)Math.abs(newValue - RoundSlider.this.getValue()) < 0.5) {
                    RoundSlider.this.setValue(newValue);
                }
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
    }

    public float getValue() {
        return this.currentValue;
    }

    public void setValue(float newVal) {
        this.currentValue = newVal < 0.0f ? 0.0f : (newVal > 1.0f ? 1.0f : newVal);
        this.currentAngle = 5.497787143782138 - 4.71238898038469 * (double)this.currentValue;
        this.repaint();
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener cl) {
        this.listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listenerList.remove(ChangeListener.class, cl);
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int size = Math.min(width, height);
        int middle = size >> 1;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setBackground(this.getParent().getBackground());
            g2d.addRenderingHints(AALIAS);
        }
        --middle;
        int startColor = 64;
        int colorStep = (255 - startColor) / (size -= 2);
        int i = size;
        while (i >= 0) {
            g.setColor(new Color(startColor, startColor, startColor));
            int x = 1 + middle - (i >> 1);
            g.fillOval(x, x, i, i);
            startColor += colorStep;
            --i;
        }
        g.setColor(Color.RED);
        int x = middle + (int)((double)middle * Math.sin(this.currentAngle));
        int y = middle + (int)((double)middle * Math.cos(this.currentAngle));
        g.drawLine(middle, middle, x, y);
        int dx = (int)(2.0 * Math.sin(this.currentAngle));
        int dy = (int)(2.0 * Math.cos(this.currentAngle));
        g.drawLine(middle + dx, middle + dy, x, y);
        g.drawLine(middle + dx, middle + dy, x, y);
    }
}

