/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.main.gui.components.MeterPanelBase;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;

public final class LEDScrollPanel
extends MeterPanelBase {
    private static final long serialVersionUID = 8634277922087324325L;
    private static HashMap<String, byte[]> ledCharSet = new HashMap();
    private String scrollText;
    private int brickWidth;
    private int brickHeight;
    private int anzChars;
    private int fullWidth;
    private int fullHeight;
    private int appendIndexMarker = -1;
    private int scrollTextIndex;
    private int scrollBufferIndex;
    private byte[][] currentScrollLayer;
    private Color darkColor;
    private Color lightColor;

    static {
        ledCharSet.put(" ", new byte[5]);
        ledCharSet.put("A", new byte[]{126, 9, 9, 9, 126});
        ledCharSet.put("a", new byte[]{32, 84, 84, 84, 120});
        ledCharSet.put("B", new byte[]{127, 73, 73, 73, 62});
        ledCharSet.put("b", new byte[]{127, 68, 68, 68, 56});
        ledCharSet.put("C", new byte[]{62, 65, 65, 65, 34});
        byte[] byArray = new byte[5];
        byArray[0] = 56;
        byArray[1] = 68;
        byArray[2] = 68;
        byArray[3] = 68;
        ledCharSet.put("c", byArray);
        ledCharSet.put("D", new byte[]{65, 127, 65, 65, 62});
        ledCharSet.put("d", new byte[]{56, 68, 68, 72, 127});
        ledCharSet.put("E", new byte[]{127, 73, 73, 65, 65});
        ledCharSet.put("e", new byte[]{56, 84, 84, 84, 24});
        ledCharSet.put("F", new byte[]{127, 9, 9, 1, 1});
        ledCharSet.put("f", new byte[]{8, 126, 9, 1, 2});
        ledCharSet.put("G", new byte[]{62, 65, 65, 73, 58});
        ledCharSet.put("g", new byte[]{72, 84, 84, 84, 60});
        ledCharSet.put("H", new byte[]{127, 8, 8, 8, 127});
        ledCharSet.put("h", new byte[]{127, 8, 4, 4, 120});
        byte[] byArray2 = new byte[5];
        byArray2[1] = 65;
        byArray2[2] = 127;
        byArray2[3] = 65;
        ledCharSet.put("I", byArray2);
        byte[] byArray3 = new byte[5];
        byArray3[1] = 68;
        byArray3[2] = 125;
        byArray3[3] = 64;
        ledCharSet.put("i", byArray3);
        ledCharSet.put("J", new byte[]{32, 64, 65, 63, 1});
        byte[] byArray4 = new byte[5];
        byArray4[0] = 32;
        byArray4[1] = 64;
        byArray4[2] = 68;
        byArray4[3] = 61;
        ledCharSet.put("j", byArray4);
        ledCharSet.put("K", new byte[]{127, 8, 20, 34, 65});
        byte[] byArray5 = new byte[5];
        byArray5[0] = 127;
        byArray5[1] = 16;
        byArray5[2] = 40;
        byArray5[3] = 68;
        ledCharSet.put("k", byArray5);
        ledCharSet.put("L", new byte[]{127, 64, 64, 64, 64});
        byte[] byArray6 = new byte[5];
        byArray6[1] = 65;
        byArray6[2] = 127;
        byArray6[3] = 64;
        ledCharSet.put("l", byArray6);
        ledCharSet.put("M", new byte[]{127, 2, 12, 2, 127});
        ledCharSet.put("m", new byte[]{124, 4, 24, 4, 120});
        ledCharSet.put("N", new byte[]{127, 4, 8, 16, 127});
        ledCharSet.put("n", new byte[]{124, 8, 4, 4, 120});
        ledCharSet.put("O", new byte[]{62, 65, 65, 65, 62});
        ledCharSet.put("o", new byte[]{56, 68, 68, 68, 56});
        ledCharSet.put("P", new byte[]{127, 9, 9, 9, 6});
        ledCharSet.put("p", new byte[]{124, 20, 20, 20, 8});
        ledCharSet.put("Q", new byte[]{62, 65, 81, 33, 94});
        ledCharSet.put("q", new byte[]{8, 20, 20, 20, 124});
        ledCharSet.put("R", new byte[]{127, 9, 25, 41, 70});
        ledCharSet.put("r", new byte[]{124, 8, 4, 4, 8});
        ledCharSet.put("S", new byte[]{38, 73, 73, 73, 50});
        ledCharSet.put("s", new byte[]{72, 84, 84, 84, 32});
        ledCharSet.put("T", new byte[]{1, 1, 127, 1, 1});
        ledCharSet.put("t", new byte[]{4, 63, 68, 64, 64});
        ledCharSet.put("U", new byte[]{63, 64, 64, 64, 63});
        ledCharSet.put("u", new byte[]{60, 64, 64, 32, 124});
        ledCharSet.put("V", new byte[]{7, 24, 96, 24, 7});
        ledCharSet.put("v", new byte[]{28, 32, 64, 32, 28});
        ledCharSet.put("W", new byte[]{127, 32, 24, 32, 127});
        ledCharSet.put("w", new byte[]{60, 64, 48, 64, 60});
        ledCharSet.put("X", new byte[]{99, 20, 8, 20, 99});
        ledCharSet.put("x", new byte[]{68, 40, 16, 40, 68});
        ledCharSet.put("Y", new byte[]{7, 8, 120, 8, 7});
        ledCharSet.put("y", new byte[]{12, 80, 80, 80, 60});
        ledCharSet.put("Z", new byte[]{97, 81, 73, 69, 67});
        ledCharSet.put("z", new byte[]{68, 100, 84, 76, 68});
        ledCharSet.put("0", new byte[]{62, 81, 73, 69, 62});
        byte[] byArray7 = new byte[5];
        byArray7[1] = 66;
        byArray7[2] = 127;
        byArray7[3] = 64;
        ledCharSet.put("1", byArray7);
        ledCharSet.put("2", new byte[]{98, 81, 81, 73, 70});
        ledCharSet.put("3", new byte[]{34, 65, 73, 73, 54});
        ledCharSet.put("4", new byte[]{24, 20, 18, 127, 16});
        ledCharSet.put("5", new byte[]{39, 69, 69, 69, 57});
        ledCharSet.put("6", new byte[]{60, 74, 73, 73, 49});
        ledCharSet.put("7", new byte[]{1, 113, 9, 5, 3});
        ledCharSet.put("8", new byte[]{54, 73, 73, 73, 54});
        ledCharSet.put("9", new byte[]{70, 73, 73, 41, 30});
        ledCharSet.put("~", new byte[]{2, 1, 2, 4, 2});
        byte[] byArray8 = new byte[5];
        byArray8[0] = 1;
        byArray8[1] = 2;
        byArray8[2] = 4;
        ledCharSet.put("`", byArray8);
        byte[] byArray9 = new byte[5];
        byArray9[2] = 111;
        ledCharSet.put("!", byArray9);
        ledCharSet.put("@", new byte[]{62, 65, 93, 85, 14});
        ledCharSet.put("#", new byte[]{20, 127, 20, 127, 20});
        ledCharSet.put("$", new byte[]{44, 42, 127, 42, 26});
        ledCharSet.put("%", new byte[]{38, 22, 8, 52, 50});
        ledCharSet.put("^", new byte[]{4, 2, 1, 2, 4});
        ledCharSet.put("&", new byte[]{54, 73, 86, 32, 80});
        ledCharSet.put("*", new byte[]{42, 28, 127, 28, 42});
        byte[] byArray10 = new byte[5];
        byArray10[2] = 62;
        byArray10[3] = 65;
        ledCharSet.put("(", byArray10);
        byte[] byArray11 = new byte[5];
        byArray11[1] = 65;
        byArray11[2] = 62;
        ledCharSet.put(")", byArray11);
        ledCharSet.put("-", new byte[]{8, 8, 8, 8, 8});
        ledCharSet.put("_", new byte[]{64, 64, 64, 64, 64});
        ledCharSet.put("+", new byte[]{8, 8, 127, 8, 8});
        ledCharSet.put("=", new byte[]{36, 36, 36, 36, 36});
        ledCharSet.put("\\", new byte[]{3, 4, 8, 16, 96});
        byte[] byArray12 = new byte[5];
        byArray12[2] = 127;
        ledCharSet.put("|", byArray12);
        byte[] byArray13 = new byte[5];
        byArray13[1] = 8;
        byArray13[2] = 54;
        byArray13[3] = 65;
        byArray13[4] = 65;
        ledCharSet.put("{", byArray13);
        byte[] byArray14 = new byte[5];
        byArray14[0] = 65;
        byArray14[1] = 65;
        byArray14[2] = 54;
        byArray14[3] = 8;
        ledCharSet.put("}", byArray14);
        byte[] byArray15 = new byte[5];
        byArray15[1] = 127;
        byArray15[2] = 65;
        byArray15[3] = 65;
        ledCharSet.put("[", byArray15);
        byte[] byArray16 = new byte[5];
        byArray16[1] = 65;
        byArray16[2] = 65;
        byArray16[3] = 127;
        ledCharSet.put("]", byArray16);
        byte[] byArray17 = new byte[5];
        byArray17[2] = 54;
        byArray17[3] = 54;
        ledCharSet.put(":", byArray17);
        byte[] byArray18 = new byte[5];
        byArray18[1] = 91;
        byArray18[2] = 59;
        ledCharSet.put(";", byArray18);
        byte[] byArray19 = new byte[5];
        byArray19[2] = 88;
        byArray19[3] = 56;
        ledCharSet.put(",", byArray19);
        byte[] byArray20 = new byte[5];
        byArray20[1] = 96;
        byArray20[2] = 96;
        ledCharSet.put(".", byArray20);
        byte[] byArray21 = new byte[5];
        byArray21[0] = 8;
        byArray21[1] = 20;
        byArray21[2] = 34;
        byArray21[3] = 65;
        ledCharSet.put("<", byArray21);
        byte[] byArray22 = new byte[5];
        byArray22[0] = 65;
        byArray22[1] = 34;
        byArray22[2] = 20;
        byArray22[3] = 8;
        ledCharSet.put(">", byArray22);
        ledCharSet.put("?", new byte[]{2, 1, 89, 5, 2});
        ledCharSet.put("/", new byte[]{96, 16, 8, 4, 3});
        byte[] byArray23 = new byte[5];
        byArray23[2] = 7;
        ledCharSet.put("'", byArray23);
        byte[] byArray24 = new byte[5];
        byArray24[1] = 7;
        byArray24[3] = 7;
        ledCharSet.put("\"", byArray24);
        ledCharSet.put("\u00e4", new byte[]{32, 85, 84, 85, 120});
        ledCharSet.put("\u00c4", new byte[]{124, 19, 18, 19, 124});
        ledCharSet.put("\u00f6", new byte[]{56, 69, 68, 69, 56});
        ledCharSet.put("\u00d6", new byte[]{60, 67, 66, 67, 60});
        ledCharSet.put("\u00fc", new byte[]{60, 65, 64, 33, 124});
        ledCharSet.put("\u00dc", new byte[]{62, 65, 64, 65, 62});
        ledCharSet.put("\u00df", new byte[]{126, 33, 73, 78, 112});
        ledCharSet.put("\u20ac", new byte[]{62, 85, 85, 65, 34});
        ledCharSet.put("\u00a9", new byte[]{62, 73, 85, 85, 62});
        byte[] byArray25 = new byte[5];
        byArray25[2] = 4;
        byArray25[3] = 2;
        byArray25[4] = 1;
        ledCharSet.put("\u00b4", byArray25);
    }

    public LEDScrollPanel(int updateRate, String scrollText, int anzChars, Color lightColor, Color darkColor) {
        super(updateRate);
        this.scrollText = scrollText;
        this.anzChars = anzChars;
        this.fullWidth = anzChars * 6;
        this.fullHeight = 8;
        this.scrollBufferIndex = 0;
        this.scrollTextIndex = -1;
        this.currentScrollLayer = new byte[anzChars + 1][];
        this.darkColor = darkColor;
        this.lightColor = lightColor;
        this.startThread();
    }

    public synchronized void setScrollTextTo(String newScrollText) {
        int i = 0;
        while (i <= this.anzChars) {
            this.currentScrollLayer[i] = null;
            ++i;
        }
        this.appendIndexMarker = -1;
        this.scrollBufferIndex = 0;
        this.scrollTextIndex = -1;
        this.scrollText = newScrollText;
    }

    public synchronized void addScrollText(String appender) {
        if (this.appendIndexMarker != -1) {
            if (this.scrollTextIndex >= this.appendIndexMarker) {
                this.scrollText = this.scrollText.substring(this.appendIndexMarker);
                this.scrollTextIndex -= this.appendIndexMarker;
            } else {
                this.scrollText = this.scrollText.substring(0, this.appendIndexMarker);
            }
        }
        this.appendIndexMarker = this.scrollText.length();
        this.scrollText = String.valueOf(this.scrollText) + appender;
    }

    protected synchronized void componentWasResized(int newTop, int newLeft, int newWidth, int newHeight) {
        this.brickWidth = newWidth / this.fullWidth;
        this.brickHeight = newHeight / this.fullHeight;
        if (this.brickWidth == 0) {
            this.brickWidth = 1;
        }
        if (this.brickHeight == 0) {
            this.brickHeight = 1;
        }
        if (this.brickWidth * this.fullWidth < newWidth) {
            this.anzChars = (int)((double)newWidth / 6.0 + 0.5) + 1;
            this.currentScrollLayer = new byte[this.anzChars + 1][];
            this.setScrollTextTo(this.scrollText);
        }
    }

    private int drawDots(Graphics g, int startIndex, int width, int x, byte[] charBuffer, int compWidth, int compHeight) {
        while (startIndex < width) {
            byte line = startIndex < 5 ? (charBuffer == null ? (byte)0 : charBuffer[startIndex]) : (byte)0;
            int x2 = x + this.brickWidth - 2;
            if (x2 < x) {
                x2 = x;
            }
            int y = 0;
            while (y < 8) {
                int c = line & 1 << y;
                g.setColor(c == 0 ? this.darkColor : this.lightColor);
                int y1 = y * this.brickHeight;
                int y2 = y1 + this.brickHeight - 2;
                if (y2 < y1) {
                    y2 = y1;
                }
                while (y1 <= y2) {
                    g.drawLine(x, y1, x2, y1);
                    ++y1;
                }
                ++y;
            }
            x += this.brickWidth;
            ++startIndex;
        }
        g.setColor(this.darkColor);
        int y = 8 * this.brickHeight;
        while (y < compHeight) {
            g.drawLine(0, y, compWidth, y);
            ++y;
        }
        return x;
    }

    protected synchronized void drawMeter(Graphics g, int newTop, int newLeft, int newWidth, int newHeight) {
        int i;
        ++this.scrollBufferIndex;
        if (this.scrollBufferIndex >= 6) {
            String c;
            byte[] newChar;
            this.scrollBufferIndex = 0;
            ++this.scrollTextIndex;
            if (this.scrollTextIndex >= this.scrollText.length()) {
                this.scrollTextIndex = 0;
            }
            if (this.appendIndexMarker != -1 && this.scrollTextIndex >= this.appendIndexMarker) {
                this.scrollText = this.scrollText.substring(this.appendIndexMarker);
                this.scrollTextIndex -= this.appendIndexMarker;
                this.appendIndexMarker = -1;
            }
            if ((newChar = ledCharSet.get(c = String.valueOf(this.scrollText.charAt(this.scrollTextIndex)))) == null) {
                newChar = ledCharSet.get("?");
            }
            i = 0;
            while (i < this.anzChars) {
                this.currentScrollLayer[i] = this.currentScrollLayer[i + 1];
                ++i;
            }
            this.currentScrollLayer[this.anzChars] = newChar;
        }
        if (g == null) {
            return;
        }
        int startIndex = this.scrollBufferIndex % 6;
        int x = 0;
        i = 0;
        while (i < this.anzChars) {
            byte[] display = this.currentScrollLayer[i];
            int start = i == 0 ? startIndex : 0;
            x = this.drawDots(g, start, 6, x, display, newWidth, newHeight);
            ++i;
        }
    }
}

