/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.system.Helpers;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UrlDialog
extends JDialog {
    private static final long serialVersionUID = 6551932234216134125L;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JButton openButton;
    private JTextField textField;
    private String url = null;

    public UrlDialog(JFrame parent, boolean modal, String url) {
        super((Frame)parent, modal);
        this.url = url;
        this.initialize();
    }

    public String getURL() {
        return this.url;
    }

    private void initialize() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Enter an Internet location to open here :");
        this.jLabel1.setFont(Helpers.DIALOG_FONT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("\"For example : http://www.server.com:8000\"");
        this.jLabel2.setFont(Helpers.DIALOG_FONT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.textField = new JTextField();
        this.textField.setColumns(10);
        this.textField.setFont(Helpers.DIALOG_FONT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.textField, gridBagConstraints);
        this.jPanel1 = new JPanel();
        this.openButton = new JButton();
        this.openButton.setMnemonic('O');
        this.openButton.setText("Open");
        this.openButton.setFont(Helpers.DIALOG_FONT);
        this.openButton.setToolTipText("Open");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UrlDialog.this.doOpen();
            }
        });
        this.jPanel1.add(this.openButton);
        this.cancelButton = new JButton();
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel");
        this.cancelButton.setFont(Helpers.DIALOG_FONT);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UrlDialog.this.doCancel();
            }
        });
        this.jPanel1.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                UrlDialog.this.doClose();
            }
        });
        this.setName("Select URL");
        this.setTitle("Select URL");
        this.setResizable(false);
        this.pack();
        if (this.url != null) {
            this.textField.setText(this.url);
        }
        this.setLocation(Helpers.getFrameCenteredLocation(this, this.getParent()));
    }

    public void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.getParent() == null) {
            System.exit(0);
        }
    }

    private void doOpen() {
        this.url = this.textField.getText();
        this.doClose();
    }

    private void doCancel() {
        this.url = null;
        this.doClose();
    }
}

