/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SimpleTextViewerDialog
extends JDialog {
    private static final long serialVersionUID = -5666092255473846658L;
    private JButton closeButton;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private URL url;

    public SimpleTextViewerDialog(JFrame owner, boolean modal, URL url) throws HeadlessException {
        super((Frame)owner, modal);
        this.url = url;
        this.initialize();
    }

    public SimpleTextViewerDialog(JFrame owner, boolean modal, String url) throws HeadlessException, MalformedURLException {
        this(owner, modal, new URL(url));
    }

    private void initialize() {
        this.setTitle("File Viewer");
        this.setName("SimpleTextFileViewer");
        this.setSize(640, 480);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SimpleTextViewerDialog.this.doClose();
            }
        });
        this.setLayout(new GridBagLayout());
        Container panel = this.getContentPane();
        panel.add((Component)this.getScrollPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 17, 1.0, 1.0));
        panel.add((Component)this.getCloseButton(), Helpers.getGridBagConstraint(0, 1, 1, 0, 0, 10, 0.0, 0.0));
        if (this.url != null) {
            this.fillTextArea();
        }
        this.setResizable(true);
        this.setLocation(Helpers.getFrameCenteredLocation(this, this.getParent()));
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setName("scrollPane_TextField");
            this.scrollPane.setViewportView(this.getTextArea());
        }
        return this.scrollPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setName("modInfo_Instruments");
            this.textArea.setEditable(false);
            try {
                InputStream is = this.getClass().getResourceAsStream("/de/quippy/javamod/multimedia/mod/ressources/lucon.ttf");
                Font font = Font.createFont(0, is);
                this.textArea.setFont(font.deriveFont(10.0f));
            }
            catch (Exception ex) {
                Log.error("Could not load font!", ex);
                this.textArea.setFont(new Font("Courier", 0, 8));
            }
        }
        return this.textArea;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setMnemonic('C');
            this.closeButton.setText("Close");
            this.closeButton.setToolTipText("Close");
            this.closeButton.setFont(Helpers.DIALOG_FONT);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SimpleTextViewerDialog.this.doClose();
                }
            });
        }
        return this.closeButton;
    }

    public void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.getParent() == null) {
            System.exit(0);
        }
    }

    private void fillTextArea() {
        block14: {
            if (this.url != null) {
                BufferedReader reader = null;
                try {
                    try {
                        String line;
                        reader = new BufferedReader(new InputStreamReader(this.url.openStream()));
                        StringBuilder fullText = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            fullText.append(line).append('\n');
                        }
                        this.getTextArea().setText(fullText.toString());
                        this.getTextArea().setSelectionStart(0);
                        this.getTextArea().setSelectionEnd(0);
                    }
                    catch (Throwable ex) {
                        Log.error("CheckForUpdate failed", ex);
                        if (reader == null) break block14;
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }
}

